/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import net.infonode.gui.CursorManager;
import net.infonode.gui.SimpleSplitPaneListener;
import net.infonode.gui.panel.SimplePanel;

public class SimpleSplitPane
extends JLayeredPane {
    private LayoutManager splitLayout = new LayoutManager(){

        public void addLayoutComponent(String string, Component component) {
        }

        public void layoutContainer(Container container) {
            if (SimpleSplitPane.this.leftComponent == null || !SimpleSplitPane.this.leftComponent.isVisible()) {
                this.maximize(SimpleSplitPane.this.rightComponent);
            } else if (SimpleSplitPane.this.rightComponent == null || !SimpleSplitPane.this.rightComponent.isVisible()) {
                this.maximize(SimpleSplitPane.this.leftComponent);
            } else {
                float f = SimpleSplitPane.this.fixDividerLocation(SimpleSplitPane.this.getDividerLocation());
                int n = SimpleSplitPane.this.getViewSize();
                int n2 = (int)((float)n * f);
                int n3 = SimpleSplitPane.this.getOtherSize();
                int n4 = SimpleSplitPane.this.getInsets().left;
                int n5 = SimpleSplitPane.this.getInsets().top;
                Dimension dimension = SimpleSplitPane.this.createSize(n2, n3);
                SimpleSplitPane.this.leftComponent.setBounds(n4, n5, (int)dimension.getWidth(), (int)dimension.getHeight());
                Point point = SimpleSplitPane.this.createPoint(n2, 0);
                dimension = SimpleSplitPane.this.createSize(SimpleSplitPane.this.dividerSize, n3);
                SimpleSplitPane.this.dividerPanel.setBounds(point.x + n4, point.y + n5, (int)dimension.getWidth(), (int)dimension.getHeight());
                point = SimpleSplitPane.this.createPoint(n2 + SimpleSplitPane.this.dividerSize, 0);
                dimension = SimpleSplitPane.this.createSize(n - n2, n3);
                SimpleSplitPane.this.rightComponent.setBounds(point.x + n4, point.y + n5, (int)dimension.getWidth(), (int)dimension.getHeight());
            }
        }

        private void maximize(Component component) {
            if (component != null && component.isVisible()) {
                Insets insets = SimpleSplitPane.this.getInsets();
                Dimension dimension = SimpleSplitPane.this.getSize();
                component.setBounds(insets.left, insets.top, dimension.width - insets.left - insets.right, dimension.height - insets.top - insets.bottom);
            }
            SimpleSplitPane.this.dividerPanel.setBounds(0, 0, 0, 0);
        }

        public Dimension minimumLayoutSize(Container container) {
            Dimension dimension = SimpleSplitPane.this.createSize((SimpleSplitPane.this.leftComponent == null ? 0 : SimpleSplitPane.this.getDimensionSize(SimpleSplitPane.this.leftComponent.getMinimumSize())) + SimpleSplitPane.this.dividerSize + (SimpleSplitPane.this.rightComponent == null ? 0 : SimpleSplitPane.this.getDimensionSize(SimpleSplitPane.this.rightComponent.getMinimumSize())), Math.max(SimpleSplitPane.this.leftComponent == null ? 0 : SimpleSplitPane.this.getOtherSize(SimpleSplitPane.this.leftComponent.getMinimumSize()), SimpleSplitPane.this.rightComponent == null ? 0 : SimpleSplitPane.this.getOtherSize(SimpleSplitPane.this.rightComponent.getMinimumSize())));
            return new Dimension(dimension.width + SimpleSplitPane.this.getInsets().left + SimpleSplitPane.this.getInsets().right, dimension.height + SimpleSplitPane.this.getInsets().top + SimpleSplitPane.this.getInsets().bottom);
        }

        public Dimension preferredLayoutSize(Container container) {
            boolean bl = SimpleSplitPane.this.leftComponent != null && SimpleSplitPane.this.leftComponent.isVisible();
            boolean bl2 = SimpleSplitPane.this.rightComponent != null && SimpleSplitPane.this.rightComponent.isVisible();
            Dimension dimension = SimpleSplitPane.this.createSize((bl ? SimpleSplitPane.this.getDimensionSize(SimpleSplitPane.this.leftComponent.getPreferredSize()) : 0) + (bl && bl2 ? SimpleSplitPane.this.dividerSize : 0) + (bl2 ? SimpleSplitPane.this.getDimensionSize(SimpleSplitPane.this.rightComponent.getPreferredSize()) : 0), Math.max(bl ? SimpleSplitPane.this.getOtherSize(SimpleSplitPane.this.leftComponent.getPreferredSize()) : 0, bl2 ? SimpleSplitPane.this.getOtherSize(SimpleSplitPane.this.rightComponent.getPreferredSize()) : 0));
            return new Dimension(dimension.width + SimpleSplitPane.this.getInsets().left + SimpleSplitPane.this.getInsets().right, dimension.height + SimpleSplitPane.this.getInsets().top + SimpleSplitPane.this.getInsets().bottom);
        }

        public void removeLayoutComponent(Component component) {
        }
    };
    private Component leftComponent;
    private Component rightComponent;
    private SimplePanel dividerPanel = new SimplePanel();
    private SimplePanel dragIndicator = new SimplePanel();
    private boolean dividerDraggable = true;
    private boolean continuousLayout = true;
    private float dragLocation;
    private boolean horizontal;
    private float dividerLocation = 0.5f;
    private int dividerSize = 6;
    private ArrayList listeners = new ArrayList(0);

    public SimpleSplitPane(boolean bl) {
        this.setLayout(this.splitLayout);
        this.add(this.dividerPanel);
        this.setHorizontal(bl);
        this.add((Component)this.dragIndicator, new Integer(1));
        this.dragIndicator.setOpaque(true);
        this.dragIndicator.setBackground(Color.DARK_GRAY);
        this.dividerPanel.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 1) {
                    CursorManager.setGlobalCursor(SimpleSplitPane.this, SimpleSplitPane.this.dividerPanel.getCursor());
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 1) {
                    CursorManager.resetGlobalCursor(SimpleSplitPane.this);
                    if (SimpleSplitPane.this.dividerDraggable && !SimpleSplitPane.this.continuousLayout) {
                        SimpleSplitPane.this.dragIndicator.setVisible(false);
                        SimpleSplitPane.this.setDividerLocation(SimpleSplitPane.this.dragLocation);
                    }
                }
            }
        });
        this.dividerPanel.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent mouseEvent) {
                if (SimpleSplitPane.this.dividerDraggable && (mouseEvent.getModifiersEx() & 0x400) != 0) {
                    float f = (float)(SimpleSplitPane.this.getPos(SimpleSplitPane.this.dividerPanel.getLocation()) - SimpleSplitPane.this.getOffset() + SimpleSplitPane.this.getPos(mouseEvent.getPoint())) / (float)SimpleSplitPane.this.getViewSize();
                    if (SimpleSplitPane.this.continuousLayout) {
                        SimpleSplitPane.this.setDividerLocation(f);
                    } else {
                        SimpleSplitPane.this.setDragIndicator(f);
                    }
                }
            }
        });
    }

    public SimpleSplitPane(boolean bl, Component component, Component component2) {
        this(bl);
        this.setLeftComponent(component);
        this.setRightComponent(component2);
    }

    public void addListener(SimpleSplitPaneListener simpleSplitPaneListener) {
        ArrayList arrayList = new ArrayList(this.listeners.size() + 1);
        arrayList.addAll(this.listeners);
        this.listeners = arrayList;
        this.listeners.add(simpleSplitPaneListener);
    }

    public JComponent getDividerPanel() {
        return this.dividerPanel;
    }

    public boolean isDividerDraggable() {
        return this.dividerDraggable;
    }

    public void setDividerDraggable(boolean bl) {
        this.dividerDraggable = bl;
        this.updateDividerCursor();
    }

    private void setDragIndicator(float f) {
        this.dragLocation = this.fixDividerLocation(f);
        this.dragIndicator.setVisible(true);
        Point point = this.createPoint((int)((float)this.getViewSize() * this.dragLocation), 0);
        Dimension dimension = this.createSize(this.dividerSize, this.getOtherSize());
        this.dragIndicator.setBounds((int)(point.getX() + (double)this.getInsets().left), (int)(point.getY() + (double)this.getInsets().top), (int)dimension.getWidth(), (int)dimension.getHeight());
    }

    private float fixDividerLocation(float f) {
        int n = this.getViewSize();
        if (n <= 0) {
            return 0.5f;
        }
        int n2 = Math.max((int)((float)n * f), this.leftComponent == null || !this.leftComponent.isVisible() ? 0 : this.getDimensionSize(this.leftComponent.getMinimumSize()));
        n2 = Math.min(n2, n - (this.rightComponent == null || !this.rightComponent.isVisible() ? 0 : this.getDimensionSize(this.rightComponent.getMinimumSize())));
        return (float)n2 / (float)n;
    }

    public void setContinuousLayout(boolean bl) {
        this.continuousLayout = bl;
    }

    public boolean isContinuousLayout() {
        return this.continuousLayout;
    }

    public int getDividerSize() {
        return this.dividerSize;
    }

    public void setDividerSize(int n) {
        this.dividerSize = n;
        this.revalidate();
    }

    private int getOffset() {
        return this.horizontal ? this.getInsets().left : this.getInsets().top;
    }

    private int getOtherSize() {
        return this.horizontal ? this.getHeight() - this.getInsets().top - this.getInsets().bottom : this.getWidth() - this.getInsets().left - this.getInsets().right;
    }

    private int getViewSize() {
        return this.getDimensionSize(this.getSize()) - this.dividerSize - (this.horizontal ? this.getInsets().left + this.getInsets().right : this.getInsets().top + this.getInsets().bottom);
    }

    private int getDimensionSize(Dimension dimension) {
        return (int)(this.horizontal ? dimension.getWidth() : dimension.getHeight());
    }

    private int getOtherSize(Dimension dimension) {
        return (int)(this.horizontal ? dimension.getHeight() : dimension.getWidth());
    }

    private int getPos(Point point) {
        return (int)(this.horizontal ? point.getX() : point.getY());
    }

    private Dimension createSize(int n, int n2) {
        return this.horizontal ? new Dimension(n, n2) : new Dimension(n2, n);
    }

    private Point createPoint(int n, int n2) {
        return this.horizontal ? new Point(n, n2) : new Point(n2, n);
    }

    public boolean isHorizontal() {
        return this.horizontal;
    }

    public void setHorizontal(boolean bl) {
        this.horizontal = bl;
        this.updateDividerCursor();
        this.revalidate();
    }

    public float getDividerLocation() {
        return this.dividerLocation;
    }

    public void setDividerLocation(float f) {
        this.dividerLocation = f;
        this.revalidate();
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((SimpleSplitPaneListener)this.listeners.get(i)).dividerLocationChanged(this);
        }
    }

    public Component getLeftComponent() {
        return this.leftComponent;
    }

    public void setLeftComponent(Component component) {
        if (this.leftComponent != null) {
            this.remove(this.leftComponent);
        }
        this.leftComponent = component;
        if (component != null) {
            this.add(component);
        }
        this.revalidate();
    }

    public Component getRightComponent() {
        return this.rightComponent;
    }

    public void setRightComponent(Component component) {
        if (this.rightComponent != null) {
            this.remove(this.rightComponent);
        }
        this.rightComponent = component;
        if (component != null) {
            this.add(component);
        }
        this.revalidate();
    }

    private void updateDividerCursor() {
        this.dividerPanel.setCursor(this.dividerDraggable ? new Cursor(this.horizontal ? 10 : 8) : Cursor.getDefaultCursor());
    }

    public void setComponents(Component component, Component component2) {
        this.setLeftComponent(component);
        this.setRightComponent(component2);
    }
}

