/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.gui;

import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import net.infonode.gui.DynamicUIManagerListener;

public class DynamicUIManager {
    private static final DynamicUIManager instance = new DynamicUIManager();
    private ArrayList listeners = new ArrayList(2);
    private String[] properties = new String[]{"win.3d.backgroundColor", "win.3d.highlightColor", "win.3d.lightColor", "win.3d.shadowColor", "win.frame.activeCaptionColor", "win.frame.activeCaptionGradientColor", "win.frame.captionTextColor", "win.frame.activeBorderColor", "win.mdi.backgroundColor", "win.desktop.backgroundColor", "win.frame.inactiveCaptionColor", "win.frame.inactiveCaptionGradientColor", "win.frame.inactiveCaptionTextColor", "win.frame.inactiveBorderColor", "win.menu.backgroundColor", "win.menu.textColor", "win.frame.textColor?????", "win.item.highlightColor", "win.item.highlightTextColor", "win.tooltip.backgroundColor", "win.tooltip.textColor", "win.frame.backgroundColor", "win.frame.textColor", "win.item.hotTrackedColor"};
    private Toolkit currentToolkit;
    private boolean propertyChangePending;

    public static DynamicUIManager getInstance() {
        return instance;
    }

    private DynamicUIManager() {
        final PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                DynamicUIManager.this.firePropertyChange();
            }
        };
        UIManager.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("lookAndFeel")) {
                    DynamicUIManager.this.setupPropertyListener(propertyChangeListener);
                    DynamicUIManager.this.fireLookAndFeelChanged();
                }
            }
        });
        UIManager.getDefaults().addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (!(propertyChangeEvent.getNewValue() instanceof Class)) {
                    DynamicUIManager.this.firePropertyChange();
                }
            }
        });
        this.setupPropertyListener(propertyChangeListener);
    }

    private void setupPropertyListener(PropertyChangeListener propertyChangeListener) {
        int n;
        if (this.currentToolkit != null) {
            for (n = 0; n < this.properties.length; ++n) {
                this.currentToolkit.removePropertyChangeListener(this.properties[n], propertyChangeListener);
            }
        }
        this.currentToolkit = Toolkit.getDefaultToolkit();
        for (n = 0; n < this.properties.length; ++n) {
            this.currentToolkit.addPropertyChangeListener(this.properties[n], propertyChangeListener);
        }
    }

    public void addListener(DynamicUIManagerListener dynamicUIManagerListener) {
        this.listeners.add(dynamicUIManagerListener);
    }

    public void removeListener(DynamicUIManagerListener dynamicUIManagerListener) {
        this.listeners.remove(dynamicUIManagerListener);
    }

    private void fireLookAndFeelChanged() {
        Object[] objectArray = this.listeners.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            ((DynamicUIManagerListener)objectArray[i]).lookAndFeelChanged();
        }
    }

    private void firePropertyChange() {
        if (!this.propertyChangePending) {
            this.propertyChangePending = true;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DynamicUIManager.this.propertyChangePending = false;
                    Object[] objectArray = DynamicUIManager.this.listeners.toArray();
                    for (int i = 0; i < objectArray.length; ++i) {
                        ((DynamicUIManagerListener)objectArray[i]).propertiesChanged();
                    }
                }
            });
        }
    }
}

