/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.docking;

import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.dnd.DragSource;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import net.infonode.docking.DockingWindow;
import net.infonode.docking.RootWindow;
import net.infonode.docking.drag.DockingWindowDragger;
import net.infonode.docking.internalutil.DropAction;
import net.infonode.gui.CursorManager;

class WindowDragger
implements DockingWindowDragger {
    private DockingWindow dragWindow;
    private DropAction dropAction;
    private RootWindow rootWindow;

    WindowDragger(DockingWindow dockingWindow) {
        this(dockingWindow, dockingWindow.getRootWindow());
    }

    WindowDragger(DockingWindow dockingWindow, RootWindow rootWindow) {
        this.dragWindow = dockingWindow;
        this.rootWindow = rootWindow;
    }

    public DockingWindow getDragWindow() {
        return this.dragWindow;
    }

    public RootWindow getDropTarget() {
        return this.rootWindow;
    }

    void undoDrag(DropAction dropAction) {
        if (this.dropAction != null) {
            this.dropAction.clear(this.dragWindow, dropAction);
            this.dropAction = null;
        }
    }

    private void stopDrag() {
        CursorManager.resetGlobalCursor(this.dragWindow);
        this.rootWindow.setDragText(null, null);
        this.rootWindow.setDragRectangle(null);
    }

    public void abortDrag() {
        this.stopDrag();
        this.undoDrag(null);
    }

    public void dropWindow(MouseEvent mouseEvent) {
        this.stopDrag();
        if (this.dragWindow != null && this.dropAction != null) {
            this.dropAction.execute(this.dragWindow, mouseEvent);
        }
    }

    public void dragWindow(MouseEvent mouseEvent) {
        Point point;
        DockingWindow dockingWindow;
        this.rootWindow.setDragRectangle(null);
        Point point2 = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getPoint(), this.rootWindow);
        for (dockingWindow = this.getDeepestWindowAt(this.rootWindow, point2.x, point2.y); dockingWindow != null && dockingWindow.getWindowParent() != null; dockingWindow = dockingWindow.getWindowParent()) {
            point = SwingUtilities.convertPoint(this.rootWindow, point2, dockingWindow.getWindowParent());
            if (!dockingWindow.getWindowParent().contains(point)) break;
        }
        point = dockingWindow != null ? dockingWindow.acceptDrop(SwingUtilities.convertPoint(this.rootWindow, point2, dockingWindow), this.dragWindow) : null;
        this.undoDrag((DropAction)((Object)point));
        CursorManager.setGlobalCursor(this.dragWindow, point == null ? DragSource.DefaultMoveNoDrop : DragSource.DefaultMoveDrop);
        this.rootWindow.setDragText(point == null || ((DropAction)((Object)point)).showTitle() ? point2 : null, this.dragWindow.getTitle());
        this.dropAction = point;
    }

    private DockingWindow getDeepestWindowAt(Component component, int n, int n2) {
        Object object;
        if (component == null || !component.isVisible() || !component.contains(n, n2)) {
            return null;
        }
        if (component instanceof Container) {
            object = ((Container)component).getComponents();
            for (int i = 0; i < ((Object)object).length; ++i) {
                DockingWindow dockingWindow = this.getDeepestWindowAt((Component)object[i], n - ((Component)object[i]).getX(), n2 - ((Component)object[i]).getY());
                if (dockingWindow == null) continue;
                return dockingWindow;
            }
        }
        if (component instanceof DockingWindow) {
            object = (DockingWindow)component;
            return ((DockingWindow)object).getRootWindow() == this.rootWindow ? object : null;
        }
        return null;
    }
}

