/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.docking;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.ref.WeakReference;
import java.util.List;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import net.infonode.docking.DockingWindow;
import net.infonode.docking.RootWindow;
import net.infonode.docking.TabWindow;
import net.infonode.docking.internal.ReadContext;
import net.infonode.docking.internal.WriteContext;
import net.infonode.docking.internalutil.DropAction;
import net.infonode.docking.location.NullLocation;
import net.infonode.docking.location.WindowLocation;
import net.infonode.docking.model.ViewItem;
import net.infonode.docking.model.ViewWriter;
import net.infonode.docking.properties.ViewProperties;
import net.infonode.gui.ComponentUtil;
import net.infonode.gui.panel.SimplePanel;
import net.infonode.properties.base.Property;
import net.infonode.properties.propertymap.PropertyMap;
import net.infonode.properties.propertymap.PropertyMapManager;
import net.infonode.properties.propertymap.PropertyMapWeakListenerManager;
import net.infonode.properties.util.PropertyChangeListener;
import net.infonode.util.StreamUtil;

public class View
extends DockingWindow {
    private Component lastFocusedComponent;
    private HierarchyListener focusComponentListener = new HierarchyListener(){

        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            View.this.checkLastFocusedComponent();
        }
    };
    private SimplePanel contentPanel = new SimplePanel();
    private ViewProperties rootProperties = new ViewProperties();
    private WeakReference lastRootWindow;
    private PropertyChangeListener listener = new PropertyChangeListener(){

        public void propertyChanged(Property property, Object object, Object object2, Object object3) {
            View.this.fireTitleChanged();
        }
    };
    static /* synthetic */ Class class$net$infonode$docking$View;

    public View(String string, Icon icon, Component component) {
        super(new ViewItem());
        this.rootProperties.setTitle(string);
        this.rootProperties.setIcon(icon);
        this.getViewProperties().addSuperObject(this.rootProperties);
        super.setComponent(this.contentPanel);
        this.contentPanel.setComponent(component);
        PropertyMapWeakListenerManager.addWeakPropertyChangeListener(this.getViewProperties().getMap(), ViewProperties.TITLE, this.listener);
        PropertyMapWeakListenerManager.addWeakPropertyChangeListener(this.getViewProperties().getMap(), ViewProperties.ICON, this.listener);
        this.init();
    }

    public List getCustomTabComponents() {
        return this.getTab().getCustomTabComponentsList();
    }

    public Component getComponent() {
        return this.contentPanel.getComponent(0);
    }

    public void setComponent(Component component) {
        this.contentPanel.setComponent(component);
    }

    public ViewProperties getViewProperties() {
        return ((ViewItem)this.getWindowItem()).getViewProperties();
    }

    protected void update() {
    }

    public DockingWindow getChildWindow(int n) {
        return null;
    }

    public int getChildWindowCount() {
        return 0;
    }

    protected WindowLocation getWindowLocation(DockingWindow dockingWindow) {
        return NullLocation.INSTANCE;
    }

    void setLastFocusedComponent(Component component) {
        if (component != this.lastFocusedComponent) {
            if (this.lastFocusedComponent != null) {
                this.lastFocusedComponent.removeHierarchyListener(this.focusComponentListener);
            }
            this.lastFocusedComponent = component;
            if (this.lastFocusedComponent != null) {
                this.lastFocusedComponent.addHierarchyListener(this.focusComponentListener);
            }
        }
    }

    Component getFocusComponent() {
        this.checkLastFocusedComponent();
        return this.lastFocusedComponent;
    }

    public boolean isFocusCycleRoot() {
        return true;
    }

    public void restoreFocus() {
        this.makeVisible();
        this.checkLastFocusedComponent();
        if (this.lastFocusedComponent == null) {
            ComponentUtil.smartRequestFocus(this.contentPanel);
        } else {
            this.lastFocusedComponent.requestFocusInWindow();
        }
    }

    public Icon getIcon() {
        return this.getViewProperties().getIcon();
    }

    protected void doReplace(DockingWindow dockingWindow, DockingWindow dockingWindow2) {
        throw new RuntimeException((class$net$infonode$docking$View == null ? (class$net$infonode$docking$View = View.class$("net.infonode.docking.View")) : class$net$infonode$docking$View) + ".replaceChildWindow called!");
    }

    protected void doRemoveWindow(DockingWindow dockingWindow) {
        throw new RuntimeException((class$net$infonode$docking$View == null ? (class$net$infonode$docking$View = View.class$("net.infonode.docking.View")) : class$net$infonode$docking$View) + ".removeChildWindow called!");
    }

    protected void write(ObjectOutputStream objectOutputStream, WriteContext writeContext) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream2 = new ObjectOutputStream(byteArrayOutputStream);
        writeContext.getViewSerializer().writeView(this, objectOutputStream2);
        this.getWindowItem().writeSettings(objectOutputStream2, writeContext);
        objectOutputStream2.close();
        objectOutputStream.writeInt(byteArrayOutputStream.size());
        byteArrayOutputStream.writeTo(objectOutputStream);
    }

    static View read(ObjectInputStream objectInputStream, ReadContext readContext) throws IOException {
        int n = objectInputStream.readInt();
        byte[] byArray = new byte[n];
        StreamUtil.readAll(objectInputStream, byArray);
        ObjectInputStream objectInputStream2 = new ObjectInputStream(new ByteArrayInputStream(byArray));
        View view = readContext.getViewSerializer().readView(objectInputStream2);
        if (view != null) {
            view.getWindowItem().readSettings(objectInputStream2, readContext);
        }
        return view;
    }

    protected DropAction doAcceptDrop(Point point, DockingWindow dockingWindow) {
        return this.getWindowParent() instanceof TabWindow && this.getWindowParent().getChildWindowCount() == 1 ? null : super.doAcceptDrop(point, dockingWindow);
    }

    public String toString() {
        return this.getTitle();
    }

    void setRootWindow(RootWindow rootWindow) {
        if (rootWindow != null) {
            RootWindow rootWindow2;
            if (this.lastRootWindow != null && (rootWindow2 = (RootWindow)this.lastRootWindow.get()) != null) {
                rootWindow2.removeView(this);
            }
            this.lastRootWindow = new WeakReference<RootWindow>(rootWindow);
            rootWindow.addView(this);
        }
    }

    protected void rootChanged(final RootWindow rootWindow, final RootWindow rootWindow2) {
        super.rootChanged(rootWindow, rootWindow2);
        this.setRootWindow(rootWindow2);
        PropertyMapManager.runBatch(new Runnable(){

            public void run() {
                if (rootWindow != null) {
                    View.this.rootProperties.removeSuperObject(rootWindow.getRootWindowProperties().getViewProperties());
                }
                if (rootWindow2 != null) {
                    View.this.rootProperties.addSuperObject(rootWindow2.getRootWindowProperties().getViewProperties());
                }
            }
        });
    }

    protected PropertyMap getPropertyObject() {
        return this.getViewProperties().getMap();
    }

    protected PropertyMap createPropertyObject() {
        return new ViewProperties().getMap();
    }

    protected boolean needsTitleWindow() {
        return this.getViewProperties().getAlwaysShowTitle();
    }

    private void checkLastFocusedComponent() {
        if (this.lastFocusedComponent != null && !SwingUtilities.isDescendingFrom(this.lastFocusedComponent, this)) {
            this.lastFocusedComponent.removeHierarchyListener(this.focusComponentListener);
            this.lastFocusedComponent = null;
        }
    }

    void removeWindowComponent(DockingWindow dockingWindow) {
    }

    void restoreWindowComponent(DockingWindow dockingWindow) {
    }

    protected void write(ObjectOutputStream objectOutputStream, WriteContext writeContext, ViewWriter viewWriter) throws IOException {
        objectOutputStream.writeInt(1);
        viewWriter.writeView(this, objectOutputStream, writeContext);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

