/*
 * Decompiled with CFR 0.152.
 */
package madkit.pluginmanager;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;

class SettingsFrame
extends JPanel {
    public static final int OK_OPTION = 0;
    public static final int CANCEL_OPTION = 1;
    private int _selectedOption = 1;
    private Properties _props = new Properties();
    private JTextField _username;
    private JTextField _useremail;
    private JTextField _proxyhost;
    private JSpinner _proxyport;
    private JDialog _dialog;

    public SettingsFrame() {
        this(true);
    }

    public SettingsFrame(boolean bl) {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(new TitledBorder("Proxy"));
        jPanel2.setLayout(new BorderLayout());
        JLabel jLabel = new JLabel("Host");
        JLabel jLabel2 = new JLabel("Port");
        jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(2, 1));
        jPanel.add(jLabel);
        jPanel.add(jLabel2);
        jPanel2.add((Component)jPanel, "West");
        this._proxyhost = new JTextField();
        this._proxyport = new JSpinner(new SpinnerNumberModel(8080, 1, 65536, 1));
        jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(2, 1));
        jPanel.add(this._proxyhost);
        jPanel.add(this._proxyport);
        jPanel2.add((Component)jPanel, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(new TitledBorder("User Information"));
        jPanel3.setLayout(new BorderLayout());
        JLabel jLabel3 = new JLabel("Your Name ");
        JLabel jLabel4 = new JLabel("Your E-Mail ");
        jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(2, 1));
        jPanel.add(jLabel3);
        jPanel.add(jLabel4);
        jPanel3.add((Component)jPanel, "West");
        this._username = new JTextField();
        this._useremail = new JTextField();
        jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(2, 1));
        jPanel.add(this._username);
        jPanel.add(this._useremail);
        jPanel3.add((Component)jPanel, "Center");
        String string = "<html>Important:<br>Your information will be sent to the Downlaod Source as username (your name) and passaword(your email)<br><html>";
        JLabel jLabel5 = new JLabel(string);
        jPanel3.add((Component)jLabel5, "South");
        jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(jPanel3);
        jPanel.add(jPanel2);
        this.add((Component)jPanel, "Center");
        if (bl) {
            JPanel jPanel4 = new JPanel();
            JButton jButton = new JButton("Accept");
            jButton.addActionListener(new Ok());
            JButton jButton2 = new JButton("Cancel");
            jButton2.addActionListener(new Cancel());
            jPanel4.add(jButton);
            jPanel4.add(jButton2);
            this.add((Component)jPanel4, "South");
        } else {
            this._selectedOption = 0;
        }
    }

    public synchronized int showSettings(Properties properties) {
        this._props = properties;
        this._proxyhost.setText(properties.getProperty("http.proxyHost"));
        this._username.setText(properties.getProperty("madkit.user.name"));
        this._useremail.setText(properties.getProperty("madkit.user.email"));
        String string = properties.getProperty("http.proxyPort");
        if (string == null || string.equals("")) {
            string = "8080";
        }
        this._proxyport.setValue(Integer.valueOf(string));
        this.setVisible(true);
        this._dialog = new JDialog();
        this._dialog.getContentPane().add(this);
        this._dialog.setModal(true);
        this._dialog.pack();
        this._dialog.show();
        this._dialog.dispose();
        return this._selectedOption;
    }

    public Properties getSelectedConfig() {
        if (this._selectedOption == 0) {
            this._props.setProperty("http.proxyHost", this._proxyhost.getText());
            this._props.setProperty("http.proxyPort", ((Integer)this._proxyport.getValue()).toString());
            this._props.setProperty("madkit.user.name", this._username.getText());
            this._props.setProperty("madkit.user.email", this._useremail.getText());
        }
        return this._props;
    }

    public static Properties showSettingsDialog(File file) throws FileNotFoundException, IOException {
        Properties properties = new Properties();
        properties.load(new FileInputStream(file));
        SettingsFrame settingsFrame = new SettingsFrame();
        int n = settingsFrame.showSettings(properties);
        if (n == 0) {
            properties.store(new FileOutputStream(file), "PluginManager Configuration file.");
            return properties;
        }
        return null;
    }

    private class Close
    extends WindowAdapter {
        private Close() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            new Cancel().actionPerformed(null);
        }
    }

    private class Cancel
    implements ActionListener {
        private Cancel() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SettingsFrame.this._selectedOption = 1;
            SettingsFrame.this._dialog.dispose();
        }
    }

    private class Clear
    implements ActionListener {
        private Clear() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SettingsFrame.this._username.setText("");
            SettingsFrame.this._useremail.setText("");
            SettingsFrame.this._proxyhost.setText("");
            SettingsFrame.this._proxyport.setValue(new Integer(8080));
            SettingsFrame.this._username.requestFocus();
        }
    }

    private class Ok
    implements ActionListener {
        private Ok() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SettingsFrame.this._selectedOption = 0;
            SettingsFrame.this._dialog.dispose();
        }
    }
}

