/*
 * Decompiled with CFR 0.152.
 */
package madkit.pluginmanager;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import madkit.pluginmanager.DownloadStatus;
import madkit.pluginmanager.DownloadTableCellRenderer;
import madkit.pluginmanager.DownloadsTableModel;
import madkit.pluginmanager.ProgressAgent;

class ProgressGUI
extends JPanel {
    private JTable _table;
    private DownloadsTableModel _model;
    private ProgressAgent _agent;

    public ProgressGUI(ProgressAgent progressAgent) {
        this._agent = progressAgent;
        this.setLayout(new BorderLayout());
        this._table = this.setupTable();
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(this._table);
        this.add((Component)jScrollPane, "Center");
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton("Hide");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProgressGUI.this._agent.hide(true);
            }
        });
        jPanel.add(jButton);
        this.add((Component)jPanel, "South");
    }

    private JTable setupTable() {
        JTable jTable = new JTable();
        this._model = new DownloadsTableModel();
        jTable.setModel(this._model);
        TableColumn tableColumn = jTable.getColumnModel().getColumn(1);
        tableColumn.setCellRenderer(new DownloadTableCellRenderer());
        return jTable;
    }

    public void refresh() {
        this._model.fireTableDataChanged();
    }

    public void updateStatus(DownloadStatus downloadStatus) {
        this._model.addDownloading(downloadStatus.getPluginName(), downloadStatus);
        this._model.fireTableDataChanged();
    }
}

