/*
 * Decompiled with CFR 0.152.
 */
package madkit.pluginmanager;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.Timer;
import madkit.pluginmanager.ObservableProcess;

class ProcessMonitor
extends JDialog {
    private JProgressBar _currentProcess;
    private JProgressBar _globalProcess;
    private JLabel _currNote;
    private Timer _timer;
    private ObservableProcess _process;

    public ProcessMonitor(Component component, ObservableProcess observableProcess) {
        super(JOptionPane.getFrameForComponent(component), false);
        this.setLocationRelativeTo(component);
        this._process = observableProcess;
        this.getContentPane().setLayout(new BorderLayout());
        JLabel jLabel = new JLabel(this._process.getGlobalProcessNote());
        this._currNote = new JLabel();
        this._currentProcess = new JProgressBar(0, this._process.getCurrentProcessMax());
        this._globalProcess = new JProgressBar(0, this._process.getGlobalProcessMax());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(jLabel);
        jPanel.add(this._globalProcess);
        jPanel.add(this._currNote);
        jPanel.add(this._currentProcess);
        this.getContentPane().add((Component)jPanel, "Center");
        JLabel jLabel2 = new JLabel();
        URL uRL = this.getClass().getResource("/images/update.gif");
        if (uRL != null) {
            jLabel2.setIcon(new ImageIcon(uRL));
        }
        this.getContentPane().add((Component)jLabel2, "West");
        this.pack();
    }

    public synchronized void showProgressDialog() {
        this.setSize(300, 100);
        this._timer = new Timer(100, new TimerListener());
        this._timer.start();
        this.setVisible(true);
    }

    class TimerListener
    implements ActionListener {
        TimerListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (ProcessMonitor.this._process.isGlobalProcessFinished()) {
                ProcessMonitor.this.dispose();
                ProcessMonitor.this._timer.stop();
                ProcessMonitor.this._timer = null;
            } else {
                ProcessMonitor.this._currNote.setText(ProcessMonitor.this._process.getCurrentProcessNote());
                ProcessMonitor.this._currentProcess.setValue(ProcessMonitor.this._process.getCurrentProcessStatus());
                ProcessMonitor.this._globalProcess.setValue(ProcessMonitor.this._process.getGlobalProcessStatus());
            }
        }
    }
}

