/*
 * Decompiled with CFR 0.152.
 */
package madkit.pluginmanager;

import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import madkit.pluginmanager.ManagerAgent;
import madkit.pluginmanager.PluginInformation;

class PluginsTableModel
extends AbstractTableModel {
    ManagerAgent _agent;
    String _category;
    static final int PLUGIN_NAME = 0;
    static final int INSTALL = 1;
    static final int DOC = 2;
    static final int SRC = 3;
    private String[] _columnNames = new String[]{"Plugin", "Binary", "Docs", "Sources"};

    public PluginsTableModel(ManagerAgent managerAgent, String string) {
        this._agent = managerAgent;
        this._category = string;
    }

    public void upgrade() {
        this._agent.upgrade();
    }

    public int getRowCount() {
        if (this._agent == null || this._agent._list == null) {
            return 0;
        }
        return this._agent._list.getPluginsByCategory(this._category).size();
    }

    public int getColumnCount() {
        if (this._category.equals("bundle")) {
            return 2;
        }
        return this._columnNames.length;
    }

    public Object getValueAt(int n, int n2) {
        Object object = null;
        Vector vector = new Vector(this._agent._list.getPluginsByCategory(this._category));
        String string = (String)vector.get(n);
        switch (n2) {
            case 0: {
                object = string.toString();
                break;
            }
            case 1: {
                object = new Boolean(this._agent.isGoingToInstall(string));
                break;
            }
            case 2: {
                object = new Boolean(this._agent.isGoingToInstall(string + "-doc"));
                break;
            }
            case 3: {
                object = new Boolean(this._agent.isGoingToInstall(string + "-src"));
                break;
            }
        }
        return object;
    }

    int getStatus(String string) {
        return this._agent._list.status(string);
    }

    String getPluginNameForColumn(int n, int n2) {
        String string = (String)this.getValueAt(n, 0);
        switch (n2) {
            case 1: {
                string = (String)this.getValueAt(n, 0);
                break;
            }
            case 2: {
                string = (String)this.getValueAt(n, 0) + "-doc";
                break;
            }
            case 3: {
                string = (String)this.getValueAt(n, 0) + "-src";
                break;
            }
        }
        return string;
    }

    public String getColumnName(int n) {
        return this._columnNames[n];
    }

    public boolean isCellEditable(int n, int n2) {
        if (n2 != 0) {
            PluginInformation pluginInformation = this._agent._list.getPlugin(this.getPluginNameForColumn(n, n2));
            return pluginInformation != null;
        }
        return false;
    }

    public Class getColumnClass(int n) {
        return this.getValueAt(0, n).getClass();
    }

    public void setValueAt(Object object, int n, int n2) {
        if (n2 != 0 && object instanceof Boolean) {
            String string = (String)this.getValueAt(n, 0);
            boolean bl = (Boolean)object;
            if (n2 == 2) {
                string = string + "-doc";
            }
            if (n2 == 3) {
                string = string + "-src";
            }
            if (bl) {
                this._agent.markForInstall(string);
            } else {
                this._agent.removeFromInstall(string);
            }
        }
    }
}

