/*
 * Decompiled with CFR 0.152.
 */
package madkit.pluginmanager;

import java.awt.Font;
import java.awt.GridLayout;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import madkit.pluginmanager.InstallStep;

class InstallIndex
extends JPanel {
    Collection _steps = new Vector();
    int _currentStep = 0;
    Hashtable _labels = new Hashtable();
    Font _currentFont = new Font("Serial", 1, 12);
    Font _normalFont = new Font("Serial", 2, 10);
    ImageIcon doneIcon = new ImageIcon(this.getClass().getResource("/images/stepfinished.png"));
    ImageIcon togoIcon = new ImageIcon(this.getClass().getResource("/images/togo.png"));

    public void next() {
        if (this._currentStep < this._steps.size() - 1) {
            this.setFont(this._currentStep, this._normalFont);
            this.setDoneStep(this._currentStep, true);
            ++this._currentStep;
            this.setFont(this._currentStep, this._currentFont);
            this.getStep(this._currentStep).activate();
        }
    }

    private InstallStep getStep(int n) {
        return (InstallStep)this._steps.toArray()[n];
    }

    private void setDoneStep(int n, boolean bl) {
        if (bl) {
            ((JLabel)this._labels.get(((InstallStep)this._steps.toArray()[n]).getName())).setIcon(this.doneIcon);
        } else {
            ((JLabel)this._labels.get(((InstallStep)this._steps.toArray()[n]).getName())).setIcon(this.togoIcon);
        }
    }

    public void back() {
        if (this._currentStep > 0) {
            this.setFont(this._currentStep, this._normalFont);
            this.setDoneStep(this._currentStep, false);
            --this._currentStep;
            this.setFont(this._currentStep, this._currentFont);
        }
    }

    private void setFont(int n, Font font) {
        ((JLabel)this._labels.get(((InstallStep)this._steps.toArray()[n]).getName())).setFont(font);
    }

    public boolean isLastStep() {
        return this._currentStep == this._steps.size() - 1;
    }

    void init() {
        this.setLayout(new GridLayout(this._steps.size(), 1));
        for (InstallStep installStep : this._steps) {
            JLabel jLabel = new JLabel(installStep.getDisplayString());
            jLabel.setToolTipText(installStep.getShortDescription());
            jLabel.setFont(this._normalFont);
            jLabel.setIcon(this.togoIcon);
            this.add(jLabel);
            this._labels.put(installStep.getName(), jLabel);
        }
        ((JLabel)this._labels.get(((InstallStep)this._steps.toArray()[this._currentStep]).getName())).setFont(this._currentFont);
    }

    public void addInstallStep(InstallStep installStep) {
        this._steps.add(installStep);
    }

    public InstallStep getCurrentStep() {
        return (InstallStep)this._steps.toArray()[this._currentStep];
    }

    public Collection getSteps() {
        return this._steps;
    }
}

