/*
 * Decompiled with CFR 0.152.
 */
package madkit.designer;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import madkit.TreeTools.ExplorerTree;
import madkit.TreeTools.FileIconDescriptor;
import madkit.TreeTools.FileNode;
import madkit.TreeTools.GenericTreeNode;
import madkit.boot.Madkit;
import madkit.designer.AntFileNode;
import madkit.designer.BeanShellAgentNode;
import madkit.designer.ConfigFileNode;
import madkit.designer.EditableFileNode;
import madkit.designer.FormalismNode;
import madkit.designer.HTMLFileNode;
import madkit.designer.JavaAgentNode;
import madkit.designer.JessAgentNode;
import madkit.designer.PluginDesignerAgent;
import madkit.designer.PluginDesignerGUI;
import madkit.designer.PluginNode;
import madkit.designer.PluginTopNode;
import madkit.designer.PropertyFileNode;
import madkit.designer.PythonAgentNode;
import madkit.designer.SEditFileNode;
import madkit.designer.SchemeAgentNode;
import madkit.kernel.AbstractAgent;
import madkit.kernel.Utils;
import madkit.system.PluginInformation;
import madkit.utils.common.PropertyFile;

class PluginTree
extends ExplorerTree {
    PluginDesignerGUI gui;
    PluginDesignerAgent ag;
    Map plugins;

    public PluginTree(PluginDesignerGUI pluginDesignerGUI, PluginDesignerAgent pluginDesignerAgent) {
        this.gui = pluginDesignerGUI;
        this.ag = pluginDesignerAgent;
        this.setLocalRoot(new PluginTopNode("plugins"));
        this.rootPath = System.getProperty("madkit.dir") + File.separator;
        this.top.add((MutableTreeNode)this.getLocalRoot());
        this.buildTree(this.getLocalRoot(), pluginDesignerAgent.getPlugins());
        this.installTree();
    }

    protected void buildTree(GenericTreeNode genericTreeNode, Map map) {
        this.plugins = map;
        this.installAllPlugins(genericTreeNode);
    }

    public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) {
        int n = treeExpansionEvent.getPath().getPathCount();
        if (n > 2) {
            GenericTreeNode genericTreeNode = (GenericTreeNode)treeExpansionEvent.getPath().getLastPathComponent();
            genericTreeNode.removeAllChildren();
            File file = new File(this.getPath(treeExpansionEvent.getPath().getPath()));
            this.buildExplorerTree(genericTreeNode, file);
        }
    }

    void buildTreeFromNode(GenericTreeNode genericTreeNode, File file) {
        this.buildExplorerTree(genericTreeNode, file);
    }

    void reload(GenericTreeNode genericTreeNode) {
        this.treeModel.reload((TreeNode)genericTreeNode);
    }

    void installAllPlugins(GenericTreeNode genericTreeNode) {
        Set set = this.plugins.keySet();
        for (String string : set) {
            PluginInformation pluginInformation = (PluginInformation)this.plugins.get(string);
            PluginNode pluginNode = new PluginNode(string, pluginInformation, this.gui);
            genericTreeNode.add((MutableTreeNode)((Object)pluginNode));
            pluginNode.add((MutableTreeNode)new GenericTreeNode("toto"));
        }
    }

    void addPlugin(String string, PluginInformation pluginInformation) {
        PluginNode pluginNode = new PluginNode(string, pluginInformation, this.gui);
        this.addNode((DefaultMutableTreeNode)this.getLocalRoot(), (DefaultMutableTreeNode)((Object)pluginNode));
        pluginNode.add((MutableTreeNode)new GenericTreeNode("toto"));
        this.gui.setPluginNode(string, pluginNode);
    }

    protected void buildFileTree(GenericTreeNode genericTreeNode, File file) {
        Object object = null;
        String string = FileIconDescriptor.getPathExtens((String)file.getName());
        object = string != null ? (string.equalsIgnoreCase("class") || string.equalsIgnoreCase("bak") || file.getName().endsWith("~") || file.getName().endsWith("#") || string.equalsIgnoreCase("bat") || string.equalsIgnoreCase("sh") ? null : (string.equalsIgnoreCase("py") ? new PythonAgentNode((AbstractAgent)this.ag, file) : (string.equalsIgnoreCase("bsh") ? new BeanShellAgentNode((AbstractAgent)this.ag, file) : (string.equalsIgnoreCase("scm") ? new SchemeAgentNode((AbstractAgent)this.ag, file) : (string.equalsIgnoreCase("clp") ? new JessAgentNode((AbstractAgent)this.ag, file) : (string.equalsIgnoreCase("fml") ? new FormalismNode((AbstractAgent)this.ag, file) : (string.equalsIgnoreCase("cfg") ? new ConfigFileNode((AbstractAgent)this.ag, file) : (string.equalsIgnoreCase("sed") ? new SEditFileNode((AbstractAgent)this.ag, file) : (string.equalsIgnoreCase("html") || string.equalsIgnoreCase("htm") ? new HTMLFileNode((AbstractAgent)this.ag, file) : (file.getName().endsWith("build.xml") ? new AntFileNode((AbstractAgent)this.ag, file) : (string.equalsIgnoreCase("xml") || string.equalsIgnoreCase("txt") || string.equalsIgnoreCase("java") ? new EditableFileNode((AbstractAgent)this.ag, file) : (string.equalsIgnoreCase("properties") ? (!this.processPropertyFileNode((AbstractAgent)this.ag, file, genericTreeNode) ? new PropertyFileNode((AbstractAgent)this.ag, file) : null) : new FileNode(file))))))))))))) : new FileNode(file);
        if (object != null) {
            genericTreeNode.add((MutableTreeNode)object);
        }
    }

    public boolean processPropertyFileNode(AbstractAgent abstractAgent, File file, GenericTreeNode genericTreeNode) {
        PropertyFile propertyFile = new PropertyFile();
        propertyFile.loadFrom(file);
        String string = propertyFile.getProperty("madkit.plugin.name");
        if (string != null) {
            string = string + ".jar";
            String string2 = Madkit.libDirectory + File.separator + string;
            File file2 = new File(string2);
            if (!file2.exists()) {
                return false;
            }
            String string3 = propertyFile.getProperty("madkit.plugin.agents");
            String string4 = null;
            string4 = string3 == null ? null : (string3.equalsIgnoreCase("${agents}") || string3.equalsIgnoreCase("all") ? null : (string3.equalsIgnoreCase("none") || string3.equals("") ? "" : string3));
            this.processJarFile(abstractAgent, file2, genericTreeNode, string4);
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void processJarFile(AbstractAgent abstractAgent, File file, GenericTreeNode genericTreeNode, String string) {
        String string2 = null;
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ,:;&\t\n\r\f");
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                int n = string2.lastIndexOf(".");
                String string3 = string2;
                if (n != -1) {
                    string3 = string2.substring(n + 1);
                }
                this.installAgent(string3, string2, genericTreeNode, abstractAgent);
            }
            return;
        } else {
            try {
                JarFile jarFile = new JarFile(file);
                Manifest manifest = jarFile.getManifest();
                if (manifest != null && manifest.getEntries().size() > 0) {
                    boolean bl = false;
                    Map<String, Attributes> map = manifest.getEntries();
                    for (String string4 : map.keySet()) {
                        Attributes attributes = map.get(string4);
                        String string5 = attributes.getValue("Agent");
                        if (string5 == null) {
                            string5 = attributes.getValue("Bean");
                        }
                        if (string5 == null || !string5.equalsIgnoreCase("true")) continue;
                        bl = true;
                        int n = string4.lastIndexOf(46);
                        string2 = string4.substring(0, n).replace('/', '.');
                        int n2 = string2.lastIndexOf(".");
                        String string6 = string2;
                        if (n2 != -1) {
                            string6 = string2.substring(n2 + 1);
                        }
                        this.installAgent(string6, string2, genericTreeNode, abstractAgent);
                    }
                    if (!bl) return;
                    return;
                }
                Enumeration<JarEntry> enumeration = jarFile.entries();
                while (enumeration.hasMoreElements()) {
                    JarEntry jarEntry = enumeration.nextElement();
                    String string7 = jarEntry.getName();
                    if (jarEntry.isDirectory() || !string7.endsWith(".class")) continue;
                    int n = string7.lastIndexOf(46);
                    string2 = string7.substring(0, n).replace('/', '.');
                    int n3 = string2.lastIndexOf(".");
                    String string8 = string2;
                    if (n3 != -1) {
                        string8 = string2.substring(n3 + 1);
                    }
                    this.installAgent(string8, string2, genericTreeNode, abstractAgent);
                }
                return;
            }
            catch (IOException iOException) {
                System.err.println("Not a good jar file : " + file.getName());
                return;
            }
            catch (Exception exception) {
                System.err.println("Error while loading class : " + string2 + " check its default constructor");
            }
        }
    }

    void installAgent(String string, String string2, GenericTreeNode genericTreeNode, AbstractAgent abstractAgent) {
        try {
            Class clazz = Utils.loadClass((String)string2);
            if (Utils.loadClass((String)"madkit.kernel.AbstractAgent").isAssignableFrom(clazz)) {
                Class[] classArray = new Class[0];
                Constructor constructor = clazz.getConstructor(classArray);
                if (constructor == null) {
                    System.err.println("WARNING: class " + string2 + " does not have default constructor");
                } else {
                    genericTreeNode.add((MutableTreeNode)((Object)new JavaAgentNode(abstractAgent, string, string2)));
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Error : class not found : " + string2);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            System.err.println("Error : default constructor of class " + string2 + " not found : ");
        }
        catch (Exception exception) {
            System.err.print("Error while loading class : " + string2 + " error: " + exception);
        }
        catch (Throwable throwable) {
            System.err.println("Error : class " + string2 + " contains dependencies which are not in the classpath");
        }
    }
}

