/*
 * Decompiled with CFR 0.152.
 */
package kawa.standard;

import gnu.bytecode.ZipLoader;
import gnu.expr.Interpreter;
import gnu.expr.LambdaExp;
import gnu.expr.ModuleBody;
import gnu.kawa.reflect.ClassMemberConstraint;
import gnu.lists.Consumer;
import gnu.lists.VoidConsumer;
import gnu.mapping.CallFrame;
import gnu.mapping.Environment;
import gnu.mapping.InPort;
import gnu.mapping.OutPort;
import gnu.mapping.Procedure1;
import gnu.mapping.WrappedException;
import gnu.text.SyntaxException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import kawa.Shell;

public class load
extends Procedure1 {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final void loadClassFile(String string, Environment environment) {
        Environment environment2 = Environment.getCurrent();
        try {
            block7: {
                try {
                    if (environment != environment2) {
                        Environment.setCurrent(environment);
                    }
                    Class<?> clazz = Class.forName(string);
                    Object obj = clazz.newInstance();
                    ClassMemberConstraint.defineAll(obj, environment);
                    if (!(obj instanceof Runnable)) break block7;
                    ((Runnable)obj).run();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new RuntimeException("class not found in load");
                }
                catch (InstantiationException instantiationException) {
                    throw new RuntimeException("class not instantiable: in load");
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new RuntimeException("class illegal access: in load");
                }
            }
            Object var7_7 = null;
            if (environment == environment2) return;
            Environment.setCurrent(environment2);
            return;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (environment == environment2) throw throwable;
            Environment.setCurrent(environment2);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final void loadCompiled(String string, Environment environment) throws Throwable {
        Environment environment2 = Environment.getCurrent();
        try {
            try {
                File file;
                if (environment != environment2) {
                    Environment.setCurrent(environment);
                }
                if (!(file = new File(string)).exists()) {
                    throw new RuntimeException("load: " + string + " - not found");
                }
                if (!file.canRead()) {
                    throw new RuntimeException("load: " + string + " - not readable");
                }
                ZipLoader zipLoader = new ZipLoader(string);
                zipLoader.loadAllClasses();
                Class clazz = zipLoader.loadClass(LambdaExp.fileFunctionName, true);
                Object t = clazz.newInstance();
                if (t instanceof ModuleBody) {
                    ClassMemberConstraint.defineAll(t, environment);
                    ((ModuleBody)t).run();
                }
                ((CallFrame)t).apply0();
            }
            catch (IOException iOException) {
                throw new RuntimeException("load: " + string + " - " + iOException.toString());
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new RuntimeException("class not found in load");
            }
            catch (InstantiationException instantiationException) {
                throw new RuntimeException("class not instantiable: in load");
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException("class illegal access: in load");
            }
            Object var8_11 = null;
            if (environment == environment2) return;
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            if (environment == environment2) throw throwable;
            Environment.setCurrent(environment2);
            throw throwable;
        }
        Environment.setCurrent(environment2);
    }

    public static final void loadSource(String string, Environment environment) throws SyntaxException {
        try {
            InPort inPort = InPort.openFile(string);
            load.loadSource(inPort, environment);
            inPort.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RuntimeException("load: file not found: " + string);
        }
        catch (IOException iOException) {
            throw new RuntimeException("failed to close \"" + string + "\" after loading");
        }
        catch (Throwable throwable) {
            throw new WrappedException(throwable);
        }
    }

    public static final void loadSource(InPort inPort, Environment environment) throws SyntaxException, Throwable {
        boolean bl = ModuleBody.getMainPrintValues();
        Interpreter interpreter = Interpreter.getInterpreter();
        Consumer consumer = bl ? Shell.getOutputConsumer(OutPort.outDefault()) : new VoidConsumer();
        consumer.beginDocument();
        Shell.run(interpreter, environment, inPort, consumer, OutPort.errDefault());
        consumer.endDocument();
    }

    public final Object apply1(Object object2) throws Throwable {
        return this.apply2(object2, Environment.current());
    }

    public final Object apply2(Object object2, Object object3) throws Throwable {
        String string = object2.toString();
        try {
            Environment environment = (Environment)object3;
            load.apply(string, environment);
            return Interpreter.voidObject;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RuntimeException("load: file not readable: " + string);
        }
        catch (SyntaxException syntaxException) {
            throw new RuntimeException("load: errors while compiling '" + string + "':\n" + syntaxException.getMessages().toString(20));
        }
    }

    public static final void apply(String string, Environment environment) throws Throwable {
        if (string.endsWith(".zip") || string.endsWith(".jar")) {
            load.loadCompiled(string, environment);
            return;
        }
        if (string.endsWith(".scm")) {
            load.loadSource(string, environment);
            return;
        }
        char c = System.getProperty("file.separator").charAt(0);
        if (string.endsWith(".class")) {
            string = string.substring(0, string.length() - 6);
            string = string.replace('/', '.');
            if (c != '/') {
                string = string.replace(c, '.');
            }
            load.loadClassFile(string, environment);
            return;
        }
        File file = new File(string);
        if (file.exists()) {
            int n;
            int n2;
            int n3;
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
            ((InputStream)bufferedInputStream).mark(5);
            int n4 = ((InputStream)bufferedInputStream).read();
            if (n4 == -1) {
                return;
            }
            if (n4 == 80 && (n3 = ((InputStream)bufferedInputStream).read()) == 75 && (n2 = ((InputStream)bufferedInputStream).read()) == 3 && (n = ((InputStream)bufferedInputStream).read()) == 4) {
                ((InputStream)bufferedInputStream).close();
                load.loadCompiled(string, environment);
                return;
            }
            ((InputStream)bufferedInputStream).reset();
            InPort inPort = InPort.openFile(bufferedInputStream, string);
            load.loadSource(inPort, environment);
            inPort.close();
            return;
        }
        String string2 = string.replace('.', c);
        String string3 = string2 + ".zip";
        file = new File(string3);
        if (file.exists()) {
            load.loadCompiled(string3, environment);
            return;
        }
        string3 = string2 + ".jar";
        file = new File(string3);
        if (file.exists()) {
            load.loadCompiled(string3, environment);
            return;
        }
        string3 = string2 + ".class";
        file = new File(string3);
        if (file.exists()) {
            load.loadClassFile(string, environment);
            return;
        }
        string3 = string2 + ".scm";
        file = new File(string3);
        if (file.exists()) {
            load.loadSource(string3, environment);
            return;
        }
        throw new FileNotFoundException(string);
    }
}

