/*
 * Decompiled with CFR 0.152.
 */
package kawa.standard;

import gnu.bytecode.Type;
import gnu.mapping.Binding;
import gnu.mapping.Environment;
import gnu.math.Unit;
import kawa.standard.Scheme;
import kawa.standard.ScmEnvConstraint;

public class ScmEnv
extends Environment {
    Environment[] extras;
    int numExtras;

    public final void addExtra(Environment environment) {
        if (this.extras == null) {
            this.extras = new Environment[4];
            this.extras[0] = environment;
            this.numExtras = 1;
        } else {
            if (this.numExtras > this.extras.length) {
                Environment[] environmentArray = new Environment[2 * this.numExtras];
                System.arraycopy(this.extras, 0, environmentArray, 0, this.numExtras);
                this.extras = environmentArray;
            }
            this.extras[this.numExtras++] = environment;
        }
    }

    public ScmEnv(Environment environment) {
        super(environment);
        this.unboundConstraint = new ScmEnvConstraint(this);
    }

    static Type getType(String string) {
        int n = string.length();
        if (n > 2 && string.charAt(0) == '<' && string.charAt(n - 1) == '>') {
            String string2 = string.substring(1, n - 1);
            return Scheme.string2Type(string2);
        }
        return null;
    }

    public Object get(String string, Object object2) {
        Object object3;
        Object object4 = super.get(string, object2);
        if (object4 != object2 || object2 != Binding.UNBOUND && super.get(string, Binding.UNBOUND) != Binding.UNBOUND) {
            return object4;
        }
        if (string.endsWith("$unit") && (object3 = Unit.lookup(string.substring(0, string.length() - 5))) != null) {
            return object3;
        }
        object3 = ScmEnv.getType(string);
        if (object3 != null) {
            return object3;
        }
        int n = this.numExtras;
        while (--n >= 0) {
            object4 = this.extras[n].get(string, Binding.UNBOUND);
            if (object4 == Binding.UNBOUND) continue;
            return object4;
        }
        return object2;
    }
}

