/*
 * Decompiled with CFR 0.152.
 */
package kawa.lib;

import gnu.expr.ModuleBody;
import gnu.expr.ModuleMethod;
import gnu.lists.FString;
import gnu.mapping.Binding;
import gnu.mapping.Environment;
import gnu.mapping.WrongType;
import gnu.math.BitOps;
import gnu.math.Complex;
import gnu.math.DComplex;
import gnu.math.DFloNum;
import gnu.math.IntNum;
import gnu.math.Numeric;
import gnu.math.Quantity;
import gnu.math.RatNum;
import gnu.math.RealNum;

public class numbers
extends ModuleBody {
    static final numbers $instance = new numbers();
    public static final ModuleMethod isNumber = new ModuleMethod($instance, 33, "number?", 4097);
    public static final ModuleMethod isQuantity = new ModuleMethod($instance, 32, "quantity?", 4097);
    public static final ModuleMethod isComplex = new ModuleMethod($instance, 31, "complex?", 4097);
    public static final ModuleMethod isReal = new ModuleMethod($instance, 30, "real?", 4097);
    public static final ModuleMethod isRational = new ModuleMethod($instance, 29, "rational?", 4097);
    public static final ModuleMethod isExact = new ModuleMethod($instance, 28, "exact?", 4097);
    public static final ModuleMethod isInexact = new ModuleMethod($instance, 27, "inexact?", 4097);
    public static final ModuleMethod isZero = new ModuleMethod($instance, 26, "zero?", 4097);
    public static final ModuleMethod isNegative = new ModuleMethod($instance, 25, "negative?", 4097);
    public static final ModuleMethod isOdd = new ModuleMethod($instance, 24, "odd?", 4097);
    public static final ModuleMethod isEven = new ModuleMethod($instance, 23, "even?", 4097);
    public static final ModuleMethod abs = new ModuleMethod($instance, 22, "abs", 4097);
    public static final ModuleMethod quotient = new ModuleMethod($instance, 40, "quotient", 8194);
    public static final ModuleMethod remainder = new ModuleMethod($instance, 39, "remainder", 8194);
    public static final ModuleMethod numerator = new ModuleMethod($instance, 21, "numerator", 4097);
    public static final ModuleMethod denominator = new ModuleMethod($instance, 20, "denominator", 4097);
    public static final ModuleMethod floor = new ModuleMethod($instance, 19, "floor", 4097);
    public static final ModuleMethod ceiling = new ModuleMethod($instance, 18, "ceiling", 4097);
    public static final ModuleMethod truncate = new ModuleMethod($instance, 17, "truncate", 4097);
    public static final ModuleMethod round = new ModuleMethod($instance, 16, "round", 4097);
    public static final ModuleMethod exp = new ModuleMethod($instance, 15, "exp", 4097);
    public static final ModuleMethod log = new ModuleMethod($instance, 14, "log", 4097);
    public static final ModuleMethod sin = new ModuleMethod($instance, 13, "sin", 4097);
    public static final ModuleMethod cos = new ModuleMethod($instance, 12, "cos", 4097);
    public static final ModuleMethod tan = new ModuleMethod($instance, 11, "tan", 4097);
    public static final ModuleMethod asin = new ModuleMethod($instance, 10, "asin", 4097);
    public static final ModuleMethod acos = new ModuleMethod($instance, 9, "acos", 4097);
    public static final ModuleMethod makeRectangular = new ModuleMethod($instance, 38, "make-rectangular", 8194);
    public static final ModuleMethod makePolar = new ModuleMethod($instance, 37, "make-polar", 8194);
    public static final ModuleMethod realPart = new ModuleMethod($instance, 8, "real-part", 4097);
    public static final ModuleMethod imagPart = new ModuleMethod($instance, 7, "imag-part", 4097);
    public static final ModuleMethod magnitude = new ModuleMethod($instance, 6, "magnitude", 4097);
    public static final ModuleMethod angle = new ModuleMethod($instance, 5, "angle", 4097);
    public static final ModuleMethod arithmeticShift = new ModuleMethod($instance, 36, "arithmetic-shift", 8194);
    public static final ModuleMethod lognot = new ModuleMethod($instance, 4, "lognot", 4097);
    public static final ModuleMethod logop = new ModuleMethod($instance, 42, "logop", 12291);
    public static final ModuleMethod isLogbit = new ModuleMethod($instance, 35, "logbit?", 8194);
    public static final ModuleMethod bitExtract = new ModuleMethod($instance, 41, "bit-extract", 12291);
    public static final ModuleMethod logtest = new ModuleMethod($instance, 34, "logtest", 8194);
    public static final ModuleMethod logcount = new ModuleMethod($instance, 3, "logcount", 4097);
    public static final ModuleMethod integerLength = new ModuleMethod($instance, 2, "integer-length", 4097);
    public static final ModuleMethod number$To$String = new ModuleMethod($instance, 1, "number->string", 8193);
    static final Binding id$$$Lsboolean$Gr;
    static final Binding id$$$Lsdouble$Gr;
    static final Binding id$$$Lsint$Gr;

    /*
     * Enabled aggressive block sorting
     */
    static {
        Environment env$ = Environment.getCurrent();
        id$$$Lsint$Gr = env$.getBinding("<int>");
        id$$$Lsdouble$Gr = env$.getBinding("<double>");
        id$$$Lsboolean$Gr = env$.getBinding("<boolean>");
    }

    public static boolean isNumber(Object x) {
        return x instanceof Numeric;
    }

    public static boolean isQuantity(Object x) {
        return x instanceof Quantity;
    }

    public static boolean isComplex(Object x) {
        return x instanceof Complex;
    }

    public static boolean isReal(Object x) {
        return x instanceof RealNum;
    }

    public static boolean isRational(Object x) {
        return x instanceof RatNum;
    }

    public static boolean isExact(Object x) {
        return x instanceof Numeric ? ((Numeric)x).isExact() : false;
    }

    public static boolean isInexact(Object x) {
        return (x instanceof Numeric ? ((Numeric)x).isExact() + 1 & 1 : 0) != 0;
    }

    public static boolean isZero(Numeric x) {
        return x.isZero();
    }

    public static boolean isNegative(RealNum x) {
        return x.isNegative();
    }

    public static boolean isOdd(IntNum x) {
        return x.isOdd();
    }

    public static boolean isEven(IntNum x) {
        return (numbers.isOdd(x) + 1 & 1) != 0;
    }

    public static Numeric abs(Numeric x) {
        return x.abs();
    }

    public static IntNum quotient(IntNum x, IntNum y) {
        return IntNum.quotient(x, y);
    }

    public static IntNum remainder(IntNum x, IntNum y) {
        return IntNum.remainder(x, y);
    }

    public static IntNum numerator(RatNum x) {
        return x.numerator();
    }

    public static IntNum denominator(RatNum x) {
        return x.denominator();
    }

    public static RealNum floor(RealNum x) {
        return x.toInt(Numeric.FLOOR);
    }

    public static RealNum ceiling(RealNum x) {
        return x.toInt(Numeric.CEILING);
    }

    public static RealNum truncate(RealNum x) {
        return x.toInt(Numeric.TRUNCATE);
    }

    public static RealNum round(RealNum x) {
        return x.toInt(Numeric.ROUND);
    }

    public static Complex exp(Complex x) {
        return x.exp();
    }

    public static Complex log(Complex x) {
        return x.log();
    }

    public static double sin(double x) {
        return Math.sin(x);
    }

    public static double cos(double x) {
        return Math.cos(x);
    }

    public static double tan(double x) {
        return Math.tan(x);
    }

    public static double asin(double x) {
        return Math.asin(x);
    }

    public static double acos(double x) {
        return Math.acos(x);
    }

    public static Complex makeRectangular(RealNum x, RealNum y) {
        return Complex.make(x, y);
    }

    public static DComplex makePolar(double x, double y) {
        return Complex.polar(x, y);
    }

    public static RealNum realPart(Complex x) {
        return x.re();
    }

    public static RealNum imagPart(Complex x) {
        return x.im();
    }

    public static Numeric magnitude(Numeric x) {
        return x.abs();
    }

    public static RealNum angle(Complex x) {
        return x.number().angle();
    }

    public static IntNum arithmeticShift(IntNum value, int amount) {
        return IntNum.shift(value, amount);
    }

    public static IntNum lognot(IntNum i) {
        return BitOps.not(i);
    }

    public static IntNum logop(int op, IntNum i, IntNum j) {
        return BitOps.bitOp(op, i, j);
    }

    public static boolean isLogbit(IntNum i, int bitno) {
        return BitOps.bitValue(i, bitno);
    }

    public static IntNum bitExtract(IntNum i, int start, int end) {
        return BitOps.extract(i, start, end);
    }

    public static boolean logtest(IntNum i, IntNum j) {
        return BitOps.test(i, j);
    }

    public static int logcount(IntNum i) {
        return BitOps.bitCount(i);
    }

    public static int integerLength(IntNum i) {
        return i.intLength();
    }

    public static FString number$To$String(Numeric numeric) {
        return numbers.number$To$String(numeric, 10);
    }

    public static FString number$To$String(Numeric arg, int radix) {
        return new FString(arg.toString(radix));
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object apply1(ModuleMethod moduleMethod, Object object2) {
        switch (moduleMethod.selector) {
            case 1: {
                return numbers.number$To$String((Numeric)object2);
            }
            case 2: {
                return IntNum.make(numbers.integerLength((IntNum)object2));
            }
            case 3: {
                return IntNum.make(numbers.logcount((IntNum)object2));
            }
            case 4: {
                return numbers.lognot((IntNum)object2);
            }
            case 5: {
                return numbers.angle((Complex)object2);
            }
            case 6: {
                return numbers.magnitude((Numeric)object2);
            }
            case 7: {
                return numbers.imagPart((Complex)object2);
            }
            case 8: {
                return numbers.realPart((Complex)object2);
            }
            case 9: {
                return DFloNum.make(numbers.acos(((Number)object2).doubleValue()));
            }
            case 10: {
                return DFloNum.make(numbers.asin(((Number)object2).doubleValue()));
            }
            case 11: {
                return DFloNum.make(numbers.tan(((Number)object2).doubleValue()));
            }
            case 12: {
                return DFloNum.make(numbers.cos(((Number)object2).doubleValue()));
            }
            case 13: {
                return DFloNum.make(numbers.sin(((Number)object2).doubleValue()));
            }
            case 14: {
                return numbers.log((Complex)object2);
            }
            case 15: {
                return numbers.exp((Complex)object2);
            }
            case 16: {
                return numbers.round((RealNum)object2);
            }
            case 17: {
                return numbers.truncate((RealNum)object2);
            }
            case 18: {
                return numbers.ceiling((RealNum)object2);
            }
            case 19: {
                return numbers.floor((RealNum)object2);
            }
            case 20: {
                return numbers.denominator((RatNum)object2);
            }
            case 21: {
                return numbers.numerator((RatNum)object2);
            }
            case 22: {
                return numbers.abs((Numeric)object2);
            }
            case 23: {
                Boolean bl;
                if (numbers.isEven((IntNum)object2)) {
                    bl = Boolean.TRUE;
                    return bl;
                }
                bl = Boolean.FALSE;
                return bl;
            }
            case 24: {
                Boolean bl;
                if (numbers.isOdd((IntNum)object2)) {
                    bl = Boolean.TRUE;
                    return bl;
                }
                bl = Boolean.FALSE;
                return bl;
            }
            case 25: {
                Boolean bl;
                if (numbers.isNegative((RealNum)object2)) {
                    bl = Boolean.TRUE;
                    return bl;
                }
                bl = Boolean.FALSE;
                return bl;
            }
            case 26: {
                Boolean bl;
                if (numbers.isZero((Numeric)object2)) {
                    bl = Boolean.TRUE;
                    return bl;
                }
                bl = Boolean.FALSE;
                return bl;
            }
            case 27: {
                Boolean bl;
                if (numbers.isInexact(object2)) {
                    bl = Boolean.TRUE;
                    return bl;
                }
                bl = Boolean.FALSE;
                return bl;
            }
            case 28: {
                Boolean bl;
                if (numbers.isExact(object2)) {
                    bl = Boolean.TRUE;
                    return bl;
                }
                bl = Boolean.FALSE;
                return bl;
            }
            case 29: {
                Boolean bl;
                if (numbers.isRational(object2)) {
                    bl = Boolean.TRUE;
                    return bl;
                }
                bl = Boolean.FALSE;
                return bl;
            }
            case 30: {
                Boolean bl;
                if (numbers.isReal(object2)) {
                    bl = Boolean.TRUE;
                    return bl;
                }
                bl = Boolean.FALSE;
                return bl;
            }
            case 31: {
                Boolean bl;
                if (numbers.isComplex(object2)) {
                    bl = Boolean.TRUE;
                    return bl;
                }
                bl = Boolean.FALSE;
                return bl;
            }
            case 32: {
                Boolean bl;
                if (numbers.isQuantity(object2)) {
                    bl = Boolean.TRUE;
                    return bl;
                }
                bl = Boolean.FALSE;
                return bl;
            }
            case 33: {
                Boolean bl;
                if (numbers.isNumber(object2)) {
                    bl = Boolean.TRUE;
                    return bl;
                }
                bl = Boolean.FALSE;
                return bl;
            }
        }
        return super.apply1(moduleMethod, object2);
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "zero?", 0);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "negative?", 0);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "odd?", 0);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "even?", 0);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "abs", 0);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "numerator", 0);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "denominator", 0);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "floor", 0);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "ceiling", 0);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "truncate", 0);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "round", 0);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "exp", 0);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "log", 0);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "sin", 0);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "cos", 0);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "tan", 0);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "asin", 0);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "acos", 0);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "real-part", 0);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "imag-part", 0);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "magnitude", 0);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "angle", 0);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "lognot", 0);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "logcount", 0);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "integer-length", 0);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "number->string", 0);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object apply2(ModuleMethod moduleMethod, Object object2, Object object3) {
        switch (moduleMethod.selector) {
            case 1: {
                Numeric numeric = (Numeric)object2;
                return numbers.number$To$String(numeric, ((Number)object3).intValue());
            }
            case 34: {
                Boolean bl;
                IntNum intNum = (IntNum)object2;
                if (numbers.logtest(intNum, (IntNum)object3)) {
                    bl = Boolean.TRUE;
                    return bl;
                }
                bl = Boolean.FALSE;
                return bl;
            }
            case 35: {
                Boolean bl;
                IntNum intNum = (IntNum)object2;
                if (numbers.isLogbit(intNum, ((Number)object3).intValue())) {
                    bl = Boolean.TRUE;
                    return bl;
                }
                bl = Boolean.FALSE;
                return bl;
            }
            case 36: {
                IntNum intNum = (IntNum)object2;
                return numbers.arithmeticShift(intNum, ((Number)object3).intValue());
            }
            case 37: {
                double d = ((Number)object2).doubleValue();
                return numbers.makePolar(d, ((Number)object3).doubleValue());
            }
            case 38: {
                RealNum realNum = (RealNum)object2;
                return numbers.makeRectangular(realNum, (RealNum)object3);
            }
            case 39: {
                IntNum intNum = (IntNum)object2;
                return numbers.remainder(intNum, (IntNum)object3);
            }
            case 40: {
                IntNum intNum = (IntNum)object2;
                return numbers.quotient(intNum, (IntNum)object3);
            }
        }
        return super.apply2(moduleMethod, object2, object3);
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "quotient", 1);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "quotient", 0);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "remainder", 1);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "remainder", 0);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "make-rectangular", 1);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "make-rectangular", 0);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "make-polar", 1);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "make-polar", 0);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "arithmetic-shift", 1);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "arithmetic-shift", 0);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "logbit?", 1);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "logbit?", 0);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "logtest", 1);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "logtest", 0);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "number->string", 1);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "number->string", 0);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object apply3(ModuleMethod moduleMethod, Object object2, Object object3, Object object4) {
        switch (moduleMethod.selector) {
            case 41: {
                IntNum intNum = (IntNum)object2;
                int n = ((Number)object3).intValue();
                return numbers.bitExtract(intNum, n, ((Number)object4).intValue());
            }
            case 42: {
                int n = ((Number)object2).intValue();
                IntNum intNum = (IntNum)object3;
                return numbers.logop(n, intNum, (IntNum)object4);
            }
        }
        return super.apply3(moduleMethod, object2, object3, object4);
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "logop", 2);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "logop", 1);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "logop", 0);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "bit-extract", 2);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "bit-extract", 1);
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "bit-extract", 0);
        }
    }
}

