/*
 * Decompiled with CFR 0.152.
 */
package kawa.lang;

import gnu.expr.Compilation;
import gnu.expr.Interpreter;
import gnu.expr.ModuleExp;
import gnu.lists.FString;
import gnu.mapping.InPort;
import gnu.mapping.Procedure2;
import gnu.mapping.WrongType;
import gnu.text.SourceMessages;
import gnu.text.SyntaxException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import kawa.lang.GenericError;

public class CompileFile
extends Procedure2 {
    public CompileFile() {
        super("compile-file");
    }

    public static final ModuleExp read(String string, SourceMessages sourceMessages) {
        try {
            InPort inPort = InPort.openFile(string);
            ModuleExp moduleExp = CompileFile.read(inPort, sourceMessages);
            inPort.close();
            return moduleExp;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new GenericError("compile-file: file not found: " + string);
        }
        catch (IOException iOException) {
            throw new GenericError(string.toString());
        }
    }

    public static final ModuleExp read(InPort inPort, SourceMessages sourceMessages) {
        return Interpreter.getInterpreter().parseFile(inPort, sourceMessages);
    }

    public final Object apply2(Object object2, Object object3) throws Throwable {
        if (!(object2 instanceof FString)) {
            throw new WrongType(this.name(), 1, "file name");
        }
        SourceMessages sourceMessages = new SourceMessages();
        ModuleExp moduleExp = CompileFile.read(object2.toString(), sourceMessages);
        if (sourceMessages.seenErrors()) {
            throw new SyntaxException(sourceMessages);
        }
        moduleExp.compileToArchive(object3.toString());
        return Interpreter.voidObject;
    }

    public static void compile_to_files(String string, String string2, String string3, String string4, SourceMessages sourceMessages) {
        Object object2;
        if (string4 == null) {
            object2 = new File(string);
            String string5 = ((File)object2).getName();
            int n = string5.lastIndexOf(46);
            if (n > 0) {
                string5 = string5.substring(0, n);
            }
            string4 = string5 = Compilation.mangleNameIfNeeded(string5);
            if (string3 != null) {
                string4 = string3 + string5;
            }
        }
        object2 = CompileFile.read(string, sourceMessages);
        if (sourceMessages.seenErrors()) {
            return;
        }
        try {
            ((ModuleExp)object2).compileToFiles(string4, string2, string3);
        }
        catch (IOException iOException) {
            throw new GenericError(iOException.toString());
        }
    }
}

