/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml;

import gnu.lists.AbstractSequence;
import gnu.lists.CharSeq;
import gnu.lists.Consumable;
import gnu.lists.Consumer;
import gnu.lists.PositionConsumer;
import gnu.lists.PrintConsumer;
import gnu.lists.SeqPosition;
import gnu.lists.TreePosition;
import gnu.lists.UnescapedData;
import gnu.text.Char;
import java.io.IOException;
import java.io.Writer;

public class XMLPrinter
extends PrintConsumer
implements PositionConsumer {
    boolean inAttribute = false;
    boolean inStartTag = false;
    boolean canonicalize = true;
    boolean htmlCompat = true;
    public boolean escapeText = true;
    boolean isHtml = false;
    Object style;
    private static final int WORD = -2;
    int prev = 32;
    static final String HtmlEmptyTags = "/area/base/basefont/br/col/frame/hr/img/input/isindex/link/meta/para/";

    public XMLPrinter(Writer writer, boolean bl) {
        super(writer, bl);
    }

    public XMLPrinter(Writer writer) {
        super(writer);
    }

    public XMLPrinter(Consumer consumer) {
        super(consumer, false);
    }

    public static XMLPrinter make(Consumer consumer, Object object2) {
        XMLPrinter xMLPrinter = new XMLPrinter(consumer);
        xMLPrinter.style = object2;
        if ("html".equals(object2)) {
            xMLPrinter.isHtml = true;
            xMLPrinter.htmlCompat = true;
        }
        if ("xhtml".equals(object2)) {
            xMLPrinter.htmlCompat = true;
        }
        if ("plain".equals(object2)) {
            xMLPrinter.escapeText = false;
        }
        return xMLPrinter;
    }

    protected static final boolean isWordChar(char c) {
        return Character.isJavaIdentifierPart(c) || c == '-' || c == '+';
    }

    private final void writeRaw(String string) {
        try {
            this.out.write(string);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString());
        }
    }

    private final void writeRaw(int n) {
        try {
            this.out.write(n);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString());
        }
    }

    private final void writeRaw(char[] cArray, int n, int n2) {
        try {
            this.out.write(cArray, n, n2);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString());
        }
    }

    public void writeChar(int n) {
        this.closeTag();
        if (this.prev == -2 && XMLPrinter.isWordChar((char)n)) {
            this.writeRaw(32);
        }
        if (!this.escapeText) {
            this.writeRaw((char)n);
        } else if (!(n != 60 || this.isHtml && this.inAttribute)) {
            this.writeRaw("&lt;");
        } else if (n == 62) {
            this.writeRaw("&gt;");
        } else if (n == 38) {
            this.writeRaw("&amp;");
        } else if (n == 34 && this.inAttribute) {
            this.writeRaw("&quot;");
        } else if (n >= 127) {
            this.writeRaw("&#" + n + ";");
        } else {
            this.writeRaw((char)n);
        }
        this.prev = n;
    }

    private void startWord() {
        this.closeTag();
        if (this.prev == -2 || XMLPrinter.isWordChar((char)this.prev)) {
            this.writeRaw(32);
        }
        this.prev = -2;
    }

    public void writeBoolean(boolean bl) {
        this.startWord();
        super.print(bl);
    }

    private void closeTag() {
        if (this.inStartTag && !this.inAttribute) {
            this.writeRaw(62);
            this.inStartTag = false;
            this.prev = 62;
        }
    }

    protected void startNumber() {
        this.startWord();
    }

    public void beginGroup(String string, Object object2) {
        this.closeTag();
        this.writeRaw(60);
        this.writeRaw(string);
        this.inStartTag = true;
        if (this.isHtml && ("script".equals(string) || "style".equals(string))) {
            this.escapeText = false;
        }
    }

    public static boolean isHtmlEmptyElementTag(String string) {
        int n = HtmlEmptyTags.indexOf(string);
        return n > 0 && HtmlEmptyTags.charAt(n - 1) == '/' && HtmlEmptyTags.charAt(n + string.length()) == '/';
    }

    public void endGroup(String string) {
        if (this.canonicalize && !this.htmlCompat) {
            this.closeTag();
        }
        if (this.inStartTag) {
            this.writeRaw(this.isHtml ? (XMLPrinter.isHtmlEmptyElementTag(string) ? ">" : "></" + string + ">") : (this.htmlCompat ? " />" : "/>"));
            this.inStartTag = false;
        } else {
            this.writeRaw("</");
            this.writeRaw(string);
            this.writeRaw(">");
        }
        this.prev = 62;
        if (this.isHtml && !this.escapeText && ("script".equals(string) || "style".equals(string))) {
            this.escapeText = true;
        }
    }

    public void beginAttribute(String string, Object object2) {
        if (this.inAttribute) {
            this.writeRaw(34);
        }
        this.inAttribute = true;
        this.writeRaw(32);
        this.writeRaw(string);
        this.writeRaw("=\"");
        this.prev = 32;
    }

    public void endAttribute() {
        this.writeRaw(34);
        this.inAttribute = false;
        this.prev = 32;
    }

    public void writeObject(Object object2) {
        this.closeTag();
        if (object2 instanceof UnescapedData) {
            this.writeRaw(((UnescapedData)object2).getData());
        } else if (object2 instanceof Consumable) {
            ((Consumable)object2).consume(this);
        } else if (object2 instanceof SeqPosition) {
            SeqPosition seqPosition = (SeqPosition)object2;
            seqPosition.sequence.consumeNext(seqPosition.ipos, seqPosition.xpos, this);
        } else if (object2 instanceof Char) {
            this.writeChar(((Char)object2).intValue());
        } else if (object2 instanceof String || object2 instanceof CharSeq) {
            this.writeChars(object2.toString());
        } else {
            this.startWord();
            this.prev = 32;
            this.writeChars(object2 == null ? "(null)" : object2.toString());
            this.prev = -2;
        }
    }

    public boolean ignoring() {
        return false;
    }

    public void writeChars(String string) {
        this.closeTag();
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            this.writeChar(string.charAt(n2));
            ++n2;
        }
    }

    public void write(char[] cArray, int n, int n2) {
        int n3;
        this.closeTag();
        if (n2 <= 0) {
            return;
        }
        int n4 = this.prev;
        if (this.prev == -2) {
            n3 = cArray[n++];
            this.writeChar(n3);
            n4 = n3;
            --n2;
        }
        int n5 = n + n2;
        int n6 = 0;
        while (n < n5) {
            if ((n4 = (n3 = cArray[n++])) >= 127 || n4 == 60 || n4 == 62 || n4 == 38 || n4 == 34 && this.inAttribute) {
                if (n6 > 0) {
                    this.writeRaw(cArray, n - 1 - n6, n6);
                }
                this.writeChar(n3);
                n6 = 0;
                continue;
            }
            ++n6;
        }
        if (n6 > 0) {
            this.writeRaw(cArray, n5 - n6, n6);
        }
    }

    public boolean writePosition(AbstractSequence abstractSequence, int n, Object object2) {
        abstractSequence.consumeNext(n, object2, this);
        return true;
    }

    public boolean consume(TreePosition treePosition) {
        throw new Error("not implemented consume(TreePosition)");
    }
}

