/*
 * Decompiled with CFR 0.152.
 */
package gnu.mapping;

import gnu.mapping.Procedure;

public class WrongArguments
extends IllegalArgumentException {
    public int number;
    public String usage;
    public String procname;
    Procedure proc;

    public static String checkArgCount(Procedure procedure, int n) {
        boolean bl;
        int n2 = procedure.numArgs();
        int n3 = n2 & 0xFFF;
        int n4 = n2 >> 12;
        if (n < n3) {
            bl = false;
        } else if (n4 >= 0 && n > n4) {
            bl = true;
        } else {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("call to '");
        String string = procedure.getName();
        stringBuffer.append(string != null ? string : procedure.getClass().getName());
        stringBuffer.append("' has too ");
        stringBuffer.append(bl ? "many" : "few");
        stringBuffer.append(" arguments (");
        stringBuffer.append(n);
        if (n3 == n4) {
            stringBuffer.append("; must be ");
            stringBuffer.append(n3);
        } else {
            stringBuffer.append("; min=");
            stringBuffer.append(n3);
            if (n4 >= 0) {
                stringBuffer.append(", max=");
                stringBuffer.append(n4);
            }
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public String getMessage() {
        String string;
        if (this.proc != null && (string = WrongArguments.checkArgCount(this.proc, this.number)) != null) {
            return string;
        }
        return super.getMessage();
    }

    public WrongArguments(Procedure procedure, int n) {
        this.proc = procedure;
        this.number = n;
    }

    public WrongArguments(String string, int n, String string2) {
        this.procname = string;
        this.number = n;
        this.usage = string2;
    }
}

