/*
 * Decompiled with CFR 0.152.
 */
package gnu.mapping;

import gnu.mapping.Binding;
import gnu.mapping.Constraint;
import gnu.mapping.Environment;
import gnu.mapping.TrivialConstraint;

public class UnboundConstraint
extends Constraint {
    Environment environment;
    static UnboundConstraint instance;

    public static UnboundConstraint getInstance(Environment environment) {
        UnboundConstraint unboundConstraint;
        if (environment != null) {
            unboundConstraint = environment.unboundConstraint;
            if (unboundConstraint == null) {
                environment.unboundConstraint = unboundConstraint = new UnboundConstraint(environment);
            }
        } else {
            unboundConstraint = instance;
            if (unboundConstraint == null) {
                instance = unboundConstraint = new UnboundConstraint(null);
            }
        }
        return unboundConstraint;
    }

    public static UnboundConstraint getInstance(Binding binding) {
        Constraint constraint = binding.constraint;
        if (constraint instanceof UnboundConstraint) {
            return (UnboundConstraint)binding.constraint;
        }
        return UnboundConstraint.getInstance(constraint.getEnvironment(binding));
    }

    public UnboundConstraint(Environment environment) {
        this.environment = environment;
    }

    public Object get(Binding binding, Object object2) {
        Object object3 = binding.value;
        if (object3 == null && this.environment != null && this.environment.previous != null) {
            binding.value = object3 = this.environment.previous.lookup(binding.getName());
        }
        if (object3 != null) {
            return ((Binding)object3).get();
        }
        return object2;
    }

    public boolean isBound(Binding binding) {
        return false;
    }

    public void set(Binding binding, Object object2) {
        Environment environment = this.getEnvironment(binding);
        if (environment != null && environment.locked) {
            throw new IllegalStateException("attempt to modify variable: " + binding.getName() + " locked environment");
        }
        Binding binding2 = binding;
        synchronized (binding2) {
            if (binding.constraint == this) {
                binding.setConstraint(TrivialConstraint.getInstance(environment));
            }
            binding.constraint.set(binding, object2);
        }
    }

    public Environment getEnvironment(Binding binding) {
        return this.environment;
    }
}

