/*
 * Decompiled with CFR 0.152.
 */
package gnu.lists;

import gnu.lists.AbstractSequence;
import gnu.lists.Consumer;
import gnu.lists.PositionContainer;
import gnu.lists.Sequence;
import gnu.lists.SimpleVector;

public class GapVector
extends AbstractSequence
implements Sequence {
    public SimpleVector base;
    public int gapStart;
    public int gapEnd;

    public GapVector(SimpleVector simpleVector) {
        this.base = simpleVector;
    }

    public int size() {
        return this.base.getBufferLength() - (this.gapEnd - this.gapStart);
    }

    protected boolean hasNext(int n, Object object2) {
        int n2 = n >>> 1;
        if (n2 >= this.gapStart) {
            n2 += this.gapEnd - this.gapStart;
        }
        return n2 < this.base.getBufferLength();
    }

    public int getNextKind(int n, Object object2) {
        return this.hasNext(n, object2) ? this.base.getElementKind() : 0;
    }

    public Object get(int n) {
        if (n >= this.gapStart) {
            n += this.gapEnd - this.gapStart;
        }
        return this.base.get(n);
    }

    public Object set(int n, Object object2) {
        if (n >= this.gapStart) {
            n += this.gapEnd - this.gapStart;
        }
        return this.base.set(n, object2);
    }

    public void fill(Object object2) {
        this.base.fill(this.gapEnd, this.base.getBufferLength(), object2);
        this.base.fill(0, this.gapStart, object2);
    }

    public void fill(int n, int n2, Object object2) {
        int n3 = n;
        int n4 = this.gapStart < n2 ? this.gapStart : n2;
        while (n3 < n4) {
            this.set(n3, object2);
            ++n3;
        }
        int n5 = this.gapEnd - this.gapStart;
        n3 = n4 + n5;
        n4 += n2;
        while (n3 < n4) {
            this.set(n3, object2);
            ++n3;
        }
    }

    protected void shiftGap(int n) {
        int n2 = n - this.gapStart;
        if (n2 > 0) {
            this.base.shift(this.gapEnd, this.gapStart, n2);
        } else if (n2 < 0) {
            this.base.shift(n, this.gapEnd + n2, -n2);
        }
        this.gapEnd += n2;
        this.gapStart = n;
    }

    protected void gapReserve(int n) {
        if (n > this.gapEnd - this.gapStart) {
            int n2;
            int n3 = this.base.getBufferLength();
            int n4 = n3 < 16 ? 16 : 2 * n3;
            if (n4 < (n2 = n3 - (this.gapEnd - this.gapStart) + n)) {
                n4 = n2;
            }
            this.base.setBufferLength(n4);
            int n5 = n4 - n3 + this.gapEnd;
            this.base.shift(this.gapEnd, n5, n3 - this.gapEnd);
            this.gapEnd = n5;
        }
    }

    protected void gapReserve(int n, int n2) {
        this.gapReserve(n2);
        if (n != this.gapStart) {
            this.shiftGap(n);
        }
    }

    protected void add(PositionContainer positionContainer, int n, Object object2) {
        int n2 = positionContainer.getPositionInt(n);
        int n3 = n2 >>> 1;
        if (n3 >= this.gapStart) {
            n3 += this.gapEnd - this.gapStart;
        }
        this.add(n3, object2);
        positionContainer.setPosition(n, n3 + 1 << 1 | 1, null);
    }

    public void add(int n, Object object2) {
        this.gapReserve(n, 1);
        this.base.set(n, object2);
        ++this.gapStart;
    }

    protected void remove(int n, Object object2, int n2, Object object3) {
        n2 >>>= 1;
        if ((n >>>= 1) > this.gapEnd) {
            this.shiftGap(n);
        } else if (n2 < this.gapStart) {
            this.shiftGap(n2);
        }
        if (n < this.gapStart) {
            this.base.clearBuffer(n, this.gapStart - n);
            this.gapStart = n;
        }
        if (n2 > this.gapEnd) {
            this.base.clearBuffer(this.gapEnd, n2 - this.gapEnd);
            this.gapEnd = n2;
        }
    }

    public void clear() {
        this.remove(0, null, this.base.getBufferLength() << 1, null);
    }

    protected void makePosition(int n, boolean bl, PositionContainer positionContainer, int n2) {
        if (n > this.gapStart) {
            n += this.gapEnd - this.gapStart;
        }
        positionContainer.setPosition(n2, n << 1 | (bl ? 1 : 0), null);
        positionContainer.setSequence(n2, this);
    }

    protected boolean isAfter(int n, Object object2) {
        return (n & 1) != 0;
    }

    protected int nextIndex(int n, Object object2) {
        int n2 = n >>> 1;
        if (n2 > this.gapStart) {
            n2 -= this.gapEnd - this.gapStart;
        }
        return n2;
    }

    public void consume(int n, Object object2, int n2, Object object3, Consumer consumer) {
        if (consumer.ignoring()) {
            return;
        }
        int n3 = n >>> 1;
        int n4 = n2 >>> 1;
        if (n3 < this.gapStart) {
            int n5 = n4 > this.gapStart ? n4 : this.gapStart;
            this.consume(n, null, n5 << 1, null, consumer);
        }
        if (n4 > this.gapEnd) {
            n3 = n3 < this.gapEnd ? this.gapEnd : n3;
            this.consume(n3 << 1, null, n2, null, consumer);
        }
    }
}

