/*
 * Decompiled with CFR 0.152.
 */
package gnu.jemacs.lang;

import gnu.expr.Declaration;
import gnu.expr.Expression;
import gnu.expr.ModuleExp;
import gnu.expr.ScopeExp;
import gnu.expr.SetExp;
import gnu.lists.LList;
import gnu.lists.Pair;
import gnu.mapping.Binding;
import java.util.Vector;
import kawa.lang.Syntax;
import kawa.lang.Translator;

public class defcustom
extends Syntax {
    public boolean scanForDefinitions(Pair pair, Vector vector, ScopeExp scopeExp, Translator translator) {
        if (!(pair.cdr instanceof Pair)) {
            return super.scanForDefinitions(pair, vector, scopeExp, translator);
        }
        Pair pair2 = (Pair)pair.cdr;
        Object object2 = pair2.car;
        if (object2 instanceof String || object2 instanceof Binding) {
            String string = object2.toString();
            Declaration declaration = scopeExp.lookup(string);
            if (declaration == null) {
                declaration = new Declaration(string);
                scopeExp.addDeclaration(declaration);
            } else {
                translator.error('w', "duplicate declaration for `" + string + "'");
            }
            pair2 = Translator.makePair(pair2, declaration, pair2.cdr);
            pair = Translator.makePair(pair, this, pair2);
            if (scopeExp instanceof ModuleExp) {
                declaration.setCanRead(true);
                declaration.setCanWrite(true);
            }
        }
        vector.addElement(pair);
        return true;
    }

    public Expression rewriteForm(Pair pair, Translator translator) {
        Object object2;
        Object object3 = pair.cdr;
        String string = null;
        Expression expression = null;
        Declaration declaration = null;
        if (object3 instanceof Pair) {
            object2 = (Pair)object3;
            if (((Pair)object2).car instanceof Declaration) {
                declaration = (Declaration)((Pair)object2).car;
                string = declaration.getName();
                if (((Pair)object2).cdr instanceof Pair) {
                    Pair pair2 = (Pair)((Pair)object2).cdr;
                    expression = translator.rewrite(pair2.car);
                    if (pair2.cdr != LList.Empty) {
                        // empty if block
                    }
                } else if (((Pair)object2).cdr != LList.Empty) {
                    string = null;
                }
            }
        }
        if (string == null) {
            return translator.syntaxError("invalid syntax for " + this.getName());
        }
        object2 = new SetExp(string, expression);
        ((SetExp)object2).setDefining(true);
        if (declaration != null) {
            ((SetExp)object2).binding = declaration;
            if (declaration.context instanceof ModuleExp && declaration.getCanWrite()) {
                expression = null;
            }
            declaration.noteValue(expression);
        }
        return object2;
    }
}

