/*
 * Decompiled with CFR 0.152.
 */
package gnu.jemacs.buffer;

import gnu.expr.Interpreter;
import gnu.jemacs.buffer.Buffer;
import gnu.jemacs.buffer.BufferWriter;
import gnu.jemacs.buffer.Marker;
import gnu.mapping.Environment;
import gnu.mapping.Future;
import gnu.mapping.InPort;
import gnu.mapping.OutPort;
import gnu.mapping.TtyInPort;
import gnu.text.QueueReader;
import java.io.Writer;
import javax.swing.text.BadLocationException;
import javax.swing.text.Segment;
import kawa.repl;

public class ReplBuffer
extends Buffer {
    Marker processMark;
    BufferWriter processWriter;
    QueueReader in_r;
    InPort in;
    OutPort out;
    OutPort err;
    Future thread;

    public ReplBuffer(Interpreter interpreter, Environment environment) {
        super(interpreter.getName() + " interaction");
        this.inputStyle = Buffer.redStyle;
        this.processMark = new Marker(this, 0, false);
        this.processWriter = new BufferWriter(this.processMark, true);
        this.in_r = new QueueReader();
        this.out = new OutPort((Writer)this.processWriter, true, true);
        this.err = new OutPort((Writer)this.processWriter, true, true);
        this.in = new TtyInPort(this.in_r, "<stdin>", this.out);
        this.thread = new Future(new repl(interpreter), environment, this.in, this.out, this.err);
        this.thread.start();
    }

    public void enter() {
        this.insert('\n', 1, null);
        int n = this.getDot();
        int n2 = this.processMark.getOffset();
        Segment segment = new Segment();
        try {
            this.getText(n2, n - n2, segment);
        }
        catch (BadLocationException badLocationException) {
            throw new RuntimeException("internal error: " + badLocationException);
        }
        this.processMark.setDot(n);
        this.in_r.append(segment.array, segment.offset, segment.count);
    }

    public static ReplBuffer make(String string) {
        return ReplBuffer.make(Interpreter.getInstance(string));
    }

    public static ReplBuffer make(Interpreter interpreter) {
        return new ReplBuffer(interpreter, Environment.getCurrent());
    }
}

