/*
 * Decompiled with CFR 0.152.
 */
package gnu.jemacs.buffer;

import gnu.jemacs.buffer.Buffer;
import gnu.jemacs.buffer.BufferContent;
import gnu.mapping.InPort;
import gnu.text.NullReader;
import java.io.IOException;

public class BufferReader
extends InPort {
    BufferContent content;
    int rangeStart;
    int rangeLength;

    public BufferReader(Buffer buffer, int n, int n2) {
        this(buffer.content, buffer.getName(), n, n2);
    }

    public BufferReader(BufferContent bufferContent, String string, int n, int n2) {
        super(NullReader.nullReader, string);
        this.content = bufferContent;
        this.buffer = bufferContent.getArray();
        this.rangeStart = n;
        this.rangeLength = n2;
        if (n < bufferContent.gapStart) {
            this.pos = n;
            this.limit = n + n2;
            if (this.limit > bufferContent.gapStart) {
                this.limit = bufferContent.gapStart;
            }
        } else {
            int n3 = bufferContent.gapEnd - bufferContent.gapStart;
            this.pos = n + n3;
            int n4 = bufferContent.getArray().length;
            this.limit = this.pos + n2 > n4 ? n4 : this.pos + n2;
        }
    }

    public int read() {
        if (this.pos < this.limit) {
            return this.buffer[this.pos++];
        }
        if (this.limit == this.content.gapStart) {
            int n = this.content.gapEnd - this.content.gapStart;
            this.pos = this.content.gapEnd;
            int n2 = this.rangeLength - (this.content.gapStart - this.rangeStart);
            int n3 = this.content.getArray().length;
            int n4 = this.limit = this.pos + n2 > n3 ? n3 : this.pos + n2;
            if (this.pos < this.limit) {
                return this.buffer[this.pos++];
            }
        }
        return -1;
    }

    public void reset() throws IOException {
        if (this.readAheadLimit <= 0) {
            throw new IOException("mark invalid");
        }
        if (this.pos >= this.content.gapEnd && this.markPos <= this.content.gapStart) {
            this.limit = this.content.gapEnd;
        }
        this.pos = this.markPos;
        this.readAheadLimit = 0;
    }

    public int getLineNumber() {
        throw new Error("BufferReader.getLineNumber - not implemented");
    }

    public int getColumnNumber() {
        throw new Error("BufferReader.getColumnNumber - not implemented");
    }
}

