/*
 * Decompiled with CFR 0.152.
 */
package gnu.commonlisp.lang;

import gnu.bytecode.Type;
import gnu.commonlisp.lang.CLispReader;
import gnu.commonlisp.lang.Lisp2;
import gnu.commonlisp.lang.Symbol;
import gnu.commonlisp.lang.SymbolTable;
import gnu.commonlisp.lang.UnwindProtect;
import gnu.commonlisp.lang.defun;
import gnu.commonlisp.lang.defvar;
import gnu.commonlisp.lang.setq;
import gnu.expr.Interpreter;
import gnu.kawa.functions.DisplayFormat;
import gnu.kawa.functions.IsEq;
import gnu.kawa.functions.IsEqual;
import gnu.kawa.lispexpr.LangPrimType;
import gnu.kawa.reflect.InstanceOf;
import gnu.lists.FormatToConsumer;
import gnu.mapping.Binding;
import gnu.mapping.BindingEnumeration;
import gnu.mapping.Environment;
import gnu.mapping.InPort;
import gnu.mapping.Named;
import gnu.mapping.Procedure;
import gnu.math.IntNum;
import gnu.math.Numeric;
import gnu.text.Char;
import gnu.text.Lexer;
import gnu.text.SourceMessages;
import gnu.text.SyntaxException;
import java.io.IOException;
import kawa.lang.Lambda;
import kawa.lang.Syntax;
import kawa.standard.Scheme;
import kawa.standard.and_or;
import kawa.standard.begin;
import kawa.standard.ifp;
import kawa.standard.not;

public class CommonLisp
extends Lisp2 {
    static boolean charIsInt = false;
    static CommonLisp instance;
    static int lispCounter;
    static final DisplayFormat writeFormat;
    static final DisplayFormat displayFormat;
    LangPrimType booleanType;

    public static Object getCharacter(int n) {
        if (charIsInt) {
            return IntNum.make(n);
        }
        return Char.make((char)n);
    }

    public static Numeric asNumber(Object object2) {
        if (object2 instanceof Char) {
            return IntNum.make(((Char)object2).intValue());
        }
        return (Numeric)object2;
    }

    public static char asChar(Object object2) {
        if (object2 instanceof Char) {
            return ((Char)object2).charValue();
        }
        int n = object2 instanceof Numeric ? ((Numeric)object2).intValue() : -1;
        if (n < 0 || n > 65535) {
            throw new ClassCastException("not a character value");
        }
        return (char)n;
    }

    public Lexer getLexer(InPort inPort, SourceMessages sourceMessages) {
        return new CLispReader(inPort, sourceMessages);
    }

    public String getName() {
        return "CommonLisp";
    }

    protected void defun(String string, Object object2) {
        Named named;
        Symbol.setFunctionBinding(this.environ, string, object2);
        if (object2 instanceof Named && (named = (Named)object2).getName() == null) {
            named.setName(string);
        }
    }

    private void defun(Procedure procedure) {
        this.defun(procedure.getName(), procedure);
    }

    public CommonLisp() {
        Object object2;
        Named named;
        Environment environment = Scheme.builtin();
        this.environ = SymbolTable.make("interaction-environment." + ++lispCounter);
        Environment.setCurrent(this.environ);
        Lisp2.TRUE = this.environ.getBinding("t");
        Lisp2.TRUE.set(Lisp2.TRUE);
        this.define("nil", Lisp2.FALSE);
        BindingEnumeration bindingEnumeration = environment.enumerateAllBindings();
        while (bindingEnumeration.hasMoreElements()) {
            named = bindingEnumeration.nextBinding();
            if (!((Binding)named).isBound()) continue;
            object2 = ((Procedure)named).getName();
            Object object3 = ((Binding)named).get();
            if (object3 instanceof Procedure || object3 instanceof Syntax) {
                this.defun((String)object2, object3);
                continue;
            }
            this.define((String)object2, object3);
        }
        if (instance == null) {
            instance = this;
        }
        try {
            this.loadClass("kawa.lib.std_syntax");
            this.loadClass("kawa.lib.lists");
            this.loadClass("kawa.lib.strings");
            this.loadClass("gnu.commonlisp.lisp.PrimOps");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        named = new Lambda();
        ((Lambda)named).setKeywords(Lisp2.getSymbol("&optional"), Lisp2.getSymbol("&rest"), Lisp2.getSymbol("&key"));
        ((Lambda)named).defaultDefault = Lisp2.nilExpr;
        this.defun("lambda", named);
        this.defun("defun", new defun((Lambda)named));
        this.defun("defvar", new defvar(false));
        this.defun("defconst", new defvar(true));
        this.defun("defsubst", new defun((Lambda)named));
        this.defun("setq", new setq());
        this.defun("progn", new begin());
        this.defun("if", new ifp());
        this.defun("or", new and_or(false, this));
        this.defun("and", new and_or(true, this));
        this.defun("unwind-protect", new UnwindProtect());
        object2 = new not(this);
        this.defun("not", object2);
        this.defun("null", object2);
        this.defun("eq", new IsEq(this, "eq"));
        this.defun("equal", new IsEqual(this, "equal"));
        this.defun("typep", new InstanceOf(this));
        this.defun("princ", displayFormat);
        this.defun("prin1", writeFormat);
    }

    public static CommonLisp getInstance() {
        if (instance == null) {
            Environment environment = Environment.getCurrent();
            try {
                instance = new CommonLisp();
                Object var2_1 = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                Environment.setCurrent(environment);
                throw throwable;
            }
            Environment.setCurrent(environment);
            {
            }
        }
        return instance;
    }

    public static void registerEnvironment() {
        CommonLisp commonLisp = new CommonLisp();
        Interpreter.defaultInterpreter = commonLisp;
        Environment.setCurrent(commonLisp.getEnvironment());
    }

    public Object read(InPort inPort) throws IOException, SyntaxException {
        return CLispReader.readObject(inPort);
    }

    public FormatToConsumer getFormat(boolean bl) {
        return bl ? writeFormat : displayFormat;
    }

    public Type getTypeFor(String string) {
        if (string == "t") {
            string = "java.lang.Object";
        }
        return Scheme.string2Type(string);
    }

    public Type getTypeFor(Class clazz) {
        if (clazz.isPrimitive()) {
            String string = clazz.getName();
            if (string.equals("boolean")) {
                if (this.booleanType == null) {
                    this.booleanType = new LangPrimType(Type.boolean_type, this);
                }
                return this.booleanType;
            }
            return Scheme.getNamedType(string);
        }
        return Type.make(clazz);
    }

    public void defineFromFieldValue(String string, Object object2) throws Throwable {
        string = object2 instanceof Named ? ((Named)object2).getName() : string.intern();
        if (object2 instanceof Binding) {
            this.environ.addBinding((Binding)object2);
        } else if (object2 instanceof Procedure || object2 instanceof Syntax) {
            Symbol.setFunctionBinding(this.environ, string, object2);
        } else {
            this.environ.define(string, object2);
        }
    }

    static {
        lispCounter = 0;
        writeFormat = new DisplayFormat(true, 'C');
        displayFormat = new DisplayFormat(false, 'C');
    }
}

