/*
 * Decompiled with CFR 0.152.
 */
package turtlekit2.kernel;

import java.awt.Graphics;
import turtlekit2.kernel.GridCanvas;
import turtlekit2.kernel.Observer;
import turtlekit2.kernel.Patch;
import turtlekit2.kernel.Turtle;
import turtlekit2.kernel.TurtleProbe;

public class Viewer
extends Observer {
    int cellSize;
    GridCanvas onScreen;
    int cpt = 10;
    int flashTime = 10;
    boolean flash = false;
    boolean show = true;
    boolean redrawAll = false;
    TurtleProbe allTurtles;

    public void setFlash(boolean bl) {
        if (bl) {
            this.redrawAll = true;
            this.onScreen.display();
            this.redrawAll = false;
        }
        this.flash = bl;
    }

    public boolean getRedrawAll() {
        return this.redrawAll;
    }

    public void setRedrawAll(boolean bl) {
        this.redrawAll = bl;
    }

    public boolean getFlash() {
        return this.flash;
    }

    public void setShow(boolean bl) {
        if (bl && !this.show && this.onScreen != null) {
            this.redrawAll = true;
            this.onScreen.display();
            this.redrawAll = false;
            this.show = true;
        } else {
            this.show = bl;
        }
    }

    public boolean getShow() {
        return this.show;
    }

    public void setFlashStepSize(int n) {
        this.cpt = this.flashTime = n;
    }

    public int getFlashStepSize() {
        return this.flashTime;
    }

    public void initGUI() {
        this.onScreen = new GridCanvas(this.cellSize * this.envWidth, this.cellSize * this.envHeight, this);
        this.setGUIObject(this.onScreen);
    }

    public void setup() {
        this.leaveRole("Tkit", this.getSimulationGroup(), "observer");
        this.requestRole("Tkit", this.getSimulationGroup(), "viewer", null);
        this.allTurtles = new TurtleProbe(this.getSimulationGroup(), "turtle");
        this.addProbe(this.allTurtles);
        this.onScreen.initialisation();
    }

    public void paintPatch(Graphics graphics, Patch patch, int n, int n2, int n3) {
        graphics.setColor(patch.color);
        graphics.fillRect(n, n2, n3, n3);
    }

    public void paintTurtle(Graphics graphics, Turtle turtle, int n, int n2, int n3) {
        graphics.setColor(turtle.color);
        graphics.fillRect(n, n2, n3, n3);
    }

    final void paintInfo(Graphics graphics) {
        int n;
        int n2;
        if (this.redrawAll) {
            for (n2 = this.envWidth - 1; n2 >= 0; --n2) {
                for (n = this.envHeight - 1; n >= 0; --n) {
                    this.paintPatch(graphics, this.patchGrid[n2][n], n2 * this.cellSize, (this.envHeight - n - 1) * this.cellSize, this.cellSize);
                }
            }
        } else {
            for (n2 = this.envWidth - 1; n2 >= 0; --n2) {
                for (n = this.envHeight - 1; n >= 0; --n) {
                    if (!this.patchGrid[n2][n].change) continue;
                    this.paintPatch(graphics, this.patchGrid[n2][n], n2 * this.cellSize, (this.envHeight - n - 1) * this.cellSize, this.cellSize);
                }
            }
        }
        Turtle[] turtleArray = this.allTurtles.getTurtles();
        for (n = turtleArray.length - 1; n >= 0; --n) {
            if (turtleArray[n] == null || turtleArray[n].hidden) continue;
            this.paintTurtle(graphics, turtleArray[n], turtleArray[n].xcor() * this.cellSize, (this.envHeight - turtleArray[n].ycor() - 1) * this.cellSize, this.cellSize);
        }
    }

    public void display() {
        if (this.show) {
            if (this.flash) {
                --this.cpt;
                if (this.cpt < 0) {
                    this.redrawAll = true;
                    this.cpt = this.flashTime;
                    this.onScreen.display();
                    this.redrawAll = false;
                }
            } else {
                this.onScreen.display();
            }
        }
    }

    public GridCanvas getOnScreen() {
        return this.onScreen;
    }

    public void setOnScreen(GridCanvas gridCanvas) {
        this.onScreen = gridCanvas;
    }

    public int getCellSize() {
        return this.cellSize;
    }
}

