/*
 * Decompiled with CFR 0.152.
 */
package turtlekit2.kernel;

import madkit.kernel.Activator;
import madkit.kernel.Message;
import madkit.kernel.Scheduler;
import madkit.simulation.activators.TurboMethodActivator;
import turtlekit2.kernel.TopMessage;
import turtlekit2.kernel.TurtleActivator;

public class TurtleScheduler
extends Scheduler {
    public static final int RUNNING = 1;
    public static final int PAUSED = 2;
    public static final int STOPED = 3;
    public static final int STEP = 4;
    public int schedulingState;
    String group;
    TurtleActivator turtleDoIt;
    TurboMethodActivator oberserversDoIt;
    TurboMethodActivator viewersDoIt;
    TurboMethodActivator displayAllWorld;
    TurboMethodActivator updateDisplay;
    TurboMethodActivator evaporation;
    TurboMethodActivator diffusion;
    int iteration = 0;
    int delay = 100;

    public TurtleScheduler(String string) {
        this.group = string;
        this.schedulingState = 2;
    }

    public void activate() {
        this.requestRole("Tkit", this.group, "scheduler", null);
        this.turtleDoIt = new TurtleActivator(this.group);
        this.addActivator(this.turtleDoIt);
        this.oberserversDoIt = new TurboMethodActivator("watch", "Tkit", this.group, "observer");
        this.addActivator((Activator)this.oberserversDoIt);
        this.viewersDoIt = new TurboMethodActivator("display", "Tkit", this.group, "viewer");
        this.addActivator((Activator)this.viewersDoIt);
        this.diffusion = new TurboMethodActivator("diffusion", "Tkit", this.group, "world");
        this.addActivator((Activator)this.diffusion);
        this.evaporation = new TurboMethodActivator("evaporation", "Tkit", this.group, "world");
        this.addActivator((Activator)this.evaporation);
        this.displayAllWorld = new TurboMethodActivator("displayOn", "Tkit", this.group, "world");
        this.addActivator((Activator)this.displayAllWorld);
        this.updateDisplay = new TurboMethodActivator("displayOff", "Tkit", this.group, "world");
        this.addActivator((Activator)this.updateDisplay);
        this.sendMessage("Tkit", this.group, "launcher", new TopMessage(-1));
    }

    public void live() {
        block6: while (true) {
            this.exitImmediatlyOnKill();
            if (this.delay == 0) {
                Thread.yield();
            } else {
                this.pause(this.delay);
            }
            this.checkMail();
            switch (this.schedulingState) {
                case 1: {
                    this.running();
                    continue block6;
                }
                case 2: {
                    this.paused();
                    continue block6;
                }
                case 4: {
                    this.schedulingState = 2;
                    this.running();
                    continue block6;
                }
                case 3: {
                    this.stoped();
                    continue block6;
                }
            }
            break;
        }
    }

    public void running() {
        this.scheduleWorld();
        ++this.iteration;
    }

    public void paused() {
        this.pause(50);
        this.displayAllWorld.execute();
        this.viewersDoIt.execute();
    }

    public void stoped() {
        this.iteration = 0;
        this.pause(300);
    }

    public void end() {
        this.println("ending");
        this.schedulingState = 3;
        this.removeAllActivators();
        this.sendMessage("Tkit", this.group, "launcher", new TopMessage(0));
        this.leaveGroup(this.group);
    }

    private final void checkMail() {
        Message message = this.nextMessage();
        if (message != null && message instanceof TopMessage) {
            this.schedulingState = ((TopMessage)message).getValue();
            if (this.schedulingState == 2 || this.schedulingState == 3) {
                this.sendMessage(message.getSender(), new TopMessage(0));
            }
        }
    }

    protected final void executeTurtles() {
        this.turtleDoIt.execute();
    }

    protected final void executeDiffusion() {
        this.diffusion.execute();
    }

    protected final void executeEvaporation() {
        this.evaporation.execute();
    }

    protected final void executeObservers() {
        this.oberserversDoIt.execute();
    }

    protected final void executeDisplay() {
        this.viewersDoIt.execute();
        this.updateDisplay.execute();
    }

    protected final void incrementeIteration() {
        ++this.iteration;
    }

    public void scheduleWorld() {
        this.executeTurtles();
        this.executeDiffusion();
        this.executeEvaporation();
        this.executeObservers();
        this.executeDisplay();
    }
}

