/*
 * Decompiled with CFR 0.152.
 */
package turtlekit2.kernel;

import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import madkit.kernel.AbstractAgent;
import madkit.kernel.ReferenceableAgent;
import turtlekit2.kernel.Patch;
import turtlekit2.kernel.PatchVariable;
import turtlekit2.kernel.Turtle;
import turtlekit2.pheromone.GridVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TurtleEnvironment
extends AbstractAgent
implements ReferenceableAgent,
Serializable {
    Map<String, Integer> variables = null;
    public Map<String, GridVariable> gridVariables = new HashMap<String, GridVariable>();
    Map<String, Double> diffuseCoef = null;
    Map<String, Double> evapCoef = null;
    public Patch[][] grid = new Patch[0][0];
    public int x;
    public int y;
    int turtlesCount = -1;
    String simulationGroup;
    public boolean wrap = true;
    Map<Integer, Turtle> launchedTurtles = new HashMap<Integer, Turtle>();
    public ArrayList pheromones = new ArrayList();

    public TurtleEnvironment(int n, int n2, String string) {
        this.x = n;
        this.y = n2;
        this.grid = new Patch[this.x][this.y];
        this.initGrid();
        this.simulationGroup = string;
    }

    public void displayOff() {
        for (int i = this.x - 1; i >= 0; --i) {
            for (int j = this.y - 1; j >= 0; --j) {
                if (!this.grid[i][j].change) continue;
                this.grid[i][j].change = false;
            }
        }
    }

    public void displayOn() {
        for (int i = this.x - 1; i >= 0; --i) {
            for (int j = this.y - 1; j >= 0; --j) {
                this.grid[i][j].change = true;
            }
        }
    }

    final void addVariables(String[] stringArray, double[] dArray) {
        int n;
        this.variables = new HashMap<String, Integer>(stringArray.length);
        for (n = 0; n < stringArray.length; ++n) {
            this.variables.put(stringArray[n], new Integer(n));
        }
        for (n = this.x - 1; n >= 0; --n) {
            for (int i = this.y - 1; i >= 0; --i) {
                double[] dArray2 = new double[dArray.length];
                for (int j = 0; j < stringArray.length; ++j) {
                    dArray2[j] = dArray[j];
                }
                this.grid[n][i].variableValue = dArray2;
            }
        }
    }

    final void diffuseVariables(String[] stringArray, double[] dArray) {
        this.diffuseCoef = new HashMap<String, Double>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            this.diffuseCoef.put(stringArray[i], new Double(dArray[i]));
        }
    }

    final void evapVariables(String[] stringArray, double[] dArray) {
        this.evapCoef = new HashMap<String, Double>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            this.evapCoef.put(stringArray[i], new Double(dArray[i]));
        }
    }

    final void initNeighborhood() {
        if (this.wrap) {
            for (int i = this.x - 1; i >= 0; --i) {
                for (int j = this.y - 1; j >= 0; --j) {
                    Patch[] patchArray = new Patch[8];
                    patchArray[0] = this.grid[(i + 1) % this.x][j];
                    patchArray[7] = this.grid[(i + 1) % this.x][(j - 1 + this.y) % this.y];
                    patchArray[6] = this.grid[i][(j - 1 + this.y) % this.y];
                    patchArray[5] = this.grid[(i - 1 + this.x) % this.x][(j - 1 + this.y) % this.y];
                    patchArray[4] = this.grid[(i - 1 + this.x) % this.x][j];
                    patchArray[3] = this.grid[(i - 1 + this.x) % this.x][(j + 1) % this.y];
                    patchArray[2] = this.grid[i][(j + 1) % this.y];
                    patchArray[1] = this.grid[(i + 1) % this.x][(j + 1) % this.y];
                    this.grid[i][j].setNeighborhood(patchArray);
                }
            }
        } else {
            for (int i = this.x - 1; i >= 0; --i) {
                for (int j = this.y - 1; j >= 0; --j) {
                    Patch[] patchArray;
                    if (i == 0) {
                        patchArray = j > 0 && j < this.y - 1 ? new Patch[]{this.grid[i + 1][j], this.grid[i + 1][j + 1], this.grid[i][j + 1], this.grid[i][j - 1], this.grid[i + 1][j - 1]} : (j == 0 ? new Patch[]{this.grid[i + 1][j], this.grid[i + 1][j + 1], this.grid[i][j + 1]} : new Patch[]{this.grid[i + 1][j], this.grid[i][j - 1], this.grid[i + 1][j - 1]});
                    } else if (i == this.x - 1) {
                        patchArray = j > 0 && j < this.y - 1 ? new Patch[]{this.grid[i][j + 1], this.grid[i - 1][j + 1], this.grid[i - 1][j], this.grid[i - 1][j - 1], this.grid[i][j - 1]} : (j == 0 ? new Patch[]{this.grid[i][j + 1], this.grid[i - 1][j + 1], this.grid[i - 1][j]} : new Patch[]{this.grid[i - 1][j], this.grid[i - 1][j - 1], this.grid[i][j - 1]});
                    } else if (j == 0) {
                        patchArray = new Patch[]{this.grid[i + 1][j], this.grid[i + 1][j + 1], this.grid[i][j + 1], this.grid[i - 1][j + 1], this.grid[i - 1][j]};
                    } else if (j == this.y - 1) {
                        patchArray = new Patch[]{this.grid[i + 1][j], this.grid[i - 1][j], this.grid[i - 1][j - 1], this.grid[i][j - 1], this.grid[i + 1][j - 1]};
                    } else {
                        patchArray = new Patch[8];
                        patchArray[0] = this.grid[i + 1][j];
                        patchArray[7] = this.grid[i + 1][j - 1];
                        patchArray[6] = this.grid[i][j - 1];
                        patchArray[5] = this.grid[i - 1][j - 1];
                        patchArray[4] = this.grid[i - 1][j];
                        patchArray[3] = this.grid[i - 1][j + 1];
                        patchArray[2] = this.grid[i][j + 1];
                        patchArray[1] = this.grid[i + 1][j + 1];
                    }
                    this.grid[i][j].setNeighborhood(patchArray);
                }
            }
        }
    }

    final void initGrid() {
        for (int i = this.x - 1; i >= 0; --i) {
            for (int j = this.y - 1; j >= 0; --j) {
                this.grid[i][j] = new Patch(this, i, j);
            }
        }
    }

    public final void diffusion() {
        for (GridVariable gridVariable : this.gridVariables.values()) {
            gridVariable.diffusion();
        }
        for (int i = this.x - 1; i >= 0; --i) {
            for (int j = this.y - 1; j >= 0; --j) {
                this.grid[i][j].change = true;
            }
        }
    }

    public final void evaporation() {
        for (GridVariable gridVariable : this.gridVariables.values()) {
            gridVariable.evaporation();
        }
    }

    public final synchronized void clearAllTurtles() {
        Iterator<Turtle> iterator = this.getTurtlesList().iterator();
        while (iterator.hasNext()) {
            Turtle turtle = iterator.next();
            turtle.position.removeAgent(turtle);
            this.killAgent(turtle);
            iterator.remove();
        }
    }

    final int createAgent(Turtle turtle, int n, int n2) {
        ++this.turtlesCount;
        turtle.initialisation(n, n2, this, this.turtlesCount, this.grid[n][n2]);
        this.grid[n][n2].addAgent(turtle);
        this.launchedTurtles.put(new Integer(this.turtlesCount), turtle);
        this.launchAgent(turtle, "turtle" + this.turtlesCount, false);
        return this.turtlesCount;
    }

    final int addAgent(Turtle turtle) {
        return this.createAgent(turtle, (int)(Math.random() * (double)this.x), (int)(Math.random() * (double)this.y));
    }

    final int addAgent(Turtle turtle, int n, int n2) {
        return this.createAgent(turtle, n % this.x, n2 % this.y);
    }

    final void removeTurtle(Turtle turtle) {
        turtle.position.removeAgent(turtle);
        this.launchedTurtles.remove(new Integer(turtle.mySelf()));
        this.killAgent(turtle);
    }

    final Turtle getTurtleWithID(int n) {
        return this.launchedTurtles.get(new Integer(n));
    }

    public final Collection<Turtle> getTurtlesList() {
        return this.launchedTurtles.values();
    }

    final Turtle[] turtlesAt(int n, int n2) {
        return this.grid[n][n2].getTurtles();
    }

    final int turtlesCountAt(int n, int n2) {
        return this.grid[n][n2].size();
    }

    final Color getPatchColor(int n, int n2) {
        return this.grid[n][n2].color;
    }

    final void setPatchColor(Color color, int n, int n2) {
        this.grid[n][n2].setColor(color);
    }

    final void moveTurtle(double d, double d2, Turtle turtle) {
        int n;
        int n2 = (int)Math.round(d) % this.x;
        if (this.grid[n2][n = (int)Math.round(d2) % this.y] != turtle.position) {
            turtle.position.removeAgent(turtle);
            this.grid[n2][n].addAgent(turtle);
        }
    }

    public final void activate() {
        this.requestRole("Tkit", this.simulationGroup, "world", null);
    }

    public void addGridVariable(PatchVariable patchVariable) {
        GridVariable gridVariable = new GridVariable(this);
        gridVariable.setDiffuseCoef(patchVariable.diffCoef);
        gridVariable.setEvapCoef(patchVariable.evaporation);
        this.gridVariables.put(patchVariable.name, gridVariable);
    }

    public void clearVariable(String string) {
        for (int i = this.x - 1; i >= 0; --i) {
            for (int j = this.y - 1; j >= 0; --j) {
                this.grid[i][j].setPatchVariable(string, 0.0);
            }
        }
    }

    public void clearVariables(ArrayList<PatchVariable> arrayList) {
        for (int i = 0; i < arrayList.size(); ++i) {
            this.clearVariable(arrayList.get(i).getName());
            System.out.println(arrayList.get(i).getName());
        }
    }
}

