/*
 * Decompiled with CFR 0.152.
 */
package turtlekit2.kernel;

import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import madkit.kernel.Probe;
import madkit.kernel.ReferenceableAgent;
import madkit.kernel.Watcher;
import turtlekit2.kernel.EnvProbe;
import turtlekit2.kernel.Patch;
import turtlekit2.kernel.PatchVariable;
import turtlekit2.kernel.XMLAttributes;
import turtlekit2.pheromone.GridVariable;

public abstract class Observer
extends Watcher
implements ReferenceableAgent {
    String simulationGroup = null;
    public Patch[][] patchGrid;
    public Map<String, GridVariable> gridValues = new HashMap<String, GridVariable>();
    public int envWidth;
    public int envHeight;
    public XMLAttributes attrib;
    Vector flavors;

    public void activate() {
        this.println("activated");
        this.requestRole("Tkit", this.simulationGroup, "observer", null);
        this.addProbe((Probe)new EnvProbe("grid", this.simulationGroup, "world", this));
        this.addProbe((Probe)new EnvProbe("gridVariables", this.simulationGroup, "world", this));
        this.setup();
    }

    public double[][] getAllValues(String string) {
        if (this.gridValues != null && this.gridValues.get(string) != null) {
            return this.gridValues.get(string).getAllValues();
        }
        return null;
    }

    public final String getSimulationGroup() {
        return this.simulationGroup;
    }

    public void watch() {
    }

    public void setup() {
    }

    final synchronized void updateWorldData(Object object) {
        if (object instanceof Patch[][]) {
            this.patchGrid = (Patch[][])object;
        } else {
            this.gridValues = (Map)object;
        }
    }

    public XMLAttributes getAttrib() {
        return this.attrib;
    }

    public void setAttrib(XMLAttributes xMLAttributes) {
        this.attrib = xMLAttributes;
    }

    public Vector getFlavors() {
        return this.flavors;
    }

    public PatchVariable getFlavor(int n) {
        return (PatchVariable)this.flavors.get(n);
    }

    public String getFlavorName(int n) {
        return ((PatchVariable)this.flavors.get(n)).getName();
    }

    public boolean flavorsContains(String string) {
        for (int i = 0; i < this.flavors.size(); ++i) {
            if (!((PatchVariable)this.flavors.get(i)).getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public void setFlavors(Vector vector) {
        this.flavors = vector;
    }
}

