/*
 * Decompiled with CFR 0.152.
 */
package turtlekit2.genetic;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import turtlekit2.genetic.ExtendedJButton;
import turtlekit2.genetic.ExtendedJPopupMenu;
import turtlekit2.genetic.Gene;
import turtlekit2.genetic.GeneticFileManager;
import turtlekit2.genetic.Genome;
import turtlekit2.genetic.Pool;

public class PoolGUI
extends JPanel {
    ExtendedJPopupMenu genomePopupMenu;
    Pool myPool;

    public PoolGUI(Pool pool) {
        this.myPool = pool;
        this.refresh();
    }

    public void createPopupMenu() {
        this.genomePopupMenu = new ExtendedJPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Save");
        JMenuItem jMenuItem2 = new JMenuItem("Replace");
        JMenuItem jMenuItem3 = new JMenuItem("Reset");
        JMenuItem jMenuItem4 = new JMenuItem("Note Genome");
        JMenuItem jMenuItem5 = new JMenuItem("SetFitness");
        JMenuItem jMenuItem6 = new JMenuItem("SetState");
        JMenuItem jMenuItem7 = new JMenuItem("Remove");
        JMenuItem jMenuItem8 = new JMenuItem("Add Gene to Genome");
        this.genomePopupMenu.add(jMenuItem);
        this.genomePopupMenu.add(jMenuItem2);
        this.genomePopupMenu.add(jMenuItem3);
        this.genomePopupMenu.add(jMenuItem4);
        this.genomePopupMenu.add(jMenuItem5);
        this.genomePopupMenu.add(jMenuItem6);
        this.genomePopupMenu.add(jMenuItem7);
        this.genomePopupMenu.add(jMenuItem8);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PoolGUI.this.saveGenomeEvent(actionEvent);
            }
        });
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PoolGUI.this.replaceGenomeEvent(actionEvent);
            }
        });
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PoolGUI.this.resetGenomeEvent(actionEvent);
            }
        });
        jMenuItem4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PoolGUI.this.noteGenomeEvent(actionEvent);
            }
        });
        jMenuItem5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PoolGUI.this.setFitnessEvent(actionEvent);
            }
        });
        jMenuItem6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PoolGUI.this.setStateEvent(actionEvent);
            }
        });
        jMenuItem7.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PoolGUI.this.removeGenomeEvent(actionEvent);
            }
        });
        jMenuItem8.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PoolGUI.this.addGeneEvent(actionEvent);
            }
        });
    }

    public void createPanelContent() {
        this.setLayout(new GridLayout(this.myPool.getSize(), 3, 25, 5));
        for (int i = 0; i < this.myPool.getSize(); ++i) {
            ExtendedJButton extendedJButton = new ExtendedJButton("Genome " + new Integer(i).toString(), this.myPool.getGenome(i), i);
            extendedJButton.addMouseListener(new MouseListener(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    if ((mouseEvent.getModifiers() & 0x10) != 0) {
                        PoolGUI.this.displayGenome(((ExtendedJButton)mouseEvent.getSource()).getGenome(), ((ExtendedJButton)mouseEvent.getSource()).getIndex());
                    }
                }

                public void mouseEntered(MouseEvent mouseEvent) {
                }

                public void mousePressed(MouseEvent mouseEvent) {
                    if ((mouseEvent.getModifiers() & 4) != 0) {
                        PoolGUI.this.genomePopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY(), ((ExtendedJButton)mouseEvent.getSource()).getGenome());
                    }
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                    if ((mouseEvent.getModifiers() & 4) != 0) {
                        PoolGUI.this.genomePopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY(), ((ExtendedJButton)mouseEvent.getSource()).getGenome());
                    }
                }

                public void mouseExited(MouseEvent mouseEvent) {
                }
            });
            JLabel jLabel = new JLabel(new Integer(this.myPool.getGenome(i).getState()).toString());
            JLabel jLabel2 = this.myPool.getGenome(i).getFitnessLabel();
            this.add(extendedJButton);
            this.add(jLabel2);
            this.add(jLabel);
        }
    }

    public void refresh() {
        this.removeAll();
        this.createPopupMenu();
        this.createPanelContent();
    }

    public Genome getSelectedGenome(ActionEvent actionEvent) {
        JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
        ExtendedJPopupMenu extendedJPopupMenu = (ExtendedJPopupMenu)jMenuItem.getParent();
        return (Genome)extendedJPopupMenu.getObject();
    }

    public void saveGenomeEvent(ActionEvent actionEvent) {
        GeneticFileManager.saveGenome(this, this.getSelectedGenome(actionEvent));
    }

    public void replaceGenomeEvent(ActionEvent actionEvent) {
        Genome genome = GeneticFileManager.loadGenome(this);
        if (genome != null) {
            int n = this.myPool.indexOf(this.getSelectedGenome(actionEvent));
            this.myPool.remove(this.getSelectedGenome(actionEvent));
            this.myPool.add(n, genome);
            this.refresh();
        }
    }

    public void resetGenomeEvent(ActionEvent actionEvent) {
        this.getSelectedGenome(actionEvent).reset();
    }

    public void noteGenomeEvent(ActionEvent actionEvent) {
        String string = JOptionPane.showInputDialog("Please input a new fitness value");
        this.getSelectedGenome(actionEvent).setHadocFitness(new Double(string));
    }

    public void setFitnessEvent(ActionEvent actionEvent) {
        String string = JOptionPane.showInputDialog("Please input a new fitness value");
        this.getSelectedGenome(actionEvent).setFitness(new Double(string));
    }

    public void setStateEvent(ActionEvent actionEvent) {
        String string = JOptionPane.showInputDialog("Please input a new state value");
        this.getSelectedGenome(actionEvent).setState(new Integer(string));
    }

    public void removeGenomeEvent(ActionEvent actionEvent) {
        this.myPool.remove(this.getSelectedGenome(actionEvent));
        this.refresh();
    }

    public void addGeneEvent(ActionEvent actionEvent) {
        Gene gene = GeneticFileManager.loadGene(this);
        if (gene != null) {
            Genome genome = this.getSelectedGenome(actionEvent);
            genome.add(gene);
            System.out.println("This genome should be now incompatible with others genomes");
        }
    }

    public void displayGenome(Genome genome) {
        this.displayGenome(genome, 0);
    }

    public void displayGenome(Genome genome, int n) {
        JFrame jFrame = new JFrame("Genome " + n + " from " + genome.getPoolName());
        jFrame.setSize(350, 200);
        JPanel jPanel = genome.getPanel();
        jFrame.getContentPane().add((Component)jPanel, "Center");
        jFrame.setVisible(true);
    }
}

