/*
 * Decompiled with CFR 0.152.
 */
package turtlekit2.genetic;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.Random;
import javax.swing.JPanel;
import turtlekit2.genetic.EvolutionManager;
import turtlekit2.genetic.Gene;
import turtlekit2.genetic.GeneticFileManager;
import turtlekit2.genetic.Genome;
import turtlekit2.genetic.PoolGUI;
import turtlekit2.kernel.XMLAttributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pool
extends ArrayList<Genome>
implements Serializable {
    static final int WAITING = -1;
    static final int ACTIVATED = 0;
    Random randomizer = new Random();
    int generation = 0;
    String poolName;
    String poolPath;
    static EvolutionManager myManager = new EvolutionManager();
    transient PoolGUI myGui = null;

    public Pool(String string, String string2) {
        this.poolPath = string;
        this.poolName = string2;
    }

    public Pool() {
    }

    public void createPool(Hashtable hashtable, int n) {
        try {
            System.out.println("Create " + hashtable);
            if (n % 2 != 0 && n != 1) {
                ++n;
            }
            for (int i = 0; i < n; ++i) {
                Genome genome = new Genome();
                genome.setPoolName(this.poolName);
                for (Map.Entry entry : hashtable.entrySet()) {
                    genome.add((XMLAttributes)entry.getValue());
                }
                genome.init();
                this.add(i, genome);
            }
            GeneticFileManager.savePool(this.poolPath + this.poolName, this);
        }
        catch (Exception exception) {
            System.err.println("Instanciation problem!\n" + this.poolName + " \n" + exception);
        }
    }

    public Genome pop() {
        boolean bl = true;
        if (this.size() != 1) {
            for (int i = 0; i < this.size(); ++i) {
                if (((Genome)this.get(i)).getState() != -1) continue;
                bl = false;
                ((Genome)this.get(i)).setState(0);
                return (Genome)this.get(i);
            }
            if (bl) {
                this.newGeneration();
            }
        } else {
            return (Genome)this.get(0);
        }
        return this.pop();
    }

    public void resetState() {
        for (int i = 0; i < this.size(); ++i) {
            ((Genome)this.get(i)).setState(-1);
        }
    }

    public void addGeneToPool(Gene gene) {
        for (int i = 0; i < this.size(); ++i) {
            ((Genome)this.get(i)).add(gene);
        }
    }

    public void newGeneration() {
        myManager.reproduce(this);
        ++this.generation;
        System.out.println("##### Generation: " + new Integer(this.generation).toString() + " " + this.poolName + " ##### ");
        this.refreshGui();
    }

    public void crossGenes1() {
        this.fitSortDesc();
        System.out.println(" ******* BEST GENOME ****** " + ((Genome)this.get(0)).toString());
        for (int i = 0; i < this.size() / 2; ++i) {
            Genome genome = (Genome)this.get(i);
            int n = this.randomizer.nextInt(this.size() / 2);
            Genome genome2 = (Genome)this.get(n);
            Genome genome3 = (Genome)this.get(i + this.size() / 2);
            for (int j = 0; j < genome.size(); ++j) {
                Gene gene = (Gene)genome.get(j);
                Gene gene2 = (Gene)genome2.get(j);
                if (gene.isFixed()) {
                    genome3.set(j, (Gene)gene.clone());
                    ((Gene)genome3.get(j)).setFixed(true);
                    continue;
                }
                ((Gene)genome3.get(j)).cross(gene, gene2);
            }
        }
    }

    public void crossGenes2() {
        this.fitSortDesc();
        System.out.println(" ******* BEST GENOME ****** " + ((Genome)this.get(0)).toString());
        for (int i = 0; i < this.size() / 2; ++i) {
            Genome genome = (Genome)this.get(i);
            int n = this.randomizer.nextInt(this.size() / 2);
            Genome genome2 = (Genome)this.get(n);
            Genome genome3 = (Genome)this.get(i + this.size() / 2);
            for (int j = 0; j < genome.size(); ++j) {
                Gene gene = (Gene)genome.get(j);
                Gene gene2 = (Gene)genome2.get(j);
                if (gene.isFixed()) {
                    genome3.set(j, (Gene)gene.clone());
                    ((Gene)genome3.get(j)).setFixed(true);
                    continue;
                }
                ((Gene)genome3.get(j)).cross(gene, gene2);
            }
        }
    }

    public void mutateGenes() {
        for (int i = 0; i < this.size(); ++i) {
            Genome genome = (Genome)this.get(i);
            for (int j = 0; j < genome.size(); ++j) {
                if (((Gene)genome.get(j)).isFixed()) continue;
                ((Gene)genome.get(j)).mutate();
            }
        }
    }

    @Override
    public boolean add(Genome genome) {
        boolean bl = super.add(genome);
        this.refreshGui();
        return bl;
    }

    public void refreshGui() {
        if (this.myGui != null) {
            this.myGui.refresh();
        }
    }

    public void fitSortAsc() {
        for (int i = this.size() - 1; i >= 0; --i) {
            int n = i;
            for (int j = i - 1; j >= 0; --j) {
                if (!(((Genome)this.get(j)).getFitness() > ((Genome)this.get(n)).getFitness())) continue;
                n = j;
            }
            Genome genome = (Genome)this.get(n);
            this.set(n, this.get(i));
            this.set(i, genome);
        }
    }

    public void fitSortDesc() {
        for (int i = this.size() - 1; i >= 0; --i) {
            int n = i;
            for (int j = i - 1; j >= 0; --j) {
                if (!(((Genome)this.get(j)).getFitness() < ((Genome)this.get(n)).getFitness())) continue;
                n = j;
            }
            Genome genome = (Genome)this.get(n);
            this.set(n, this.get(i));
            this.set(i, genome);
        }
    }

    @Override
    public String toString() {
        String string = "";
        for (int i = 0; i < this.size(); ++i) {
            string = string + "\nGenome " + new Integer(i).toString() + " ";
            string = string + ((Genome)this.get(i)).toString();
        }
        return string;
    }

    public void setNewSize(int n) {
        if (this.size() > n) {
            int n2 = this.size() - n;
            this.fitSortAsc();
            for (int i = 0; i < n2; ++i) {
                this.remove(0);
            }
        } else {
            int n3 = n - this.size();
            for (int i = 0; i < n3; ++i) {
                this.createNewGenome();
            }
        }
        this.refreshGui();
    }

    public void createNewGenome() {
        if (this.size() > 0) {
            Genome genome = (Genome)((Genome)this.get(0)).clone();
            genome.reset();
            this.add(genome);
            this.refreshGui();
        }
    }

    public void reset() {
        for (Genome genome : this) {
            genome.reset();
        }
        this.refreshGui();
    }

    @Override
    public void clear() {
        super.clear();
        this.refreshGui();
    }

    public Genome getGenome(int n) {
        return (Genome)this.get(n);
    }

    public int getGeneration() {
        return this.generation;
    }

    public String getPoolName() {
        return this.poolName;
    }

    public int getSize() {
        return this.size();
    }

    public void setPoolName(String string) {
        this.poolName = string;
    }

    public JPanel getPanel() {
        if (this.myGui == null) {
            this.myGui = new PoolGUI(this);
        }
        return this.myGui;
    }
}

