/*
 * Decompiled with CFR 0.152.
 */
package turtlekit2.genetic;

import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import turtlekit2.genetic.Gene;
import turtlekit2.genetic.GeneticFileManager;
import turtlekit2.genetic.Genome;
import turtlekit2.genetic.MetaManager;
import turtlekit2.genetic.Pool;

public class MetaManagerGUI
extends JFrame {
    MetaManager myMetamanager;
    Hashtable poolTable;
    JMenuBar menuBar;
    JTabbedPane poolTabPanel;

    public MetaManagerGUI(String string, Hashtable hashtable, MetaManager metaManager) throws HeadlessException {
        super(string);
        this.myMetamanager = metaManager;
        this.poolTable = hashtable;
        this.setSize(550, 500);
        this.createMenu();
        this.createFrameContent();
    }

    public void refresh() {
        this.remove(this.poolTabPanel);
        this.createFrameContent();
    }

    public void createMenu() {
        JMenu jMenu = new JMenu("Pool");
        JMenuItem jMenuItem = new JMenuItem("Save pool");
        JMenuItem jMenuItem2 = new JMenuItem("Load pool");
        JMenuItem jMenuItem3 = new JMenuItem("Empty pool");
        JMenuItem jMenuItem4 = new JMenuItem("Reset pool");
        JMenuItem jMenuItem5 = new JMenuItem("Replace pool");
        JMenuItem jMenuItem6 = new JMenuItem("Close pool");
        JMenuItem jMenuItem7 = new JMenuItem("Refresh");
        JMenuItem jMenuItem8 = new JMenuItem("Set new pool size");
        jMenu.add(jMenuItem);
        jMenu.add(jMenuItem2);
        jMenu.add(jMenuItem3);
        jMenu.add(jMenuItem4);
        jMenu.add(jMenuItem5);
        jMenu.add(jMenuItem6);
        jMenu.add(jMenuItem7);
        jMenu.add(jMenuItem8);
        JMenu jMenu2 = new JMenu("Genome / Gene");
        JMenuItem jMenuItem9 = new JMenuItem("Load genome as pool");
        JMenuItem jMenuItem10 = new JMenuItem("Replace pool by Genome");
        JMenuItem jMenuItem11 = new JMenuItem("Add new loaded genome to pool");
        JMenuItem jMenuItem12 = new JMenuItem("Create new genome into pool");
        JMenuItem jMenuItem13 = new JMenuItem("Add gene to pool");
        jMenu2.add(jMenuItem9);
        jMenu2.add(jMenuItem10);
        jMenu2.add(jMenuItem11);
        jMenu2.add(jMenuItem12);
        jMenu2.add(jMenuItem13);
        this.menuBar = new JMenuBar();
        this.menuBar.add(jMenu);
        this.menuBar.add(jMenu2);
        this.setJMenuBar(this.menuBar);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MetaManagerGUI.this.savePoolEvent(actionEvent);
            }
        });
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MetaManagerGUI.this.loadPoolEvent(actionEvent);
            }
        });
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MetaManagerGUI.this.emptyPoolEvent(actionEvent);
            }
        });
        jMenuItem4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MetaManagerGUI.this.resetPoolEvent(actionEvent);
            }
        });
        jMenuItem5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MetaManagerGUI.this.replacePoolEvent(actionEvent);
            }
        });
        jMenuItem6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MetaManagerGUI.this.closePoolEvent(actionEvent);
            }
        });
        jMenuItem7.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MetaManagerGUI.this.refresh();
            }
        });
        jMenuItem8.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MetaManagerGUI.this.setSizeEvent(actionEvent);
            }
        });
        jMenuItem9.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MetaManagerGUI.this.loadGenomeEvent(actionEvent);
            }
        });
        jMenuItem10.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MetaManagerGUI.this.replaceGenomeEvent(actionEvent);
            }
        });
        jMenuItem11.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MetaManagerGUI.this.addGenomeEvent(actionEvent);
            }
        });
        jMenuItem12.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MetaManagerGUI.this.addNewGenomeEvent(actionEvent);
            }
        });
        jMenuItem13.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MetaManagerGUI.this.addGeneEvent(actionEvent);
            }
        });
    }

    public void createFrameContent() {
        this.poolTabPanel = new JTabbedPane();
        for (Map.Entry entry : this.poolTable.entrySet()) {
            Pool pool = (Pool)entry.getValue();
            this.poolTabPanel.add((String)entry.getKey(), pool.getPanel());
            this.getContentPane().add((Component)this.poolTabPanel, "Center");
        }
    }

    public Pool selectedPool() {
        return (Pool)this.poolTable.get(this.poolTabPanel.getTitleAt(this.poolTabPanel.getSelectedIndex()));
    }

    public void savePoolEvent(ActionEvent actionEvent) {
        GeneticFileManager.savePool(this, this.selectedPool());
    }

    public void loadPoolEvent(ActionEvent actionEvent) {
        Pool pool = GeneticFileManager.loadPool(this);
        if (pool != null) {
            JPanel jPanel = pool.getPanel();
            String string = pool.getPoolName();
            while (this.poolTable.containsKey(string)) {
                string = string + "*";
                pool.setPoolName(string);
            }
            this.poolTable.put(string, pool);
            this.poolTabPanel.setSelectedComponent(this.poolTabPanel.add(string, jPanel));
        }
    }

    public void emptyPoolEvent(ActionEvent actionEvent) {
        this.selectedPool().clear();
    }

    public void resetPoolEvent(ActionEvent actionEvent) {
        this.selectedPool().reset();
    }

    public void replacePoolEvent(ActionEvent actionEvent) {
        Pool pool = GeneticFileManager.loadPool(this);
        if (pool != null) {
            String string = this.poolTabPanel.getTitleAt(this.poolTabPanel.getSelectedIndex());
            this.poolTabPanel.remove(this.poolTabPanel.getSelectedComponent());
            JPanel jPanel = pool.getPanel();
            pool.setPoolName(string);
            pool.resetState();
            this.poolTabPanel.setSelectedComponent(this.poolTabPanel.add(string, jPanel));
            this.poolTable.put(string, pool);
            this.myMetamanager.askNewPopulation(2.0);
        }
    }

    public void closePoolEvent(ActionEvent actionEvent) {
        String string = this.poolTabPanel.getTitleAt(this.poolTabPanel.getSelectedIndex());
        this.poolTabPanel.remove(this.poolTabPanel.getSelectedComponent());
        this.poolTable.remove(string);
    }

    public void setSizeEvent(ActionEvent actionEvent) {
        String string = JOptionPane.showInputDialog("Please input the new pool size");
        this.selectedPool().setNewSize(new Integer(string));
    }

    public void loadGenomeEvent(ActionEvent actionEvent) {
        Genome genome = GeneticFileManager.loadGenome(this);
        if (genome != null) {
            Pool pool = new Pool();
            pool.add(genome);
            pool.setPoolName(genome.getPoolName());
            JPanel jPanel = pool.getPanel();
            String string = pool.getPoolName();
            while (this.poolTable.containsKey(string)) {
                string = string + "*";
                pool.setPoolName(string);
            }
            this.poolTable.put(string, pool);
            this.poolTabPanel.setSelectedComponent(this.poolTabPanel.add(string, jPanel));
        }
    }

    public void replaceGenomeEvent(ActionEvent actionEvent) {
        Genome genome = GeneticFileManager.loadGenome(this);
        if (genome != null) {
            Pool pool = new Pool();
            pool.add(genome);
            String string = this.poolTabPanel.getTitleAt(this.poolTabPanel.getSelectedIndex());
            this.poolTabPanel.remove(this.poolTabPanel.getSelectedComponent());
            JPanel jPanel = pool.getPanel();
            pool.setPoolName(string);
            genome.setPoolName(string);
            this.poolTabPanel.setSelectedComponent(this.poolTabPanel.add(string, jPanel));
            this.poolTable.put(string, pool);
        }
    }

    public void addGenomeEvent(ActionEvent actionEvent) {
        Genome genome = GeneticFileManager.loadGenome(this);
        if (genome != null) {
            this.selectedPool().add(genome);
        }
    }

    public void addNewGenomeEvent(ActionEvent actionEvent) {
        if (this.selectedPool().size() > 0) {
            this.selectedPool().createNewGenome();
        }
    }

    public void addGeneEvent(ActionEvent actionEvent) {
        Gene gene = GeneticFileManager.loadGene(this);
        if (gene != null) {
            this.selectedPool().addGeneToPool(gene);
        }
    }
}

