/*
 * Decompiled with CFR 0.152.
 */
package madkit.distributedbees;

import java.awt.Color;
import java.awt.Graphics;
import java.util.Vector;
import madkit.distributedbees.Bee;
import madkit.distributedbees.BeeProbe;
import madkit.distributedbees.BwvInputListener;
import madkit.distributedbees.GridCanvas2;
import madkit.distributedbees.QueenBee;
import madkit.kernel.ReferenceableAgent;
import madkit.kernel.Watcher;

public class BeeWorldViewer
extends Watcher
implements ReferenceableAgent {
    private String monGroup = "bees";
    private Vector myColors = new Vector();
    GridCanvas2 onScreen;
    BwvInputListener listener;
    Bee[] bees;
    QueenBee[] queenBees;
    BeeProbe greenBeeProbe;
    BeeProbe redBeeProbe;
    BeeProbe blueBeeProbe;
    BeeProbe greenQueenProbe;
    BeeProbe redQueenProbe;
    BeeProbe blueQueenProbe;
    int width;
    int height;
    boolean flash = false;
    public boolean show = false;

    public void setFlash(boolean bl) {
        this.flash = bl;
    }

    public boolean getFlash() {
        return this.flash;
    }

    public GridCanvas2 getCanvas() {
        return this.onScreen;
    }

    public BeeWorldViewer() {
        this(500, 500);
    }

    public BeeWorldViewer(int n, int n2) {
        System.err.println("Starting BeeWorldViewer");
        this.width = n;
        this.height = n2;
        System.err.println("BeeWorldViewer: fin constructeur");
    }

    private void paintBeesWithProbe(Graphics graphics, BeeProbe beeProbe) {
        try {
            this.bees = beeProbe.getBees();
            for (int i = 0; i < this.bees.length; ++i) {
                graphics.setColor(this.bees[i].beeColor);
                graphics.drawLine(this.bees[i].oldp.x, this.bees[i].oldp.y, this.bees[i].p.x, this.bees[i].p.y);
                graphics.setColor(Color.white);
                graphics.fillOval(this.bees[i].p.x, this.bees[i].p.y, 4, 4);
            }
        }
        catch (Exception exception) {
            System.err.println("Erreur dans paintBeesWithProbe " + exception);
        }
    }

    private void paintQueenWithProbe(Graphics graphics, BeeProbe beeProbe) {
        try {
            this.bees = beeProbe.getBees();
            for (int i = 0; i < this.bees.length; ++i) {
                graphics.setColor(this.bees[i].beeColor);
                graphics.drawLine(this.bees[i].oldp.x, this.bees[i].oldp.y, this.bees[i].p.x, this.bees[i].p.y);
                graphics.fillOval(this.bees[i].p.x - 5, this.bees[i].p.y - 5, 10, 10);
                this.paintObjectsBees(graphics, ((QueenBee)this.bees[i]).monEssaim);
            }
        }
        catch (Exception exception) {
            System.err.println("Erreur dans paintQueenWithProbe " + exception);
        }
    }

    private void paintObjectsBees(Graphics graphics, Bee[] beeArray) {
        for (int i = 0; i < beeArray.length; ++i) {
            graphics.setColor(beeArray[i].beeColor);
            graphics.drawLine(beeArray[i].oldp.x, beeArray[i].oldp.y, beeArray[i].p.x, beeArray[i].p.y);
            graphics.setColor(Color.white);
            graphics.fillOval(beeArray[i].p.x, beeArray[i].p.y, 4, 4);
        }
    }

    public void paintBees(Graphics graphics) {
        if (this.show) {
            this.paintQueenBees(graphics);
            if (this.greenBeeProbe != null) {
                this.paintBeesWithProbe(graphics, this.greenBeeProbe);
            }
            if (this.redBeeProbe != null) {
                this.paintBeesWithProbe(graphics, this.redBeeProbe);
            }
            if (this.blueBeeProbe != null) {
                this.paintBeesWithProbe(graphics, this.blueBeeProbe);
            }
        }
    }

    public void paintQueenBees(Graphics graphics) {
        if (this.greenQueenProbe != null) {
            this.paintQueenWithProbe(graphics, this.greenQueenProbe);
        }
        if (this.redQueenProbe != null) {
            this.paintQueenWithProbe(graphics, this.redQueenProbe);
        }
        if (this.blueQueenProbe != null) {
            this.paintQueenWithProbe(graphics, this.blueQueenProbe);
        }
    }

    public void addColoredRole(Color color) {
        if (this.myColors.indexOf(color) == -1) {
            this.myColors.addElement(color);
            this.requestRole("buzz", this.monGroup, color.toString() + "BeeWatcher", null);
            this.addColoredProbes(color);
        }
    }

    public void removeColoredRole(Color color) {
        if (this.myColors.indexOf(color) != -1) {
            this.leaveRole("buzz", this.monGroup, color.toString() + "BeeWatcher");
            this.myColors.removeElement(color);
            this.removeColoredProbes(color);
        }
    }

    public void addColoredProbes(Color color) {
        if (color == Color.green) {
            this.greenQueenProbe = new BeeProbe("bees", color.toString() + "Queen");
            this.addProbe(this.greenQueenProbe);
            this.greenBeeProbe = new BeeProbe("bees", color.toString());
            this.addProbe(this.greenBeeProbe);
        }
        if (color == Color.red) {
            this.redQueenProbe = new BeeProbe("bees", color.toString() + "Queen");
            this.addProbe(this.redQueenProbe);
            this.redBeeProbe = new BeeProbe("bees", color.toString());
            this.addProbe(this.redBeeProbe);
        }
        if (color == Color.blue) {
            this.blueQueenProbe = new BeeProbe("bees", color.toString() + "Queen");
            this.addProbe(this.blueQueenProbe);
            this.blueBeeProbe = new BeeProbe("bees", color.toString());
            this.addProbe(this.blueBeeProbe);
        }
    }

    public void removeColoredProbes(Color color) {
        if (color == Color.green) {
            this.removeProbe(this.greenQueenProbe);
            this.greenQueenProbe = null;
            this.removeProbe(this.greenBeeProbe);
            this.greenBeeProbe = null;
        }
        if (color == Color.red) {
            this.removeProbe(this.redQueenProbe);
            this.redQueenProbe = null;
            this.removeProbe(this.redBeeProbe);
            this.redBeeProbe = null;
        }
        if (color == Color.blue) {
            this.removeProbe(this.blueQueenProbe);
            this.blueQueenProbe = null;
            this.removeProbe(this.blueBeeProbe);
            this.blueBeeProbe = null;
        }
    }

    public void addListener() {
        System.err.println("Starting InputListener");
        this.listener = new BwvInputListener(this.onScreen, this);
        this.launchAgent(this.listener, "User's Control", true);
        this.onScreen.addListener(this.listener);
        System.err.println("BeeWorldViewer activated");
    }

    public void observe() {
        if (!this.flash) {
            this.onScreen.repaint();
        } else {
            this.onScreen.flash();
        }
    }

    public void initGUI() {
        this.onScreen = new GridCanvas2(this.width, this.height, this);
        this.setGUIObject(this.onScreen);
    }

    public void activate() {
        this.requestRole("buzz", "bees", "BeeWatcher", null);
    }

    public void end() {
        super.end();
        if (this.listener != null) {
            this.killAgent(this.listener);
        }
    }
}

