/*
 * Decompiled with CFR 0.152.
 */
package madkit.distributedbees;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import madkit.distributedbees.Bee;
import madkit.distributedbees.BeeControler;
import madkit.distributedbees.BeeEpiphyt;
import madkit.distributedbees.BeeLauncherGUI;
import madkit.distributedbees.BeeScheduler;
import madkit.distributedbees.BeeWorldViewer;
import madkit.distributedbees.QueenBee;
import madkit.distributedbees.TableMessage;
import madkit.kernel.AbstractAgent;
import madkit.kernel.Activator;
import madkit.kernel.AgentAddress;
import madkit.kernel.KernelAddress;
import madkit.kernel.KernelMessage;
import madkit.kernel.Message;
import madkit.kernel.Scheduler;
import madkit.kernel.StringMessage;
import madkit.simulation.activators.TurboMethodActivator;

public class BeeLauncher
extends Scheduler {
    public int version = 2;
    public static final int WORLD_SIZE = 500;
    public static final String BEE_COMMUNITY = "buzz";
    protected String defaultPurpose = "buzz";
    protected List theLaunchers = new ArrayList();
    protected TurboMethodActivator killRedBees;
    protected TurboMethodActivator killBlueBees;
    protected TurboMethodActivator killGreenBees;
    protected Activator redControler;
    protected Activator blueControler;
    protected Activator greenControler;
    protected Activator schedul;
    BeeLauncherGUI myGUI;
    BeeEpiphyt epiphyt;
    BeeWorldViewer watcher;
    int numberOfGreenBees = 0;
    int numberOfRedBees = 0;
    int numberOfBlueBees = 0;
    boolean launchTheGreen = false;
    boolean launchTheRed = false;
    boolean launchTheBlue = false;
    boolean killTheGreens = false;
    boolean killTheBlues = false;
    boolean killTheReds = false;
    boolean killThemAll = false;
    boolean redOn = false;
    boolean blueOn = false;
    boolean greenOn = false;
    int pause = 1000;
    String group;

    public int getNumberOfRedBees() {
        return this.numberOfRedBees;
    }

    public void setNumberOfRedBees(int n) {
        this.numberOfRedBees = n;
    }

    public boolean getLaunchTheRed() {
        return this.launchTheRed;
    }

    public void setNumberOfBlueBees(int n) {
        this.numberOfBlueBees = n;
    }

    public int getNumberOfBlueBees() {
        return this.numberOfBlueBees;
    }

    public boolean getLaunchTheBlue() {
        return this.launchTheBlue;
    }

    public int getNumberOfGreenBees() {
        return this.numberOfGreenBees;
    }

    public void setNumberOfGreenBees(int n) {
        this.numberOfGreenBees = n;
    }

    public boolean getLaunchTheGreen() {
        return this.launchTheGreen;
    }

    public void setKillThemAll(boolean bl) {
        this.killThemAll = bl;
    }

    public boolean getKillThemAll() {
        return this.killThemAll;
    }

    public void setLaunchTheRed(boolean bl) {
        this.launchTheRed = bl;
    }

    public void setLaunchTheBlue(boolean bl) {
        this.launchTheBlue = bl;
    }

    public void setLaunchTheGreen(boolean bl) {
        this.launchTheGreen = bl;
    }

    public void setPause(int n) {
        this.pause = n < 1 ? 1 : n;
    }

    public int getPause() {
        return this.pause;
    }

    protected void launchScheduler() {
        if (this.getAgentWithRole(BEE_COMMUNITY, this.getAddress().getKernel().toString(), "scheduler") == null) {
            this.println("launching local BeeScheduler...");
            this.launchAgent((AbstractAgent)new BeeScheduler(this.group), "BeeScheduler-" + this.version, false);
        }
    }

    protected void launchWatcher() {
        if (this.watcher == null) {
            this.println("launching BeeWorldViewer...");
            this.watcher = new BeeWorldViewer(580, 500);
            this.launchAgent((AbstractAgent)this.watcher, "BeeWorldViewer", true);
            this.watcher.addListener();
            System.err.println("BeeWorldViewer ok !");
        }
        this.watcher.show = true;
    }

    protected void launchEpiphyt() {
        if (this.epiphyt == null) {
            this.println("launching BeeEpiphyt...");
            this.epiphyt = new BeeEpiphyt();
            this.launchAgent((AbstractAgent)this.epiphyt, "BeeEpiphyt", false);
        }
    }

    protected void launchControler(Color color, String string) {
        if (this.getAgentWithRole(BEE_COMMUNITY, this.getAddress().getKernel().toString(), color.toString() + "Controler") == null) {
            this.launchAgent((AbstractAgent)new BeeControler(color, string, this.group), color.toString() + "Controler", false);
        }
    }

    public synchronized void launchBees(String string, Color color) {
        String string2 = "";
        int n = 0;
        if (color.equals(Color.red)) {
            string2 = "red";
            n = this.numberOfRedBees;
            this.launchTheRed = false;
        }
        if (color.equals(Color.blue)) {
            string2 = "blue";
            n = this.numberOfBlueBees;
            this.launchTheBlue = false;
        }
        if (color.equals(Color.green)) {
            string2 = "green";
            n = this.numberOfGreenBees;
            this.launchTheGreen = false;
        }
        this.println("Launching " + string2 + " Bees...");
        QueenBee queenBee = new QueenBee(580, 500, color);
        this.launchAgent(queenBee, string2 + " queen bee", false);
        queenBee.initSwarm(n);
        for (int i = 0; i < n; ++i) {
            Bee bee = new Bee(queenBee, color);
            queenBee.addBee(bee);
        }
        System.err.println("" + n + " " + string2 + " bees have been launched");
        this.sendMessage(BEE_COMMUNITY, this.getAddress().getKernel().toString(), color.toString() + "Controler", (Message)new StringMessage("purpose"));
    }

    public void killRedBees() {
        this.killColoredBees(Color.red);
    }

    public void killBlueBees() {
        this.killColoredBees(Color.blue);
    }

    public void killGreenBees() {
        this.killColoredBees(Color.green);
    }

    protected synchronized void killColoredBees(Color color) {
        ListIterator listIterator;
        String string = "";
        if (color.equals(Color.red)) {
            listIterator = this.killRedBees.getAgentsIterator();
            while (listIterator.hasNext()) {
                ((QueenBee)((Object)listIterator.next())).die();
            }
            string = "red";
            this.killTheReds = false;
        }
        if (color.equals(Color.blue)) {
            listIterator = this.killBlueBees.getAgentsIterator();
            while (listIterator.hasNext()) {
                ((QueenBee)((Object)listIterator.next())).die();
            }
            string = "blue";
            this.killTheBlues = false;
        }
        if (color.equals(Color.green)) {
            listIterator = this.killGreenBees.getAgentsIterator();
            while (listIterator.hasNext()) {
                ((QueenBee)((Object)listIterator.next())).die();
            }
            string = "green";
            this.killTheGreens = false;
        }
        this.println("kill " + string + " Bees");
    }

    public void reset() {
        try {
            if (this.epiphyt != null) {
                this.killAgent((AbstractAgent)this.epiphyt);
                this.epiphyt = null;
            }
        }
        catch (Exception exception) {
            System.err.println("Erreur de reset()...killAgent(epiphyt) " + exception);
        }
        if (this.getAgentsWithRole(BEE_COMMUNITY, this.getAddress().getKernel().toString(), "launcher").length == 1) {
            System.err.println("killing local agents !!");
            try {
                ((BeeScheduler)this.schedul.getAgentNb(0)).die();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.killRedBees();
            this.killBlueBees();
            this.killGreenBees();
            ((BeeControler)this.redControler.getAgentNb(0)).die();
            ((BeeControler)this.blueControler.getAgentNb(0)).die();
            ((BeeControler)this.greenControler.getAgentNb(0)).die();
        }
        try {
            if (this.watcher != null) {
                this.killAgent((AbstractAgent)this.watcher);
                this.watcher = null;
            }
        }
        catch (Exception exception) {
            System.err.println("Erreur de reset()...killAgent(watcher) " + exception);
        }
        System.gc();
        this.println("Reset done: no more agent");
    }

    public void updateTheLaunchers() {
        this.println("Send Message to all Launchers of 'simulation' group");
        AgentAddress[] agentAddressArray = this.getAgentsWithRole(BEE_COMMUNITY, "simulation", "launcher");
        this.println("nb de Launchers... = " + agentAddressArray.length);
        if (agentAddressArray.length == 0) {
            return;
        }
        if (this.killTheReds) {
            StringMessage stringMessage = new StringMessage("killTheReds");
            this.broadcastMessage(BEE_COMMUNITY, "simulation", "launcher", (Message)stringMessage);
        } else if (this.killTheGreens) {
            StringMessage stringMessage = new StringMessage("killTheGreens");
            this.broadcastMessage(BEE_COMMUNITY, "simulation", "launcher", (Message)stringMessage);
        } else if (this.killTheBlues) {
            StringMessage stringMessage = new StringMessage("killTheBlues");
            this.broadcastMessage(BEE_COMMUNITY, "simulation", "launcher", (Message)stringMessage);
        } else {
            TableMessage tableMessage = new TableMessage(this.conversion());
            this.broadcastMessage(BEE_COMMUNITY, "simulation", "launcher", tableMessage);
        }
    }

    public void handleSimpleMessage(Message message) {
        AgentAddress agentAddress = message.getSender();
        this.theLaunchers.add(agentAddress);
        TableMessage tableMessage = new TableMessage(this.conversion(), this.theLaunchers);
        this.sendMessage(agentAddress, tableMessage);
        this.pause(300);
        this.epiphyt.observe();
    }

    public void handleStringMessage(StringMessage stringMessage) {
        if (stringMessage.getString().equals("killTheReds")) {
            this.killRedBees();
        }
        if (stringMessage.getString().equals("killTheGreens")) {
            this.killGreenBees();
        }
        if (stringMessage.getString().equals("killTheBlues")) {
            this.killBlueBees();
        }
        if (stringMessage.getString().equals("killThemAll")) {
            this.theLaunchers.remove(stringMessage.getSender());
            this.masterBalancing();
        }
    }

    public void handleTableMessage(TableMessage tableMessage) {
        if (!tableMessage.getSender().isLocal()) {
            Vector[] vectorArray = tableMessage.getTable();
            Vector[] vectorArray2 = this.conversion();
            for (int i = 0; i < 3; ++i) {
                Vector vector = vectorArray2[i];
                Vector vector2 = vectorArray[i];
                if (vector2.size() <= vector.size()) continue;
                for (int j = vector.size(); j < vector2.size(); ++j) {
                    if (i == 0) {
                        ((BeeControler)this.greenControler.getAgentNb(0)).setPurposeName((String)vector2.get(0));
                        this.numberOfGreenBees = (Integer)vector2.elementAt(j) - 1;
                        this.launchBees((String)vector2.elementAt(0), Color.green);
                    }
                    if (i == 1) {
                        ((BeeControler)this.redControler.getAgentNb(0)).setPurposeName((String)vector2.get(0));
                        this.numberOfRedBees = (Integer)vector2.elementAt(j) - 1;
                        this.launchBees((String)vector2.elementAt(0), Color.red);
                    }
                    if (i != 2) continue;
                    ((BeeControler)this.blueControler.getAgentNb(0)).setPurposeName((String)vector2.get(0));
                    this.numberOfBlueBees = (Integer)vector2.elementAt(j) - 1;
                    this.launchBees((String)vector2.elementAt(0), Color.blue);
                }
            }
        }
        if (tableMessage.getLaunchers().size() > 0) {
            this.theLaunchers = tableMessage.getLaunchers();
        }
        System.err.println("" + this.getAddress() + " " + this.theLaunchers);
    }

    protected void handleKernelMessage(KernelMessage kernelMessage) {
        if (kernelMessage.getOperation() == 10) {
            Iterator iterator = this.theLaunchers.iterator();
            while (iterator.hasNext()) {
                AgentAddress agentAddress = (AgentAddress)iterator.next();
                if (!agentAddress.getKernel().equals((Object)((KernelAddress)kernelMessage.getArgument()))) continue;
                iterator.remove();
            }
            this.masterBalancing();
            return;
        }
    }

    public void handleMessage(Message message) {
        if (message.getSender() != this.getAddress()) {
            if (message instanceof TableMessage) {
                this.handleTableMessage((TableMessage)message);
            } else if (message instanceof StringMessage) {
                this.handleStringMessage((StringMessage)message);
            } else if (message instanceof KernelMessage) {
                this.handleKernelMessage((KernelMessage)message);
            } else {
                this.handleSimpleMessage(message);
            }
        }
    }

    public synchronized void masterBalancing() {
        System.err.println("Master Balancing check");
        System.err.println("" + this.getAddress() + " " + this.theLaunchers);
        System.err.println("agent with role master " + this.getAgentWithRole(BEE_COMMUNITY, "master", "launcher"));
        if (this.getAgentWithRole(BEE_COMMUNITY, "master", "launcher") == null && ((AgentAddress)this.theLaunchers.get(0)).equals((Object)this.getAddress())) {
            this.group = "master";
            this.createGroup(true, BEE_COMMUNITY, "master", null, null);
            this.requestRole(BEE_COMMUNITY, "master", "launcher", null);
            this.leaveGroup(BEE_COMMUNITY, "duplica");
            this.launchEpiphyt();
            this.setName("Master");
            this.myGUI.updateName();
            System.err.println("\nDuplica to Master OK.\n");
        }
        this.pause(50);
        ((BeeScheduler)this.schedul.getAgentNb((int)0)).monGroup = this.group;
        ((BeeScheduler)this.schedul.getAgentNb((int)0)).defaultPause = 0L;
    }

    public Vector[] conversion() {
        QueenBee queenBee;
        Vector[] vectorArray = new Vector[3];
        Vector<Object> vector = new Vector<Object>();
        Vector<Object> vector2 = new Vector<Object>();
        Vector<Object> vector3 = new Vector<Object>();
        vector.addElement(((BeeControler)this.greenControler.getAgentNb(0)).getPurposeName());
        vector2.addElement(((BeeControler)this.redControler.getAgentNb(0)).getPurposeName());
        vector3.addElement(((BeeControler)this.blueControler.getAgentNb(0)).getPurposeName());
        ListIterator listIterator = this.killRedBees.getAgentsIterator();
        while (listIterator.hasNext()) {
            queenBee = (QueenBee)((Object)listIterator.next());
            vector2.add(new Integer(queenBee.getSwarmSize()));
        }
        listIterator = this.killBlueBees.getAgentsIterator();
        while (listIterator.hasNext()) {
            queenBee = (QueenBee)((Object)listIterator.next());
            vector3.add(new Integer(queenBee.getSwarmSize()));
        }
        listIterator = this.killGreenBees.getAgentsIterator();
        while (listIterator.hasNext()) {
            queenBee = (QueenBee)((Object)listIterator.next());
            vector.add(new Integer(queenBee.getSwarmSize()));
        }
        vectorArray[0] = vector;
        vectorArray[1] = vector2;
        vectorArray[2] = vector3;
        return vectorArray;
    }

    public void initGUI() {
        this.myGUI = new BeeLauncherGUI(this);
        this.setGUIObject(this.myGUI);
    }

    public void activate() {
        Message message;
        this.createGroup(false, BEE_COMMUNITY, this.getAddress().getKernel().toString(), null, null);
        this.createGroup(true, BEE_COMMUNITY, "simulation", null, null);
        this.createGroup(true, BEE_COMMUNITY, "master", null, null);
        this.createGroup(false, BEE_COMMUNITY, "bees", null, null);
        this.pause(200);
        this.requestRole(BEE_COMMUNITY, this.getAddress().getKernel().toString(), "launcher", null);
        this.launchControler(Color.red, this.defaultPurpose);
        this.launchControler(Color.blue, this.defaultPurpose);
        this.launchControler(Color.green, this.defaultPurpose);
        this.killRedBees = new TurboMethodActivator("die", BEE_COMMUNITY, "bees", Color.red.toString() + "Queen");
        this.killBlueBees = new TurboMethodActivator("die", BEE_COMMUNITY, "bees", Color.blue.toString() + "Queen");
        this.killGreenBees = new TurboMethodActivator("die", BEE_COMMUNITY, "bees", Color.green.toString() + "Queen");
        this.redControler = new Activator(BEE_COMMUNITY, this.getAddress().getKernel().toString(), Color.red.toString() + "Controler");
        this.blueControler = new Activator(BEE_COMMUNITY, this.getAddress().getKernel().toString(), Color.blue.toString() + "Controler");
        this.greenControler = new Activator(BEE_COMMUNITY, this.getAddress().getKernel().toString(), Color.green.toString() + "Controler");
        this.schedul = new Activator(BEE_COMMUNITY, this.getAddress().getKernel().toString(), "scheduler");
        this.addActivator((Activator)this.killRedBees);
        this.addActivator((Activator)this.killBlueBees);
        this.addActivator((Activator)this.killGreenBees);
        this.addActivator(this.blueControler);
        this.addActivator(this.redControler);
        this.addActivator(this.greenControler);
        this.addActivator(this.schedul);
        if (this.getAgentWithRole(BEE_COMMUNITY, "master", "launcher") == null) {
            this.group = "master";
            this.requestRole(BEE_COMMUNITY, "master", "launcher", null);
            this.pause(50);
            this.launchEpiphyt();
            this.theLaunchers.add(this.getAddress());
        } else {
            this.group = "duplica";
            this.println("Send message to masterLauncher");
            this.sendMessage(BEE_COMMUNITY, "master", "launcher", new Message());
            this.println("Waiting for MasterLauncher answer ...");
            this.pause(50);
            message = this.waitNextMessage(5000L);
            if (message == null) {
                System.err.println("" + this.getAddress() + " Master is Gone :((((((((");
                this.pause(500);
                this.killAgent((AbstractAgent)this);
                this.exitImmediatlyOnKill();
            }
            this.handleMessage(message);
            this.println("Receive MasterLauncher message !");
        }
        this.launchScheduler();
        this.setName(this.group);
        this.launchWatcher();
        this.myGUI.updateName();
        this.requestRole(BEE_COMMUNITY, "simulation", "launcher", null);
        message = this.getAgentWithRole("system", "kernel");
        this.sendMessage(this.getAgentWithRole("system", "kernel"), (Message)new KernelMessage(22, 10));
    }

    public void checkExistingSimulation() {
        if (this.group.equals("master") && this.getAgentsWithRole(BEE_COMMUNITY, "master", "launcher").length > 1) {
            System.err.println("\ntesting");
            AgentAddress[] agentAddressArray = this.getAgentsWithRole(BEE_COMMUNITY, "master", "launcher");
            for (int i = 0; i < agentAddressArray.length; ++i) {
                if (this.getAddress().equals((Object)agentAddressArray[i]) || this.getAddress().toString().compareTo(agentAddressArray[i].toString()) <= 0) continue;
                try {
                    if (this.epiphyt != null) {
                        this.killAgent((AbstractAgent)this.epiphyt);
                        this.epiphyt = null;
                    }
                }
                catch (Exception exception) {
                    System.err.println("while duplica balancing (entering an existing simulation) " + exception);
                }
                this.leaveGroup(BEE_COMMUNITY, "master");
                System.err.println("\nerreur sur leaveGroup");
                System.err.println("agent with role master" + this.getAgentWithRole(BEE_COMMUNITY, "master", "launcher"));
                this.group = "duplica";
                this.println("Send message to masterLauncher");
                this.sendMessage(BEE_COMMUNITY, "master", "launcher", new Message());
                this.println("Waiting for MasterLauncher answer ...");
                this.pause(50);
                Message message = this.waitNextMessage(5000L);
                if (message == null) {
                    System.err.println("" + this.getAddress() + " Master is Gone :((((((((");
                    this.pause(500);
                    this.killAgent((AbstractAgent)this);
                    this.exitImmediatlyOnKill();
                }
                this.handleMessage(message);
                this.println("Receive MasterLauncher message !");
                this.setName("Duplica");
                this.myGUI.updateName();
                System.err.println("\nMaster to Duplica OK.\n");
                this.pause(50);
                ((BeeScheduler)this.schedul.getAgentNb((int)0)).monGroup = this.group;
                ((BeeScheduler)this.schedul.getAgentNb((int)0)).defaultPause = 0L;
                System.err.println("\n" + this.theLaunchers);
            }
        }
    }

    public void live() {
        while (true) {
            Message message;
            this.exitImmediatlyOnKill();
            this.pause(50);
            this.exitImmediatlyOnKill();
            this.checkExistingSimulation();
            if (this.launchTheGreen) {
                this.launchBees(this.defaultPurpose, Color.green);
                this.updateTheLaunchers();
            }
            if (this.launchTheRed) {
                this.launchBees(this.defaultPurpose, Color.red);
                this.updateTheLaunchers();
            }
            if (this.launchTheBlue) {
                this.launchBees(this.defaultPurpose, Color.blue);
                this.updateTheLaunchers();
            }
            if (this.killTheGreens) {
                this.updateTheLaunchers();
                this.killGreenBees();
            }
            if (this.killTheReds) {
                this.updateTheLaunchers();
                this.killRedBees();
            }
            if (this.killTheBlues) {
                this.updateTheLaunchers();
                this.killBlueBees();
            }
            if ((message = this.nextMessage()) == null) continue;
            System.err.println("You know what ? I receive a message ! " + message);
            this.handleMessage(message);
        }
    }

    public void end() {
        this.reset();
        this.pause(200);
        this.broadcastMessage(BEE_COMMUNITY, "simulation", "launcher", (Message)new StringMessage("killThemAll"));
        System.err.println("" + this.getAddress() + "BeeLauncher > agent ENDED");
        super.end();
    }
}

