/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.EvalError;
import bsh.InterpreterError;
import bsh.ParserConstants;
import bsh.TargetError;
import java.io.Serializable;

public class Primitive
implements ParserConstants,
Serializable {
    private Object value;
    public static final Primitive NULL = new Primitive(Special.NULL_VALUE);
    public static final Primitive VOID = new Primitive(Special.VOID_TYPE);
    static /* synthetic */ Class class$0;

    private Primitive(Object value) {
        if (value == null) {
            throw new InterpreterError("Use Primitve.NULL instead of Primitive(null)");
        }
        this.value = value;
    }

    public Primitive(Number number) {
        this((Object)number);
    }

    public Primitive(Boolean value) {
        this((Object)value);
    }

    public Primitive(Byte value) {
        this((Object)value);
    }

    public Primitive(Short value) {
        this((Object)value);
    }

    public Primitive(Character value) {
        this((Object)value);
    }

    public Primitive(Integer value) {
        this((Object)value);
    }

    public Primitive(Long value) {
        this((Object)value);
    }

    public Primitive(Float value) {
        this((Object)value);
    }

    public Primitive(Double value) {
        this((Object)value);
    }

    public Primitive(boolean value) {
        this(new Boolean(value));
    }

    public Primitive(byte value) {
        this(new Byte(value));
    }

    public Primitive(short value) {
        this(new Short(value));
    }

    public Primitive(char value) {
        this(new Character(value));
    }

    public Primitive(int value) {
        this(new Integer(value));
    }

    public Primitive(long value) {
        this(new Long(value));
    }

    public Primitive(float value) {
        this(new Float(value));
    }

    public Primitive(double value) {
        this(new Double(value));
    }

    public Object getValue() {
        if (this.value == Special.NULL_VALUE) {
            return null;
        }
        if (this.value == Special.VOID_TYPE) {
            throw new InterpreterError("attempt to unwrap void type");
        }
        return this.value;
    }

    public String toString() {
        if (this.value == Special.NULL_VALUE) {
            return "null";
        }
        if (this.value == Special.VOID_TYPE) {
            return "void";
        }
        return this.value.toString();
    }

    public Class getType() {
        return this.getType(this.value);
    }

    private Class getType(Object o) {
        if (o instanceof Boolean) {
            return Boolean.TYPE;
        }
        if (o instanceof Byte) {
            return Byte.TYPE;
        }
        if (o instanceof Short) {
            return Short.TYPE;
        }
        if (o instanceof Character) {
            return Character.TYPE;
        }
        if (o instanceof Integer) {
            return Integer.TYPE;
        }
        if (o instanceof Long) {
            return Long.TYPE;
        }
        if (o instanceof Float) {
            return Float.TYPE;
        }
        if (o instanceof Double) {
            return Double.TYPE;
        }
        return null;
    }

    public static Object binaryOperation(Object obj1, Object obj2, int kind) throws EvalError {
        Object result;
        if (obj1 == NULL || obj2 == NULL) {
            throw new EvalError("Null value or 'null' literal in binary operation");
        }
        if (obj1 == VOID || obj2 == VOID) {
            throw new EvalError("Undefined variable, class, or 'void' literal in binary operation");
        }
        Class<?> lhsOrgType = obj1.getClass();
        Class<?> rhsOrgType = obj2.getClass();
        if (obj1 instanceof Primitive) {
            obj1 = ((Primitive)obj1).getValue();
        }
        if (obj2 instanceof Primitive) {
            obj2 = ((Primitive)obj2).getValue();
        }
        Object[] operands = Primitive.promotePrimitives(obj1, obj2);
        Object lhs = operands[0];
        Object rhs = operands[1];
        if (lhs.getClass() != rhs.getClass()) {
            throw new EvalError("type mismatch in operator.  " + lhs.getClass() + " cannot be used with " + rhs.getClass());
        }
        try {
            result = Primitive.binaryOperationImpl(lhs, rhs, kind);
        }
        catch (ArithmeticException e) {
            throw new TargetError("Arithemetic Exception in binary op", e);
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Lbsh.Primitive;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (lhsOrgType == clazz) {
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("[Lbsh.Primitive;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (rhsOrgType == clazz2) {
                return new Primitive(result);
            }
        }
        return result;
    }

    static Object binaryOperationImpl(Object lhs, Object rhs, int kind) throws EvalError {
        if (lhs instanceof Boolean) {
            return Primitive.booleanBinaryOperation((Boolean)lhs, (Boolean)rhs, kind);
        }
        if (lhs instanceof Integer) {
            return Primitive.intBinaryOperation((Integer)lhs, (Integer)rhs, kind);
        }
        if (lhs instanceof Long) {
            return Primitive.longBinaryOperation((Long)lhs, (Long)rhs, kind);
        }
        if (lhs instanceof Float) {
            return Primitive.floatBinaryOperation((Float)lhs, (Float)rhs, kind);
        }
        if (lhs instanceof Double) {
            return Primitive.doubleBinaryOperation((Double)lhs, (Double)rhs, kind);
        }
        throw new EvalError("Invalid types in binary operator");
    }

    static Boolean booleanBinaryOperation(Boolean B1, Boolean B2, int kind) throws EvalError {
        boolean lhs = B1;
        boolean rhs = B2;
        switch (kind) {
            case 79: {
                return new Boolean(lhs == rhs);
            }
            case 84: {
                return new Boolean(lhs != rhs);
            }
            case 85: 
            case 86: {
                return new Boolean(lhs || rhs);
            }
            case 87: 
            case 88: {
                return new Boolean(lhs && rhs);
            }
        }
        throw new InterpreterError("unimplemented binary operator");
    }

    static Object longBinaryOperation(Long L1, Long L2, int kind) {
        long lhs = L1;
        long rhs = L2;
        switch (kind) {
            case 73: 
            case 74: {
                return new Boolean(lhs < rhs);
            }
            case 71: 
            case 72: {
                return new Boolean(lhs > rhs);
            }
            case 79: {
                return new Boolean(lhs == rhs);
            }
            case 80: 
            case 81: {
                return new Boolean(lhs <= rhs);
            }
            case 82: 
            case 83: {
                return new Boolean(lhs >= rhs);
            }
            case 84: {
                return new Boolean(lhs != rhs);
            }
            case 91: {
                return new Long(lhs + rhs);
            }
            case 92: {
                return new Long(lhs - rhs);
            }
            case 93: {
                return new Long(lhs * rhs);
            }
            case 94: {
                return new Long(lhs / rhs);
            }
            case 100: {
                return new Long(lhs % rhs);
            }
            case 101: 
            case 102: {
                return new Long(lhs << (int)rhs);
            }
            case 103: 
            case 104: {
                return new Long(lhs >> (int)rhs);
            }
            case 105: 
            case 106: {
                return new Long(lhs >>> (int)rhs);
            }
            case 95: 
            case 96: {
                return new Long(lhs & rhs);
            }
            case 97: 
            case 98: {
                return new Long(lhs | rhs);
            }
            case 99: {
                return new Long(lhs ^ rhs);
            }
        }
        throw new InterpreterError("Unimplemented binary long operator");
    }

    static Object intBinaryOperation(Integer I1, Integer I2, int kind) {
        int lhs = I1;
        int rhs = I2;
        switch (kind) {
            case 73: 
            case 74: {
                return new Boolean(lhs < rhs);
            }
            case 71: 
            case 72: {
                return new Boolean(lhs > rhs);
            }
            case 79: {
                return new Boolean(lhs == rhs);
            }
            case 80: 
            case 81: {
                return new Boolean(lhs <= rhs);
            }
            case 82: 
            case 83: {
                return new Boolean(lhs >= rhs);
            }
            case 84: {
                return new Boolean(lhs != rhs);
            }
            case 91: {
                return new Integer(lhs + rhs);
            }
            case 92: {
                return new Integer(lhs - rhs);
            }
            case 93: {
                return new Integer(lhs * rhs);
            }
            case 94: {
                return new Integer(lhs / rhs);
            }
            case 100: {
                return new Integer(lhs % rhs);
            }
            case 101: 
            case 102: {
                return new Integer(lhs << rhs);
            }
            case 103: 
            case 104: {
                return new Integer(lhs >> rhs);
            }
            case 105: 
            case 106: {
                return new Integer(lhs >>> rhs);
            }
            case 95: 
            case 96: {
                return new Integer(lhs & rhs);
            }
            case 97: 
            case 98: {
                return new Integer(lhs | rhs);
            }
            case 99: {
                return new Integer(lhs ^ rhs);
            }
        }
        throw new InterpreterError("Unimplemented binary integer operator");
    }

    static Object doubleBinaryOperation(Double D1, Double D2, int kind) throws EvalError {
        double lhs = D1;
        double rhs = D2;
        switch (kind) {
            case 73: 
            case 74: {
                return new Boolean(lhs < rhs);
            }
            case 71: 
            case 72: {
                return new Boolean(lhs > rhs);
            }
            case 79: {
                return new Boolean(lhs == rhs);
            }
            case 80: 
            case 81: {
                return new Boolean(lhs <= rhs);
            }
            case 82: 
            case 83: {
                return new Boolean(lhs >= rhs);
            }
            case 84: {
                return new Boolean(lhs != rhs);
            }
            case 91: {
                return new Double(lhs + rhs);
            }
            case 92: {
                return new Double(lhs - rhs);
            }
            case 93: {
                return new Double(lhs * rhs);
            }
            case 94: {
                return new Double(lhs / rhs);
            }
            case 100: {
                return new Double(lhs % rhs);
            }
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: {
                throw new EvalError("Can't shift doubles");
            }
        }
        throw new InterpreterError("Unimplemented binary double operator");
    }

    static Object floatBinaryOperation(Float F1, Float F2, int kind) throws EvalError {
        float lhs = F1.floatValue();
        float rhs = F2.floatValue();
        switch (kind) {
            case 73: 
            case 74: {
                return new Boolean(lhs < rhs);
            }
            case 71: 
            case 72: {
                return new Boolean(lhs > rhs);
            }
            case 79: {
                return new Boolean(lhs == rhs);
            }
            case 80: 
            case 81: {
                return new Boolean(lhs <= rhs);
            }
            case 82: 
            case 83: {
                return new Boolean(lhs >= rhs);
            }
            case 84: {
                return new Boolean(lhs != rhs);
            }
            case 91: {
                return new Float(lhs + rhs);
            }
            case 92: {
                return new Float(lhs - rhs);
            }
            case 93: {
                return new Float(lhs * rhs);
            }
            case 94: {
                return new Float(lhs / rhs);
            }
            case 100: {
                return new Float(lhs % rhs);
            }
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: {
                throw new EvalError("Can't shift floats ");
            }
        }
        throw new InterpreterError("Unimplemented binary float operator");
    }

    static Object promoteToInteger(Object primitive) {
        if (primitive instanceof Character) {
            return new Integer(((Character)primitive).charValue());
        }
        if (primitive instanceof Byte || primitive instanceof Short) {
            return new Integer(((Number)primitive).intValue());
        }
        return primitive;
    }

    static Object[] promotePrimitives(Object lhs, Object rhs) {
        lhs = Primitive.promoteToInteger(lhs);
        rhs = Primitive.promoteToInteger(rhs);
        if (lhs instanceof Number && rhs instanceof Number) {
            Number lnum = (Number)lhs;
            Number rnum = (Number)rhs;
            boolean b = lnum instanceof Double;
            if (b || rnum instanceof Double) {
                if (b) {
                    rhs = new Double(rnum.doubleValue());
                } else {
                    lhs = new Double(lnum.doubleValue());
                }
            } else {
                b = lnum instanceof Float;
                if (b || rnum instanceof Float) {
                    if (b) {
                        rhs = new Float(rnum.floatValue());
                    } else {
                        lhs = new Float(lnum.floatValue());
                    }
                } else {
                    b = lnum instanceof Long;
                    if (b || rnum instanceof Long) {
                        if (b) {
                            rhs = new Long(rnum.longValue());
                        } else {
                            lhs = new Long(lnum.longValue());
                        }
                    }
                }
            }
        }
        return new Object[]{lhs, rhs};
    }

    public static Primitive unaryOperation(Primitive val, int kind) throws EvalError {
        if (val == NULL) {
            throw new EvalError("illegal use of null object or 'null' literal");
        }
        if (val == VOID) {
            throw new EvalError("illegal use of undefined object or 'void' literal");
        }
        Class operandType = val.getType();
        Object operand = Primitive.promoteToInteger(val.getValue());
        if (operand instanceof Boolean) {
            return new Primitive(Primitive.booleanUnaryOperation((Boolean)operand, kind));
        }
        if (operand instanceof Integer) {
            int result = Primitive.intUnaryOperation((Integer)operand, kind);
            if (kind == 89 || kind == 90) {
                if (operandType == Byte.TYPE) {
                    return new Primitive((byte)result);
                }
                if (operandType == Short.TYPE) {
                    return new Primitive((short)result);
                }
                if (operandType == Character.TYPE) {
                    return new Primitive((char)result);
                }
            }
            return new Primitive(result);
        }
        if (operand instanceof Long) {
            return new Primitive(Primitive.longUnaryOperation((Long)operand, kind));
        }
        if (operand instanceof Float) {
            return new Primitive(Primitive.floatUnaryOperation((Float)operand, kind));
        }
        if (operand instanceof Double) {
            return new Primitive(Primitive.doubleUnaryOperation((Double)operand, kind));
        }
        throw new InterpreterError("An error occurred.  Please call technical support.");
    }

    static boolean booleanUnaryOperation(Boolean B, int kind) throws EvalError {
        boolean operand = B;
        switch (kind) {
            case 75: {
                return !operand;
            }
        }
        throw new EvalError("Operator inappropriate for boolean");
    }

    static int intUnaryOperation(Integer I, int kind) {
        int operand = I;
        switch (kind) {
            case 91: {
                return operand;
            }
            case 92: {
                return -operand;
            }
            case 76: {
                return ~operand;
            }
            case 89: {
                return operand + 1;
            }
            case 90: {
                return operand - 1;
            }
        }
        throw new InterpreterError("bad integer unaryOperation");
    }

    static long longUnaryOperation(Long L, int kind) {
        long operand = L;
        switch (kind) {
            case 91: {
                return operand;
            }
            case 92: {
                return -operand;
            }
            case 76: {
                return operand ^ 0xFFFFFFFFFFFFFFFFL;
            }
            case 89: {
                return operand + 1L;
            }
            case 90: {
                return operand - 1L;
            }
        }
        throw new InterpreterError("bad long unaryOperation");
    }

    static float floatUnaryOperation(Float F, int kind) {
        float operand = F.floatValue();
        switch (kind) {
            case 91: {
                return operand;
            }
            case 92: {
                return -operand;
            }
        }
        throw new InterpreterError("bad float unaryOperation");
    }

    static double doubleUnaryOperation(Double D, int kind) {
        double operand = D;
        switch (kind) {
            case 91: {
                return operand;
            }
            case 92: {
                return -operand;
            }
        }
        throw new InterpreterError("bad double unaryOperation");
    }

    public int intValue() throws EvalError {
        if (this.value instanceof Number) {
            return ((Number)this.value).intValue();
        }
        throw new EvalError("Primitive not a number");
    }

    public boolean booleanValue() throws EvalError {
        if (this.value instanceof Boolean) {
            return (Boolean)this.value;
        }
        throw new EvalError("Primitive not a boolean");
    }

    public boolean isNumber() {
        return !(this.value instanceof Boolean) && this != NULL && this != VOID;
    }

    public Number numberValue() throws EvalError {
        Object value = this.value;
        if (value instanceof Character) {
            value = new Integer(((Character)value).charValue());
        }
        if (value instanceof Number) {
            return (Number)value;
        }
        throw new EvalError("Primitive not a number");
    }

    public boolean equals(Object obj) {
        if (obj instanceof Primitive) {
            return ((Primitive)obj).value.equals(this.value);
        }
        return obj.equals(this.value);
    }

    public static Object unwrap(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj == VOID) {
            return null;
        }
        if (obj instanceof Primitive) {
            return ((Primitive)obj).getValue();
        }
        return obj;
    }

    private static class Special
    implements Serializable {
        public static final Special NULL_VALUE = new Special();
        public static final Special VOID_TYPE = new Special();

        Special() {
        }
    }
}

