/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BSHAmbiguousName;
import bsh.BSHArguments;
import bsh.BSHType;
import bsh.CallStack;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.InterpreterError;
import bsh.NameSpace;
import bsh.Primitive;
import bsh.Reflect;
import bsh.ReflectError;
import bsh.SimpleNode;
import bsh.TargetError;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;

class BSHPrimarySuffix
extends SimpleNode {
    public static final int CLASS = 0;
    public static final int INDEX = 1;
    public static final int NAME = 2;
    public static final int PROPERTY = 3;
    public int operation;
    Object index;
    public String field;

    BSHPrimarySuffix(int id) {
        super(id);
    }

    public Object doSuffix(Object obj, CallStack callstack, Interpreter interpreter) throws EvalError {
        if (this.operation == 0) {
            if (obj instanceof BSHType) {
                NameSpace namespace = callstack.top();
                return ((BSHType)obj).getType(namespace);
            }
            throw new EvalError("Attemp to invoke .class on non class.", this);
        }
        if (obj instanceof SimpleNode) {
            obj = obj instanceof BSHAmbiguousName ? ((BSHAmbiguousName)obj).toObject(callstack, interpreter) : ((SimpleNode)obj).eval(callstack, interpreter);
        }
        try {
            switch (this.operation) {
                case 1: {
                    return this.doIndex(obj, callstack, interpreter);
                }
                case 2: {
                    return this.doName(obj, callstack, interpreter);
                }
                case 3: {
                    return this.doProperty(obj, callstack, interpreter);
                }
            }
            throw new InterpreterError("LHS suffix");
        }
        catch (ReflectError e) {
            throw new EvalError("reflection error: " + e, this);
        }
        catch (InvocationTargetException e) {
            throw new TargetError("target exception", e.getTargetException(), this, true);
        }
    }

    private Object doName(Object obj, CallStack callstack, Interpreter interpreter) throws EvalError, ReflectError, InvocationTargetException {
        if (this.field.equals("length") && obj.getClass().isArray()) {
            return new Primitive(Array.getLength(obj));
        }
        if (this.jjtGetNumChildren() == 0) {
            return Reflect.getObjectField(obj, this.field);
        }
        Object[] oa = ((BSHArguments)this.jjtGetChild(0)).getArguments(callstack, interpreter);
        try {
            return Reflect.invokeObjectMethod(interpreter, obj, this.field, oa, this);
        }
        catch (EvalError ee) {
            throw new EvalError(ee.getMessage(), this);
        }
    }

    static int getIndexAux(Object obj, CallStack callstack, Interpreter interpreter, SimpleNode callerNode) throws EvalError {
        int index;
        if (!obj.getClass().isArray()) {
            throw new EvalError("Not an array", callerNode);
        }
        try {
            Object indexVal = ((SimpleNode)callerNode.jjtGetChild(0)).eval(callstack, interpreter);
            if (!(indexVal instanceof Primitive)) {
                indexVal = NameSpace.getAssignableForm(indexVal, Integer.TYPE);
            }
            index = ((Primitive)indexVal).intValue();
        }
        catch (EvalError e) {
            Interpreter.debug("doIndex: " + e);
            e.reThrow("You can only index arrays by integer types", callerNode);
            throw new Error("can't get here");
        }
        return index;
    }

    private Object doIndex(Object obj, CallStack callstack, Interpreter interpreter) throws EvalError, ReflectError {
        int index = BSHPrimarySuffix.getIndexAux(obj, callstack, interpreter, this);
        return Reflect.getIndex(obj, index);
    }

    private Object doProperty(Object obj, CallStack callstack, Interpreter interpreter) throws EvalError {
        if (obj == Primitive.VOID) {
            throw new EvalError("Attempt to access property on undefined variable or class name", this);
        }
        if (obj instanceof Primitive) {
            throw new EvalError("Attempt to access property on a primitive", this);
        }
        Object value = ((SimpleNode)this.jjtGetChild(0)).eval(callstack, interpreter);
        if (!(value instanceof String)) {
            throw new EvalError("Property expression must be a String or identifier.", this);
        }
        if (obj instanceof Hashtable) {
            Object val = ((Hashtable)obj).get((String)value);
            if (val == null) {
                val = Primitive.NULL;
            }
            return val;
        }
        try {
            return Reflect.getObjectProperty(obj, (String)value);
        }
        catch (ReflectError e) {
            Interpreter.debug(e.toString());
            throw new EvalError("No such property: " + value, this);
        }
    }
}

