/*
 * Decompiled with CFR 0.152.
 */
package turtlekit.kernel;

import madkit.kernel.Activator;
import madkit.kernel.Message;
import madkit.kernel.Scheduler;
import madkit.simulation.activators.TurboMethodActivator;
import turtlekit.kernel.TopMessage;
import turtlekit.kernel.TurtleActivator;

public class TurtleScheduler
extends Scheduler {
    private static final long serialVersionUID = 8848105590386152307L;
    String group;
    TurtleActivator turtleDoIt;
    TurboMethodActivator observersDoIt;
    TurboMethodActivator viewersDoIt;
    TurboMethodActivator displayAllWorld;
    TurboMethodActivator updateDisplay;
    TurboMethodActivator evaporation;
    TurboMethodActivator diffusion;
    private boolean updateNeeded = false;
    int iteration = 0;
    int delay = 100;

    public TurtleScheduler(String string) {
        this.group = string;
    }

    public final void activate() {
        this.requestRole("Turtlekit", this.group, "scheduler", null);
        this.sendMessage("Turtlekit", this.group, "launcher", new TopMessage());
        this.waitNextMessage();
        this.turtleDoIt = new TurtleActivator(this.group);
        this.addActivator(this.turtleDoIt);
        this.observersDoIt = new TurboMethodActivator("watch", "Turtlekit", this.group, "observer");
        this.addActivator((Activator)this.observersDoIt);
        this.observersDoIt.setDebugOff(true);
        this.viewersDoIt = new TurboMethodActivator("display", "Turtlekit", this.group, "viewer");
        this.addActivator((Activator)this.viewersDoIt);
        this.viewersDoIt.setDebugOff(true);
        this.diffusion = new TurboMethodActivator("diffusion", "Turtlekit", this.group, "world");
        this.addActivator((Activator)this.diffusion);
        this.diffusion.setDebugOff(true);
        this.evaporation = new TurboMethodActivator("evaporation", "Turtlekit", this.group, "world");
        this.addActivator((Activator)this.evaporation);
        this.evaporation.setDebugOff(true);
        this.displayAllWorld = new TurboMethodActivator("displayOn", "Turtlekit", this.group, "world");
        this.addActivator((Activator)this.displayAllWorld);
        this.displayAllWorld.setDebugOff(true);
        this.updateDisplay = new TurboMethodActivator("displayOff", "Turtlekit", this.group, "world");
        this.addActivator((Activator)this.updateDisplay);
        this.updateDisplay.setDebugOff(true);
        this.observersDoIt.execute();
    }

    public final void live() {
        while (true) {
            this.exitImmediatlyOnKill();
            if (this.delay == 0) {
                Thread.yield();
            } else {
                this.pause(this.delay);
            }
            this.checkMail();
            this.scheduleWorld();
        }
    }

    public void end() {
        super.end();
        this.println("ending");
        this.sendMessage("Turtlekit", this.group, "launcher", new TopMessage());
        this.leaveGroup("Turtlekit", this.group);
    }

    private final void checkMail() {
        Message message = this.nextMessage();
        if (message != null) {
            this.sendMessage(message.getSender(), new TopMessage());
            this.displayAllWorld.execute();
            while (true) {
                this.exitImmediatlyOnKill();
                message = this.nextMessage();
                if (message != null && message instanceof TopMessage) {
                    this.displayAllWorld.execute();
                    this.viewersDoIt.execute();
                    return;
                }
                this.pause(300);
                this.displayAllWorld.execute();
                this.viewersDoIt.execute();
            }
        }
    }

    protected final void executeTurtles() {
        this.turtleDoIt.execute();
    }

    protected final void executeDiffusion() {
        this.updateNeeded = true;
        this.diffusion.execute();
    }

    protected final void executeEvaporation() {
        this.updateNeeded = true;
        this.evaporation.execute();
    }

    protected final void executeObservers() {
        this.observersDoIt.execute();
    }

    protected final void executeDisplay() {
        if (this.updateNeeded) {
            this.displayAllWorld.execute();
            this.updateNeeded = false;
        }
        this.viewersDoIt.execute();
        this.updateDisplay.execute();
    }

    protected final void incrementeIteration() {
        ++this.iteration;
    }

    public void scheduleWorld() {
        this.executeTurtles();
        this.executeDiffusion();
        this.executeEvaporation();
        this.executeObservers();
        this.executeDisplay();
        this.incrementeIteration();
    }
}

