/*
 * Decompiled with CFR 0.152.
 */
package turtlekit.kernel;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import madkit.kernel.AbstractAgent;
import madkit.kernel.ReferenceableAgent;
import turtlekit.kernel.Patch;
import turtlekit.kernel.Turtle;

public class TurtleEnvironment
extends AbstractAgent
implements ReferenceableAgent {
    private static final long serialVersionUID = -6870421308063427839L;
    Map<String, Integer> variables = null;
    Map<String, Double> diffuseCoef = null;
    Map<String, Double> evapCoef = null;
    public final Patch[][] grid;
    final int x;
    final int y;
    int turtlesCount = -1;
    String simulationGroup;
    boolean wrap = true;
    ArrayList<Turtle> theTurtles = new ArrayList(5000);

    public TurtleEnvironment(int n, int n2, String string) {
        this.x = n;
        this.y = n2;
        this.grid = new Patch[this.x][this.y];
        this.initGrid();
        this.simulationGroup = string;
    }

    public void displayOff() {
        for (int i = this.x - 1; i >= 0; --i) {
            for (int j = this.y - 1; j >= 0; --j) {
                if (!this.grid[i][j].change) continue;
                this.grid[i][j].change = false;
            }
        }
    }

    public void displayOn() {
        for (int i = this.x - 1; i >= 0; --i) {
            for (int j = this.y - 1; j >= 0; --j) {
                this.grid[i][j].change = true;
            }
        }
    }

    final void addVariables(String[] stringArray, double[] dArray) {
        int n;
        this.variables = new HashMap<String, Integer>(stringArray.length);
        for (n = 0; n < stringArray.length; ++n) {
            this.variables.put(stringArray[n], new Integer(n));
        }
        for (n = this.x - 1; n >= 0; --n) {
            for (int i = this.y - 1; i >= 0; --i) {
                double[] dArray2 = new double[dArray.length];
                for (int j = 0; j < stringArray.length; ++j) {
                    dArray2[j] = dArray[j];
                }
                this.grid[n][i].variableValue = dArray2;
            }
        }
    }

    final void diffuseVariables(String[] stringArray, double[] dArray) {
        this.diffuseCoef = new HashMap<String, Double>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            this.diffuseCoef.put(stringArray[i], new Double(dArray[i]));
        }
    }

    final void evapVariables(String[] stringArray, double[] dArray) {
        this.evapCoef = new HashMap<String, Double>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            this.evapCoef.put(stringArray[i], new Double(dArray[i]));
        }
    }

    final void initNeighborhood() {
        if (this.wrap) {
            for (int i = this.x - 1; i >= 0; --i) {
                for (int j = this.y - 1; j >= 0; --j) {
                    Patch[] patchArray = new Patch[8];
                    patchArray[0] = this.grid[(i + 1) % this.x][j];
                    patchArray[7] = this.grid[(i + 1) % this.x][(j - 1 + this.y) % this.y];
                    patchArray[6] = this.grid[i][(j - 1 + this.y) % this.y];
                    patchArray[5] = this.grid[(i - 1 + this.x) % this.x][(j - 1 + this.y) % this.y];
                    patchArray[4] = this.grid[(i - 1 + this.x) % this.x][j];
                    patchArray[3] = this.grid[(i - 1 + this.x) % this.x][(j + 1) % this.y];
                    patchArray[2] = this.grid[i][(j + 1) % this.y];
                    patchArray[1] = this.grid[(i + 1) % this.x][(j + 1) % this.y];
                    this.grid[i][j].setNeighborhood(patchArray);
                }
            }
        } else {
            for (int i = this.x - 1; i >= 0; --i) {
                for (int j = this.y - 1; j >= 0; --j) {
                    Patch[] patchArray;
                    if (i == 0) {
                        patchArray = j > 0 && j < this.y - 1 ? new Patch[]{this.grid[i + 1][j], this.grid[i + 1][j + 1], this.grid[i][j + 1], this.grid[i][j - 1], this.grid[i + 1][j - 1]} : (j == 0 ? new Patch[]{this.grid[i + 1][j], this.grid[i + 1][j + 1], this.grid[i][j + 1]} : new Patch[]{this.grid[i + 1][j], this.grid[i][j - 1], this.grid[i + 1][j - 1]});
                    } else if (i == this.x - 1) {
                        patchArray = j > 0 && j < this.y - 1 ? new Patch[]{this.grid[i][j + 1], this.grid[i - 1][j + 1], this.grid[i - 1][j], this.grid[i - 1][j - 1], this.grid[i][j - 1]} : (j == 0 ? new Patch[]{this.grid[i][j + 1], this.grid[i - 1][j + 1], this.grid[i - 1][j]} : new Patch[]{this.grid[i - 1][j], this.grid[i - 1][j - 1], this.grid[i][j - 1]});
                    } else if (j == 0) {
                        patchArray = new Patch[]{this.grid[i + 1][j], this.grid[i + 1][j + 1], this.grid[i][j + 1], this.grid[i - 1][j + 1], this.grid[i - 1][j]};
                    } else if (j == this.y - 1) {
                        patchArray = new Patch[]{this.grid[i + 1][j], this.grid[i - 1][j], this.grid[i - 1][j - 1], this.grid[i][j - 1], this.grid[i + 1][j - 1]};
                    } else {
                        patchArray = new Patch[8];
                        patchArray[0] = this.grid[i + 1][j];
                        patchArray[7] = this.grid[i + 1][j - 1];
                        patchArray[6] = this.grid[i][j - 1];
                        patchArray[5] = this.grid[i - 1][j - 1];
                        patchArray[4] = this.grid[i - 1][j];
                        patchArray[3] = this.grid[i - 1][j + 1];
                        patchArray[2] = this.grid[i][j + 1];
                        patchArray[1] = this.grid[i + 1][j + 1];
                    }
                    this.grid[i][j].setNeighborhood(patchArray);
                }
            }
        }
    }

    final void initGrid() {
        for (int i = this.x - 1; i >= 0; --i) {
            for (int j = this.y - 1; j >= 0; --j) {
                this.grid[i][j] = new Patch(this);
            }
        }
    }

    public final void diffusion() {
        if (this.diffuseCoef != null) {
            for (Map.Entry<String, Double> entry : this.diffuseCoef.entrySet()) {
                int n;
                int n2;
                double d = entry.getValue();
                int n3 = this.variables.get(entry.getKey());
                if (this.wrap) {
                    double d2 = d / 8.0;
                    for (int i = this.x - 1; i >= 0; --i) {
                        for (int j = this.y - 1; j >= 0; --j) {
                            this.grid[i][j].diffusion = this.grid[i][j].variableValue[n3] * d2;
                            int n4 = n3;
                            this.grid[i][j].variableValue[n4] = this.grid[i][j].variableValue[n4] - this.grid[i][j].variableValue[n3] * d;
                        }
                    }
                } else {
                    for (n2 = this.x - 1; n2 >= 0; --n2) {
                        for (n = this.y - 1; n >= 0; --n) {
                            this.grid[n2][n].diffusion = this.grid[n2][n].variableValue[n3] * (d / (double)this.grid[n2][n].neighbors.length);
                            int n5 = n3;
                            this.grid[n2][n].variableValue[n5] = this.grid[n2][n].variableValue[n5] - this.grid[n2][n].variableValue[n3] * d;
                        }
                    }
                }
                for (n2 = this.x - 1; n2 >= 0; --n2) {
                    for (n = this.y - 1; n >= 0; --n) {
                        this.grid[n2][n].update(n3);
                    }
                }
            }
        }
    }

    public final void evaporation() {
        if (this.evapCoef != null) {
            for (Map.Entry<String, Double> entry : this.evapCoef.entrySet()) {
                double d = entry.getValue();
                int n = this.variables.get(entry.getKey());
                for (int i = this.x - 1; i >= 0; --i) {
                    for (int j = this.y - 1; j >= 0; --j) {
                        int n2 = n;
                        this.grid[i][j].variableValue[n2] = this.grid[i][j].variableValue[n2] - this.grid[i][j].variableValue[n] * d;
                    }
                }
            }
        }
    }

    final synchronized void finalReset() {
        for (Turtle turtle : this.theTurtles) {
            turtle.position.removeAgent(turtle);
            this.killAgent(turtle);
            turtle = null;
        }
        this.theTurtles.clear();
        this.turtlesCount = 0;
    }

    final synchronized int createAgent(Turtle turtle, int n, int n2) {
        ++this.turtlesCount;
        turtle.initialisation(n, n2, this, this.turtlesCount, this.grid[n][n2]);
        this.grid[n][n2].addAgent(turtle);
        this.theTurtles.add(turtle);
        this.launchAgent(turtle, "turtle" + this.turtlesCount, false);
        return this.turtlesCount;
    }

    final int addAgent(Turtle turtle) {
        return this.createAgent(turtle, (int)(Math.random() * (double)this.x), (int)(Math.random() * (double)this.y));
    }

    final int addAgent(Turtle turtle, int n, int n2) {
        return this.createAgent(turtle, n % this.x, n2 % this.y);
    }

    final synchronized void removeTurtle(Turtle turtle) {
        turtle.position.removeAgent(turtle);
        this.theTurtles.remove((Object)turtle);
        if (turtle != null) {
            this.killAgent(turtle);
        }
        turtle = null;
    }

    final Turtle[] turtlesAt(int n, int n2) {
        return this.grid[n][n2].getTurtles();
    }

    final int turtlesCountAt(int n, int n2) {
        return this.grid[n][n2].size();
    }

    final Color getPatchColor(int n, int n2) {
        return this.grid[n][n2].color;
    }

    final void setPatchColor(Color color, int n, int n2) {
        this.grid[n][n2].setColor(color);
    }

    final void moveTurtle(int n, int n2, Turtle turtle) {
        Patch patch = this.grid[n][n2];
        if (patch != turtle.position) {
            turtle.position.removeAgent(turtle);
            patch.addAgent(turtle);
        }
    }

    public final void activate() {
        this.requestRole("Turtlekit", this.simulationGroup, "world", null);
    }

    public Turtle getTurtleWithID(int n) {
        for (Turtle turtle : this.theTurtles) {
            if (turtle.mySelf() != n) continue;
            return turtle;
        }
        return null;
    }
}

