/*
 * Decompiled with CFR 0.152.
 */
package turtlekit.kernel;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import madkit.kernel.AbstractAgent;
import madkit.kernel.OPanel;
import madkit.system.property.PropertyAgent;
import madkit.utils.graphics.GraphicUtils;
import turtlekit.kernel.Launcher;

class LauncherGui
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = -2032340834670806888L;
    JTextField p;
    JTextField dD;
    JTextField pause;
    JTextField displayDelay;
    JButton b1;
    JButton b2;
    JButton b3;
    JButton b4;
    JButton step;
    JButton python;
    Launcher ll;
    JPanel buttons;
    JPanel allbuttons;
    JPanel cycle;
    OPanel textDisplay;
    JButton bProp;
    PropertyAgent prop;
    ImageIcon iStart;
    ImageIcon iStep;
    ImageIcon iReset;
    ImageIcon iStop;
    ImageIcon iPythonEd;
    ImageIcon iView;
    ImageIcon iProps;

    public LauncherGui(Launcher launcher) {
        this.ll = launcher;
        this.setSize(300, 210);
        this.iStart = this.makeIcon("/toolbarButtonGraphics/media/Play24.gif");
        this.iStop = this.makeIcon("/toolbarButtonGraphics/media/Pause24.gif");
        this.iStep = this.makeIcon("/toolbarButtonGraphics/media/StepForward24.gif");
        this.iReset = this.makeIcon("/toolbarButtonGraphics/general/Refresh24.gif");
        this.iPythonEd = this.makeIcon("/images/agents/agenteditorPython32.gif");
        this.iView = this.makeIcon("/images/toolbars/watch.gif");
        this.iProps = this.makeIcon("/toolbarButtonGraphics/general/loupe.gif");
    }

    private void makebutton(JButton jButton, JPanel jPanel) {
        jPanel.add(jButton);
        jButton.addActionListener(this);
    }

    JButton createButton(JPanel jPanel, String string, String string2, ImageIcon imageIcon) {
        JButton jButton = imageIcon != null ? new JButton(imageIcon) : new JButton(string);
        jButton.setToolTipText(string2);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.setActionCommand(string);
        jButton.addActionListener(this);
        if (jPanel != null) {
            jPanel.add(jButton);
        }
        return jButton;
    }

    ImageIcon makeIcon(String string) {
        if (string != null) {
            ImageIcon imageIcon = null;
            URL uRL = this.getClass().getResource(string);
            if (uRL != null) {
                imageIcon = new ImageIcon(uRL);
            }
            if (imageIcon != null && imageIcon.getImage() != null) {
                return imageIcon;
            }
        }
        return null;
    }

    void setButtonState(JButton jButton, String string, ImageIcon imageIcon) {
        jButton.setActionCommand(string);
        if (imageIcon != null) {
            jButton.setIcon(imageIcon);
        }
    }

    void initialisation() {
        this.setLayout(new BorderLayout());
        this.b2 = this.ll.wrap ? new JButton("Wrap On") : new JButton("Wrap Off");
        this.b3 = new JButton("Add Viewer");
        this.allbuttons = new JPanel(new GridLayout(2, 3));
        this.b1 = this.createButton(this.allbuttons, "start", "Run and stop the simulation", this.iStart);
        this.step = this.createButton(this.allbuttons, "Step", "Step the simulation", this.iStep);
        this.b4 = this.createButton(this.allbuttons, "Reset", "Reset the simulation", this.iReset);
        this.makebutton(this.b2, this.allbuttons);
        this.b3 = this.createButton(this.allbuttons, "Add Viewer", "Add a viewer", this.iView);
        this.python = this.createButton(this.allbuttons, "Python", "Launch a python editor", this.iPythonEd);
        JLabel jLabel = new JLabel("Simulation speed", 0);
        jLabel.setAlignmentX(0.5f);
        JSlider jSlider = new JSlider(0, 0, 500, 490);
        jSlider.addChangeListener(new SliderListener());
        jSlider.setMajorTickSpacing(250);
        jSlider.setPaintTicks(true);
        jSlider.setPaintLabels(false);
        jSlider.setBorder(BorderFactory.createEmptyBorder(0, 0, 15, 0));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)jLabel, "West");
        jPanel.add((Component)jSlider, "Center");
        this.bProp = this.createButton(null, "Properties", "Shows the simulation parameters", this.iProps);
        jPanel.add((Component)this.bProp, "East");
        this.textDisplay = new OPanel();
        this.textDisplay.jscrollpane.setHorizontalScrollBarPolicy(31);
        this.textDisplay.jscrollpane.setVerticalScrollBarPolicy(20);
        this.ll.setOutputWriter(this.textDisplay.getOut());
        this.add("North", this.allbuttons);
        this.add("South", jPanel);
        this.add("Center", (Component)this.textDisplay);
        this.doLayout();
        this.allbuttons.doLayout();
        this.textDisplay.doLayout();
        jPanel.doLayout();
    }

    public Dimension getPreferredSize() {
        return this.getSize();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.b1) {
            if (this.b1.getActionCommand().equalsIgnoreCase("Start")) {
                this.b1.setBackground(Color.green);
                this.setButtonState(this.b1, "Stop", this.iStop);
                this.ll.start = true;
                return;
            }
            if (this.ll.run && this.ll.start) {
                this.b1.setBackground(Color.red);
                this.setButtonState(this.b1, "Run", this.iStart);
                this.ll.setStop();
                return;
            }
            if (this.ll.start) {
                this.b1.setBackground(Color.green);
                this.setButtonState(this.b1, "Stop", this.iStop);
                this.ll.setStop();
            }
        } else if (object == this.b3 && this.ll.start) {
            this.ll.addViewer();
        } else if (object == this.b4 && this.ll.start) {
            this.textDisplay.clearOutput();
            this.ll.setReset();
            this.ll.run = true;
            this.b1.setBackground(Color.green);
            this.setButtonState(this.b1, "Stop", this.iStop);
        } else if (object == this.b2) {
            if (this.b2.getText().equalsIgnoreCase("Wrap On")) {
                this.ll.setWrapModeOn(false);
                this.b2.setText("Wrap Off");
            } else {
                this.ll.setWrapModeOn(true);
                this.b2.setText("Wrap On");
            }
        } else if (object == this.step) {
            if (this.ll.start && this.ll.run) {
                this.b1.setBackground(Color.red);
                this.setButtonState(this.b1, "Run", this.iStart);
                this.ll.setStop();
                this.ll.stepByStep();
                return;
            }
            if (this.ll.start) {
                this.ll.stepByStep();
                return;
            }
        } else if (object == this.bProp) {
            if (this.prop == null) {
                this.prop = new PropertyAgent((AbstractAgent)this.ll);
                this.ll.launchAgent((AbstractAgent)this.prop, "Properties of " + this.ll.simulationName, true);
            } else {
                GraphicUtils.getFrameParent((Container)((JComponent)this.prop.getGUIObject())).setVisible(true);
            }
        } else if (object == this.python) {
            try {
                this.ll.println("launching python. Please wait...");
                this.ll.launchPython();
                if (this.ll.run) {
                    this.b1.setBackground(Color.red);
                    this.setButtonState(this.b1, "Run", this.iStart);
                    this.ll.setStop();
                    this.ll.stepByStep();
                    return;
                }
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                this.ll.println("can't launch python in applet mode");
            }
            catch (Exception exception) {
                this.ll.println("can't launch python in applet mode");
            }
        }
    }

    void removePropertyWindows() {
        if (this.prop != null) {
            this.ll.killAgent((AbstractAgent)this.prop);
        }
    }

    class SliderListener
    implements ChangeListener {
        SliderListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            JSlider jSlider = (JSlider)changeEvent.getSource();
            if (!jSlider.getValueIsAdjusting()) {
                LauncherGui.this.ll.setCyclePause(500 - jSlider.getValue());
            }
        }
    }
}

