/*
 * Decompiled with CFR 0.152.
 */
package madkit.communicator;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Socket;
import java.util.Hashtable;
import java.util.Vector;
import madkit.communicator.TransportLayer;
import madkit.kernel.Message;

public class TwoChannelsSocketExtremity
extends Thread {
    protected short messageNumber = 0;
    protected short maxDataSize = (short)1400;
    public Socket socket;
    public DataInputStream in;
    public DataOutputStream out;
    DatagramSocket dSocket;
    TransportLayer pere;
    protected Hashtable tableClient;
    int datagramSocketPort;
    String kernel = null;

    public TwoChannelsSocketExtremity(DatagramSocket datagramSocket, Socket socket, TransportLayer transportLayer, Hashtable hashtable) {
        this.pere = transportLayer;
        this.socket = socket;
        this.dSocket = datagramSocket;
        this.tableClient = hashtable;
        try {
            this.out = new DataOutputStream(socket.getOutputStream());
            this.in = new DataInputStream(new BufferedInputStream(socket.getInputStream()));
        }
        catch (IOException iOException) {
            transportLayer.println("Error when opening DataInputStream: " + iOException);
        }
        try {
            String string = transportLayer.communicatorId();
            this.out.writeInt(string.length());
            this.out.writeChars(string);
            this.out.writeInt(datagramSocket.getLocalPort());
            this.out.flush();
        }
        catch (IOException iOException) {
            transportLayer.println("Unable to write kernel address: " + iOException);
        }
        try {
            int n = 0;
            this.kernel = "";
            n = this.in.readInt();
            for (int i = 0; i < n; ++i) {
                this.kernel = this.kernel + this.in.readChar();
            }
            this.datagramSocketPort = this.in.readInt();
        }
        catch (IOException iOException) {
            transportLayer.println("Unable to read kernel address: " + iOException);
        }
        String string = this.kernel;
        if (this.kernel.equals(transportLayer.communicatorId())) {
            transportLayer.debug("Can not add my kernel.");
            this.closeSocket();
            return;
        }
        if (hashtable.containsKey(string)) {
            transportLayer.debug("Kernel " + string + " already add.");
            this.closeSocket();
            return;
        }
        transportLayer.debug("Adding Kernel " + string + " on table.");
        hashtable.put(string, this);
        this.start();
    }

    protected void closeSocket() {
        try {
            this.pere.println("Closing socket to " + this.kernel + " ...");
            this.socket.close();
            this.socket = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Object decode(byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        Object object = null;
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            try {
                object = objectInputStream.readObject();
            }
            catch (Exception exception) {
                this.pere.debug("MessageDatagramReceiver readObject:" + exception.getMessage());
            }
        }
        catch (IOException iOException) {
            this.pere.debug("Exception while converting Byte raw object into stream");
        }
        return object;
    }

    public void run() {
        try {
            while (true) {
                this.pere.debug("R:reading size");
                int n = this.in.readInt();
                this.pere.debug("R:done " + n + " preparing array");
                byte[] byArray = new byte[n];
                this.in.readFully(byArray);
                Object object = null;
                object = this.decode(byArray);
                if (object instanceof Message) {
                    Message message = (Message)object;
                    this.pere.communicatorInject(message);
                    continue;
                }
                if (!(object instanceof Vector)) continue;
                this.pere.communicatorTransmit((Vector)object);
            }
        }
        catch (IOException iOException) {
            this.pere.println("Connexion lost with " + this.kernel + ".");
            this.pere.communicatorDisconnect(this.kernel);
            this.closeSocket();
            this.pere.debug("socketExtremity closed");
            return;
        }
    }

    public byte[] encode(Object object, ByteArrayOutputStream byteArrayOutputStream) throws IOException {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(object);
        return byteArrayOutputStream.toByteArray();
    }

    public synchronized void sendWithTCP(Object object) {
        if (this.socket != null) {
            this.sendObjectWithTCP(object);
        }
    }

    private void sendObjectWithTCP(Object object) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = this.encode(object, byteArrayOutputStream);
            this.out.writeInt(byteArrayOutputStream.size());
            this.out.flush();
            this.out.write(byArray);
            this.out.flush();
        }
        catch (IOException iOException) {
            this.pere.println("Unable to send TCP message to " + this.kernel + " = " + iOException);
            this.closeSocket();
        }
    }

    public synchronized void sendWithUDP(Object object) {
        if (this.dSocket != null) {
            this.sendObjectWithUDP(object);
        }
    }

    private void sendObjectWithUDP(Object object) {
        boolean bl = false;
        boolean bl2 = true;
        int n = 0;
        int n2 = 0;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            byte[] byArray = this.encode(object, byteArrayOutputStream);
            while (!bl) {
                byteArrayOutputStream.reset();
                if (byArray.length - n > this.maxDataSize) {
                    byteArrayOutputStream.write(byArray, n, this.maxDataSize);
                    n += this.maxDataSize;
                } else {
                    byteArrayOutputStream.write(byArray, n, byArray.length - n);
                    bl = true;
                }
                dataOutputStream.writeShort(this.messageNumber);
                int n3 = 0;
                if (bl2) {
                    n3 = (byte)(n3 + 1);
                }
                if (bl | n2 == -1) {
                    n3 = (byte)(n3 + 1);
                    n3 = (byte)(n3 + 1);
                }
                dataOutputStream.writeByte(n3);
                dataOutputStream.writeByte(n2);
                DatagramPacket datagramPacket = new DatagramPacket(byteArrayOutputStream.toByteArray(), byteArrayOutputStream.size(), this.socket.getInetAddress(), this.datagramSocketPort);
                this.dSocket.send(datagramPacket);
                if (n2 == -1) {
                    bl = true;
                }
                bl2 = false;
                n2 = (byte)(n2 + 1);
            }
            this.messageNumber = (short)(this.messageNumber + 1);
        }
        catch (IOException iOException) {
            this.pere.println("Unable to send UDP message to " + this.kernel + " .");
            this.closeSocket();
        }
    }
}

