/*
 * Decompiled with CFR 0.152.
 */
package madkit.communicator;

import java.net.Socket;
import java.util.Hashtable;
import java.util.Vector;
import madkit.communicator.DynamicTwoChannelsCommunicator;
import madkit.communicator.SocketKernel;
import madkit.communicator.TwoChannelsMessageServer;
import madkit.communicator.TwoChannelsSocketExtremity;
import madkit.communicator.UDPMessage;
import madkit.kernel.KernelAddress;
import madkit.kernel.Message;

public class TransportLayer {
    TwoChannelsMessageServer server;
    DynamicTwoChannelsCommunicator agent;
    Hashtable clients;

    TransportLayer(DynamicTwoChannelsCommunicator dynamicTwoChannelsCommunicator, Hashtable hashtable) {
        this.agent = dynamicTwoChannelsCommunicator;
        this.clients = hashtable;
        try {
            this.server = new TwoChannelsMessageServer(this, this.agent.getPort(), this.clients);
        }
        catch (Exception exception) {
            this.println("Can't initialize the Message Server.");
        }
        this.setServerOn();
    }

    boolean getServerActive() {
        return this.server != null;
    }

    private synchronized void setServerOn() {
        if (!this.getServerActive()) {
            try {
                this.server = new TwoChannelsMessageServer(this, this.agent.getPort(), this.clients);
            }
            catch (Exception exception) {
                this.println("Server Error" + exception);
            }
        }
    }

    private synchronized void setServerOff() {
        if (this.getServerActive()) {
            this.server.close();
        }
        this.server = null;
    }

    synchronized void connect(SocketKernel socketKernel, Vector vector) {
        Socket socket;
        try {
            socket = new Socket(socketKernel.getHost(), socketKernel.getPort());
        }
        catch (Exception exception) {
            this.println("Client: Error on Connection: " + exception);
            return;
        }
        TwoChannelsSocketExtremity twoChannelsSocketExtremity = new TwoChannelsSocketExtremity(this.server.getDatagramSocket(), socket, this, this.clients);
        twoChannelsSocketExtremity.sendWithTCP(vector);
    }

    synchronized void replyConnect(KernelAddress kernelAddress, Vector vector) {
        this.sendTCPWithKernelAddress(vector, kernelAddress);
    }

    synchronized void disconnect(TwoChannelsSocketExtremity twoChannelsSocketExtremity) {
        twoChannelsSocketExtremity.closeSocket();
        this.clients.remove(twoChannelsSocketExtremity);
    }

    synchronized void sendto(Message message, KernelAddress kernelAddress) {
        if (this.shouldUseUDP(message)) {
            this.sendUDPWithKernelAddress(message, kernelAddress);
        } else {
            this.sendTCPWithKernelAddress(message, kernelAddress);
        }
    }

    boolean communicatorAlive() {
        return this.agent.isAlive();
    }

    int communicatorGarbage() {
        return this.agent.getGarbagePeriod();
    }

    short communicatorSize() {
        return this.agent.getMessagesSegmentsTableSize();
    }

    int communicatorTime() {
        return this.agent.getTimeoutBetweenSegments();
    }

    String communicatorId() {
        return this.agent.getId();
    }

    void setPort(int n) {
        this.agent.setPort(n);
    }

    void communicatorTransmit(Vector vector) {
        this.agent.transmitInfo(vector);
    }

    void communicatorInject(Message message) {
        this.agent.injectMessage(message);
    }

    void communicatorDisconnect(String string) {
        this.agent.disconnectFrom(string);
    }

    void println(String string) {
        this.agent.println(string);
    }

    void debug(String string) {
        this.agent.debug(string);
    }

    private synchronized void sendTCPWithKernelAddress(Object object, KernelAddress kernelAddress) {
        String string = kernelAddress.getID();
        TwoChannelsSocketExtremity twoChannelsSocketExtremity = (TwoChannelsSocketExtremity)this.clients.get(string);
        if (twoChannelsSocketExtremity != null) {
            twoChannelsSocketExtremity.sendWithTCP(object);
        }
    }

    private synchronized void sendUDPWithKernelAddress(Object object, KernelAddress kernelAddress) {
        String string = kernelAddress.getID();
        TwoChannelsSocketExtremity twoChannelsSocketExtremity = (TwoChannelsSocketExtremity)this.clients.get(string);
        if (twoChannelsSocketExtremity != null) {
            twoChannelsSocketExtremity.sendWithUDP(object);
        }
    }

    private boolean shouldUseUDP(Message message) {
        return message instanceof UDPMessage;
    }

    void close() {
        this.setServerOff();
    }
}

