/*
 * Decompiled with CFR 0.152.
 */
package madkit.chat;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import madkit.chat.Channel;
import madkit.chat.ChatAgentGUI;
import madkit.chat.ChatMessage;
import madkit.chat.Chatter;
import madkit.chat.ChatterListMsg;
import madkit.chat.PrivateAgent;
import madkit.kernel.AbstractAgent;
import madkit.kernel.Agent;
import madkit.kernel.AgentAddress;
import madkit.kernel.Message;
import madkit.kernel.StringMessage;
import madkit.messages.ActMessage;

public class ChatAgent
extends Agent {
    Hashtable nickChatter = new Hashtable();
    Hashtable nameChannel = new Hashtable();
    ChatAgentGUI display;
    String chatter;
    AgentAddress[] adminList;
    String myCurrentRole = "";
    String myCurrentChannel = "";
    boolean kicked = false;
    String[] tabChatter = null;

    public void setChatter(String string) {
        this.chatter = string;
    }

    public String getChatter() {
        return this.chatter;
    }

    public String[] getTabChatter() {
        return this.tabChatter;
    }

    public void initGUI() {
        this.display = new ChatAgentGUI(this);
        this.setGUIObject(this.display);
    }

    public void activate() {
        this.createGroup(true, "Chat", "defaultChannel", null, null);
        this.requestRole("Chat", "defaultChannel", "chatter", null);
        this.myCurrentRole = "chatter";
        this.myCurrentChannel = "defaultChannel";
    }

    public void live() {
        this.firstThingsToDo();
        while (true) {
            Message message = this.waitNextMessage();
            this.handleMessage(message);
        }
    }

    public void firstThingsToDo() {
        this.display.bNick_actionPerformed();
        if (this.doesAdminExist()) {
            for (int i = 0; i < this.adminList.length; ++i) {
                if (!this.adminList[i].equals((Object)this.getAddress())) {
                    this.sendMessage(this.adminList[i], new ChatMessage(this.chatter, "#NICKNAME " + this.chatter + " " + this.getChatterEmailInString(this.chatter) + " " + this.getChatterRole(this.chatter)));
                }
                this.sendMAJNbrUsrersOfChannel("defaultChannel");
            }
        } else {
            this.requestRole("Chat", "defaultChannel", "Admin", null);
            this.setChatterRole("Admin");
            this.upDateNickname();
            this.allowFunctions();
        }
    }

    public void end() {
        if (this.getDebug()) {
            System.out.println("\t[" + this.chatter + "] isAdmin = " + this.isAdmin("defaultChannel", this.chatter));
            System.out.println("\t[" + this.chatter + "]");
        }
        if (this.isAdmin("defaultChannel", this.chatter)) {
            int n = 0;
            AgentAddress[] agentAddressArray = this.getAgentsWithRole("Chat", "defaultChannel", "chatter");
            if (agentAddressArray.length > 1) {
                while (agentAddressArray[n] == this.getAddress()) {
                    ++n;
                }
                this.sendMessage(agentAddressArray[n], new ChatMessage(this.chatter, "#NEWADMIN"));
                this.endChannel(agentAddressArray[n]);
            }
        } else {
            AgentAddress agentAddress = this.getAgentWithRole("Chat", "defaultChannel", "Admin");
            this.endChannel(agentAddress);
            this.sendMessage(agentAddress, new ChatMessage(this.chatter, "#REMOVENICK " + this.chatter));
        }
    }

    public void endChannel(AgentAddress agentAddress) {
        if (this.nickChatter.containsKey(this.chatter)) {
            Object object;
            int n;
            Chatter chatter = (Chatter)this.nickChatter.get(this.chatter);
            Vector vector = chatter.getChannel();
            for (n = 1; n < vector.size(); ++n) {
                object = (String)vector.elementAt(n);
                int n2 = this.getChannelNbrUsers((String)object);
                if (n2 == 1) {
                    this.nameChannel.remove(object);
                    continue;
                }
                this.setChannelNbrUsers((String)object, n2 - 1);
            }
            n = this.getChannelNbrUsers("defaultChannel");
            this.setChannelNbrUsers("defaultChannel", n - 1);
            this.sendChannelHashtableObject(agentAddress);
            object = this.getChatterThanksAgentAddress(agentAddress);
        }
    }

    public boolean isAdmin(String string, String string2) {
        boolean bl = false;
        try {
            Channel channel = (Channel)this.nameChannel.get(string);
            String string3 = channel.getAdminName();
            if (string3.equals(string2)) {
                bl = true;
            }
        }
        catch (Exception exception) {
            System.out.println("[Erreur] You attempt to create a chatter with no name !!");
        }
        return bl;
    }

    public void println(String string) {
        this.display.stdout().println(string);
    }

    public void handleMessage(Message message) {
        Object object;
        ActMessage actMessage;
        String string = null;
        if (message instanceof ChatMessage) {
            string = ((ChatMessage)message).getString();
            actMessage = ((ChatMessage)message).getChatter();
            object = ((ChatMessage)message).getChannel();
            if (!this.filterChatMessage(string, message)) {
                if (object != null && this.display.isExistChatPanel((String)object)) {
                    this.display.printlnOnChannel((String)object, (String)actMessage + "> " + string);
                }
                if (object == null && actMessage == null) {
                    this.display.println(message.getSender() + "> " + string);
                }
                if (object == null && actMessage != null) {
                    this.display.println((String)actMessage + "> " + string);
                }
            }
        } else if (message instanceof StringMessage) {
            string = ((StringMessage)message).getString();
            this.display.println("<< message from " + message.getSender() + ">> \n" + string);
        }
        if (message instanceof ActMessage && !this.getChatterRole(this.chatter).equals("Admin") && (actMessage = (ActMessage)message).getObject() instanceof Hashtable) {
            if (actMessage.getAction().equals("nick")) {
                this.nickChatter = object = (Hashtable)actMessage.getObject();
                this.upDateNickname();
            }
            if (actMessage.getAction().equals("channel")) {
                this.nameChannel = object = (Hashtable)actMessage.getObject();
            }
        }
        if (message instanceof ChatterListMsg) {
            actMessage = ((ChatterListMsg)message).getList();
            for (int i = 0; i < ((ActMessage)actMessage).length; ++i) {
                this.tabChatter = actMessage;
            }
        }
    }

    public void printTabString(String[] stringArray) {
        System.out.println("printTabString ACTIVE est tabStr.length = " + stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            System.out.println("[" + i + "] :" + stringArray[i]);
        }
    }

    public void allowFunctions() {
        if (!this.getChatterEmailInString(this.getChatter()).equals("-1")) {
            if (this.getChatterRole(this.getChatter()).equals("Admin")) {
                this.display.allowEverything();
            } else {
                this.display.allowChatterRight();
            }
        }
    }

    public boolean doesAdminExist() {
        AgentAddress[] agentAddressArray = this.getAgentsWithRole("Chat", "defaultChannel", "Admin");
        if (agentAddressArray.length == 0) {
            return false;
        }
        this.adminList = agentAddressArray;
        return true;
    }

    public void sendChatMessage(String string) {
        if (!this.kicked) {
            AgentAddress[] agentAddressArray = this.getAgentsWithRole("Chat", "defaultChannel", "chatter");
            for (int i = 0; i < agentAddressArray.length; ++i) {
                if (agentAddressArray[i].equals((Object)this.getAddress())) continue;
                this.sendMessage(agentAddressArray[i], new ChatMessage(this.chatter, string));
            }
        }
    }

    public void sendChatMessage(String string, String string2) {
        if (!this.kicked) {
            AgentAddress[] agentAddressArray = this.getAgentsWithRole("Chat", "defaultChannel", "chatter");
            for (int i = 0; i < agentAddressArray.length; ++i) {
                if (agentAddressArray[i].equals((Object)this.getAddress())) continue;
                this.sendMessage(agentAddressArray[i], new ChatMessage(this.chatter, string2, string));
            }
        }
    }

    public boolean filterChatMessage(String string, Message message) {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            int n = stringTokenizer.countTokens();
            if (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (string2.equals("#NICK") && n <= 2) {
                    String string3 = stringTokenizer.nextToken();
                    this.display.addChatterName(string3);
                    return true;
                }
                if (string2.equals("#GETCHATLIST")) {
                    this.display.sendChattersNameList();
                    return true;
                }
                if (string2.equals("#CHATLIST")) {
                    while (stringTokenizer.hasMoreTokens()) {
                        String string4 = stringTokenizer.nextToken();
                        this.display.addChatterName(string4);
                    }
                    return true;
                }
                if (string2.equals("#NICKNAME")) {
                    while (stringTokenizer.hasMoreTokens()) {
                        String string5 = stringTokenizer.nextToken();
                        String string6 = stringTokenizer.nextToken();
                        String string7 = stringTokenizer.nextToken();
                        Chatter chatter = new Chatter(message.getSender(), string5, string6, string7, "NULL");
                        this.addCouple(string5, chatter);
                    }
                    this.sendToAllNoneAdmin();
                    this.upDateNickname();
                    this.allowFunctions();
                    return true;
                }
                if (string2.equals("#REMOVENICK")) {
                    String string8 = stringTokenizer.nextToken();
                    this.removeChatter(string8);
                    this.sendToAllNoneAdmin();
                    this.upDateNickname();
                    if (this.getChatterRole(this.chatter).equals("Admin")) {
                        this.sendChatMessage(string8 + " is gone :) [Admin]");
                    }
                    return true;
                }
                if (string2.equals("#NEWADMIN")) {
                    String string9 = ((ChatMessage)message).getChatter();
                    this.printNickChatter();
                    this.requestRole("Chat", "defaultChannel", "Admin", null);
                    this.setChatterRole("Admin");
                    this.setChannelRole("defaultChannel");
                    this.removeChatter(string9);
                    this.sendToAllNoneAdmin();
                    this.allowFunctions();
                    this.upDateNickname();
                    return true;
                }
                if (string2.equals("#GETTABLES")) {
                    this.sendToAllNoneAdmin();
                    this.upDateNickname();
                    return true;
                }
                if (string2.equals("#QUERRY")) {
                    while (stringTokenizer.hasMoreTokens()) {
                        String string10 = stringTokenizer.nextToken();
                        String string11 = stringTokenizer.nextToken();
                        AgentAddress agentAddress = this.getChatterAddress(string10);
                        this.launchAgent((AbstractAgent)new PrivateAgent(agentAddress, string11, string10), string11, true);
                    }
                    return true;
                }
                if (string2.equals("#KICK")) {
                    this.broadcastMessage("Chat", "defaultChannel", "chatter", new ChatMessage(this.chatter, "I have been kicked off by the chat administrator"));
                    this.display.println(" You have been KICKED!! U R NOW ALONE !!");
                    this.leaveRole("Chat", "defaultChannel", "chatter");
                    this.leaveGroup("Chat", "defaultChannel");
                    this.kicked = true;
                    return true;
                }
                if (string2.equals("#BAN")) {
                    this.killAgent((AbstractAgent)this);
                    return true;
                }
                if (string2.equals("#TOPIC")) {
                    String string12 = stringTokenizer.nextToken();
                    String string13 = stringTokenizer.nextToken();
                    this.display.lChanelTopic.setText(string13);
                    this.display.lChanelName.setText(string12);
                    return true;
                }
                if (string2.equals("#UNIQUE")) {
                    String string14 = ((ChatMessage)message).getChatter();
                    AgentAddress agentAddress = message.getSender();
                    this.sendMessage(agentAddress, new ChatterListMsg(this.chatter, this.getNamesList()));
                    return true;
                }
                if (string2.equals("#ADDNEWCHANNEL")) {
                    AgentAddress[] agentAddressArray;
                    String string15 = ((ChatMessage)message).getChatter();
                    String string16 = "";
                    int n2 = 0;
                    while (stringTokenizer.hasMoreTokens()) {
                        agentAddressArray = stringTokenizer.nextToken();
                        string16 = n2 == 0 ? string16 + (String)agentAddressArray : string16 + " " + (String)agentAddressArray;
                        ++n2;
                    }
                    agentAddressArray = this.getAgentsWithRole("Chat", string16, "chatter");
                    int n3 = agentAddressArray.length;
                    this.addCouple(string16, new Channel(string16, "No topic yet.", n3, string15), n3);
                    this.sendToAllNoneAdmin();
                    return true;
                }
                if (string2.equals("#MAJNBRUSRCHANNEL")) {
                    AgentAddress[] agentAddressArray;
                    String string17 = "";
                    int n4 = 0;
                    while (stringTokenizer.hasMoreTokens()) {
                        agentAddressArray = stringTokenizer.nextToken();
                        string17 = n4 == 0 ? string17 + (String)agentAddressArray : string17 + " " + (String)agentAddressArray;
                        ++n4;
                    }
                    agentAddressArray = this.getAgentsWithRole("Chat", string17, "chatter");
                    int n5 = agentAddressArray.length;
                    String string18 = this.getChannelAdminName(string17);
                    if (n5 != 0) {
                        this.addCouple(string17, new Channel(string17, "No topic yet.", n5, string18), n5);
                    }
                    this.sendToAllNoneAdmin();
                    return true;
                }
                if (string2.equals("#REMOVECHANNEL")) {
                    String string19 = "";
                    int n6 = 0;
                    while (stringTokenizer.hasMoreTokens()) {
                        String string20 = stringTokenizer.nextToken();
                        string19 = n6 == 0 ? string19 + string20 : string19 + " " + string20;
                        ++n6;
                    }
                    this.removeChannel(string19);
                    return true;
                }
                return false;
            }
        }
        catch (Exception exception) {
            System.out.println("Erreur lors de l'appel de filterChatMessage() ds la classe ChatAgent :" + exception);
            exception.printStackTrace();
        }
        return false;
    }

    public void sendToAllNoneAdmin() {
        if (this.getChatterRole(this.chatter).equals("Admin")) {
            AgentAddress[] agentAddressArray = this.getChatterAddressList();
            for (int i = 0; i < agentAddressArray.length; ++i) {
                this.sendAdminHashtableObject(agentAddressArray[i]);
                this.sendChannelHashtableObject(agentAddressArray[i]);
            }
        }
    }

    public void sendAdminHashtable(AgentAddress agentAddress) {
        Enumeration enumeration = this.nickChatter.elements();
        while (enumeration.hasMoreElements()) {
            Chatter chatter = (Chatter)enumeration.nextElement();
            if (agentAddress.equals((Object)this.getAddress())) continue;
            String string = chatter.getEmail();
            String string2 = chatter.getRole();
            String string3 = chatter.getNick();
            this.sendMessage(agentAddress, new ChatMessage(this.chatter, "#NICKNAME " + string3 + " " + string + " " + string2));
        }
    }

    public void sendAdminHashtableObject(AgentAddress agentAddress) {
        this.sendMessage(agentAddress, (Message)new ActMessage("nick", (Object)this.nickChatter));
    }

    public void sendChannelHashtableObject(AgentAddress agentAddress) {
        this.sendMessage(agentAddress, (Message)new ActMessage("channel", (Object)this.nameChannel));
    }

    public void upDateNickname() {
        this.display.resetNamesArea();
        Enumeration enumeration = this.nickChatter.elements();
        while (enumeration.hasMoreElements()) {
            Chatter chatter = (Chatter)enumeration.nextElement();
            String string = chatter.getNick();
            String string2 = chatter.getRole();
            if (string2.equals("Admin")) {
                this.display.addChatterName("@ " + string);
                continue;
            }
            this.display.addChatterName(string);
        }
        this.display.addNicknameButton();
    }

    public void printnickChatter() {
        System.out.println("\n\t\tContenu de la hashtable nickChatter de " + this.chatter);
        Enumeration enumeration = this.nickChatter.elements();
        while (enumeration.hasMoreElements()) {
            Chatter chatter = (Chatter)enumeration.nextElement();
            String string = chatter.getNick();
            String string2 = chatter.getRole();
            String string3 = chatter.getEmail();
            AgentAddress agentAddress = chatter.getAgentAddress();
            String string4 = "";
            for (int i = 0; i < chatter.sizeOfChannelVect(); ++i) {
                string4 = string4 + " " + chatter.getChannel(i);
            }
            System.out.println("\tNick= " + string + "\tRole= " + string2 + "\tEmail= " + string3 + "\tAgent Address= " + agentAddress + "\tListOfChannel= " + string4);
        }
    }

    public void printnameChannel() {
        System.out.println("\n\t\tContenu de la hashtable nameChannel de " + this.chatter);
        Enumeration enumeration = this.nameChannel.elements();
        while (enumeration.hasMoreElements()) {
            Channel channel = (Channel)enumeration.nextElement();
            String string = channel.getName();
            String string2 = channel.getTopic();
            int n = channel.getNbrUsers();
            String string3 = channel.getAdminName();
            System.out.println("\tName= " + string + "\tTopic= " + string2 + "\tNbreChatter= " + n + "\tNom Admin= " + string3);
        }
    }

    public boolean addCouple(String string, Chatter chatter) {
        boolean bl = false;
        if (!this.nickChatter.containsKey(string)) {
            this.nickChatter.put(string, chatter);
            bl = true;
        }
        return bl;
    }

    public void setChatterRole(String string) {
        if (!this.nickChatter.isEmpty()) {
            Object v = this.nickChatter.get(this.chatter);
            Chatter chatter = (Chatter)v;
            chatter.setRole(string);
        }
    }

    public void addChannelForChatter(String string) {
        if (this.nickChatter.containsKey(this.chatter)) {
            Object v = this.nickChatter.get(this.chatter);
            Chatter chatter = (Chatter)v;
            chatter.setChannel(string);
        }
    }

    public String getChatterRole(String string) {
        String string2 = "";
        if (!this.nickChatter.isEmpty()) {
            Object v = this.nickChatter.get(string);
            Chatter chatter = (Chatter)v;
            string2 = chatter.getRole();
            return string2;
        }
        string2 = "-1";
        return "-1";
    }

    public void printNickChatter() {
        int n = 0;
        System.out.println("Hashtable nickChatter content :");
        Enumeration enumeration = this.nickChatter.elements();
        while (enumeration.hasMoreElements()) {
            Chatter chatter = (Chatter)enumeration.nextElement();
            String string = chatter.getNick();
            String string2 = chatter.getEmail();
            String string3 = chatter.getRole();
            String string4 = chatter.getChannel(0);
            System.out.println("\t[" + n + "] : " + "\t" + string + "\t" + string2 + "\t" + string3 + "\t" + string4);
            ++n;
        }
    }

    public AgentAddress getChatterAddress(String string) {
        AgentAddress agentAddress;
        if (!this.nickChatter.isEmpty()) {
            Object v = this.nickChatter.get(string);
            Chatter chatter = (Chatter)v;
            agentAddress = chatter.getAgentAddress();
        } else {
            agentAddress = null;
        }
        return agentAddress;
    }

    public AgentAddress[] getChatterAddressList() {
        int n = 0;
        AgentAddress[] agentAddressArray = new AgentAddress[this.nickChatter.size()];
        Enumeration enumeration = this.nickChatter.elements();
        while (enumeration.hasMoreElements()) {
            AgentAddress agentAddress;
            Chatter chatter = (Chatter)enumeration.nextElement();
            agentAddressArray[n] = agentAddress = chatter.getAgentAddress();
            ++n;
        }
        return agentAddressArray;
    }

    public String getChatterAddressInString(String string) {
        AgentAddress agentAddress;
        String string2 = "";
        if (!this.nickChatter.isEmpty()) {
            Object v = this.nickChatter.get(string);
            Chatter chatter = (Chatter)v;
            agentAddress = chatter.getAgentAddress();
        } else {
            agentAddress = null;
        }
        string2 = agentAddress == null ? "-1" : agentAddress.toString();
        return string2;
    }

    public String getChatterEmailInString(String string) {
        String string2 = "essai";
        if (!this.nickChatter.isEmpty()) {
            Object v = this.nickChatter.get(string);
            Chatter chatter = (Chatter)v;
            string2 = chatter.getEmail();
        } else {
            string2 = null;
        }
        if (string2 == null) {
            string2 = "-1";
        }
        return string2;
    }

    public String getChatterNickInString(String string) {
        String string2 = "";
        if (!this.nickChatter.isEmpty()) {
            Object v = this.nickChatter.get(string);
            Chatter chatter = (Chatter)v;
            string2 = chatter.getNick();
        } else {
            string2 = null;
        }
        if (string2 == null) {
            string2 = "-1";
        }
        return string2;
    }

    public Chatter getChatterThanksAgentAddress(AgentAddress agentAddress) {
        Chatter chatter = new Chatter();
        Enumeration enumeration = this.nickChatter.elements();
        while (enumeration.hasMoreElements()) {
            Chatter chatter2 = (Chatter)enumeration.nextElement();
            AgentAddress agentAddress2 = chatter2.getAgentAddress();
            if (agentAddress2 != agentAddress) continue;
            chatter = chatter2;
        }
        return chatter;
    }

    public boolean isChatterInChannel(String string, String string2) {
        Chatter chatter;
        boolean bl = false;
        if (this.nickChatter.containsKey(string) && (chatter = (Chatter)this.nickChatter.get(string)).chatterIsInChannel(string2)) {
            bl = true;
        }
        return bl;
    }

    public String[] getNamesList() {
        int n = this.nickChatter.size();
        int n2 = 0;
        String[] stringArray = new String[n];
        Enumeration enumeration = this.nickChatter.elements();
        while (enumeration.hasMoreElements()) {
            String string;
            Chatter chatter = (Chatter)enumeration.nextElement();
            stringArray[n2] = string = chatter.getNick();
            ++n2;
        }
        return stringArray;
    }

    public String[] getEmailList() {
        int n = this.nickChatter.size();
        int n2 = 0;
        String[] stringArray = new String[n];
        Enumeration enumeration = this.nickChatter.elements();
        while (enumeration.hasMoreElements()) {
            String string;
            Chatter chatter = (Chatter)enumeration.nextElement();
            stringArray[n2] = string = chatter.getEmail();
            ++n2;
        }
        return stringArray;
    }

    public String[] getRoleList() {
        int n = this.nickChatter.size();
        int n2 = 0;
        String[] stringArray = new String[n];
        Enumeration enumeration = this.nickChatter.elements();
        while (enumeration.hasMoreElements()) {
            String string;
            Chatter chatter = (Chatter)enumeration.nextElement();
            stringArray[n2] = string = chatter.getRole();
            ++n2;
        }
        return stringArray;
    }

    public Chatter[] getChatterListWhoseAreInAChannel(String string) {
        int n = this.nickChatter.size();
        int n2 = 0;
        Chatter[] chatterArray = new Chatter[n];
        Enumeration enumeration = this.nickChatter.elements();
        while (enumeration.hasMoreElements()) {
            Chatter chatter = (Chatter)enumeration.nextElement();
            if (chatter.chatterIsInChannel(string)) {
                chatterArray[n2] = chatter;
            }
            ++n2;
        }
        return chatterArray;
    }

    public boolean removeChatter(String string) {
        Object v;
        boolean bl = !this.nickChatter.isEmpty() ? !(v = this.nickChatter.remove(string)).equals(null) : false;
        return bl;
    }

    public void printAdrNick() {
        String string = this.nickChatter.toString();
        System.out.println("La table nickChatter: " + string);
    }

    public boolean addCouple(String string, Channel channel, int n) {
        boolean bl = false;
        if (!this.nameChannel.containsKey(string)) {
            this.nameChannel.put(string, channel);
            bl = true;
        }
        if (this.nameChannel.containsKey(string)) {
            Channel channel2 = (Channel)this.nameChannel.get(string);
            channel2.setNbrUsers(n);
        }
        return bl;
    }

    public String getChannelTopic(String string) {
        String string2;
        if (!this.nameChannel.isEmpty()) {
            Object v = this.nameChannel.get(string);
            Channel channel = (Channel)v;
            string2 = channel.getTopic();
        } else {
            string2 = "-1";
        }
        return string2;
    }

    public String getChannelAdminName(String string) {
        String string2;
        if (this.nameChannel.containsKey(string)) {
            Object v = this.nameChannel.get(string);
            Channel channel = (Channel)v;
            string2 = channel.getAdminName();
        } else {
            string2 = "-1";
        }
        return string2;
    }

    public void setChannelRole(String string) {
        if (!this.nameChannel.isEmpty()) {
            Object v = this.nameChannel.get(string);
            Channel channel = (Channel)v;
            channel.setAdminName(this.chatter);
        }
    }

    public void setChannelNbrUsers(String string, int n) {
        if (this.nameChannel.containsKey(string)) {
            Object v = this.nameChannel.get(string);
            Channel channel = (Channel)v;
            channel.setNbrUsers(n);
        }
    }

    public int getChannelNbrUsers(String string) {
        int n = -1;
        if (this.nameChannel.containsKey(string)) {
            Object v = this.nameChannel.get(string);
            Channel channel = (Channel)v;
            n = channel.getNbrUsers();
        }
        return n;
    }

    public void incrChannelNbrUsers(String string) {
        if (this.nameChannel.containsKey(string)) {
            Channel channel = (Channel)this.nameChannel.get(string);
            int n = channel.getNbrUsers();
            channel.setNbrUsers(++n);
            this.nameChannel.put(string, channel);
        }
    }

    public String[] getChannelsNamesList() {
        int n = this.nameChannel.size();
        int n2 = 0;
        String[] stringArray = new String[n];
        Enumeration enumeration = this.nameChannel.elements();
        while (enumeration.hasMoreElements()) {
            String string;
            Channel channel = (Channel)enumeration.nextElement();
            stringArray[n2] = string = channel.getName();
            ++n2;
        }
        return stringArray;
    }

    public String[] getChannelsTopicsList() {
        int n = this.nameChannel.size();
        int n2 = 0;
        String[] stringArray = new String[n];
        Enumeration enumeration = this.nameChannel.elements();
        while (enumeration.hasMoreElements()) {
            String string;
            Channel channel = (Channel)enumeration.nextElement();
            stringArray[n2] = string = channel.getTopic();
            ++n2;
        }
        return stringArray;
    }

    public String[] getChannelsNbrUsersList() {
        int n = this.nameChannel.size();
        int n2 = 0;
        String[] stringArray = new String[n];
        Enumeration enumeration = this.nameChannel.elements();
        while (enumeration.hasMoreElements()) {
            String string;
            Channel channel = (Channel)enumeration.nextElement();
            int n3 = channel.getNbrUsers();
            stringArray[n2] = string = String.valueOf(n3);
            ++n2;
        }
        return stringArray;
    }

    public String[] getChannelsAdminNamesList() {
        int n = this.nameChannel.size();
        int n2 = 0;
        String[] stringArray = new String[n];
        Enumeration enumeration = this.nameChannel.elements();
        while (enumeration.hasMoreElements()) {
            String string;
            Channel channel = (Channel)enumeration.nextElement();
            stringArray[n2] = string = channel.getAdminName();
            ++n2;
        }
        return stringArray;
    }

    public void removeChannel(String string) {
        if (this.nameChannel.containsKey(string)) {
            this.nameChannel.remove(string);
        }
    }

    public void sendQuerry(AgentAddress agentAddress, String string) {
        this.sendMessage(agentAddress, new ChatMessage(this.chatter, "#QUERRY " + string + " " + this.chatter));
    }

    public void sendGetTable() {
        this.sendMessage("Chat", "defaultChannel", "Admin", new ChatMessage(this.chatter, "#GETTABLES"));
    }

    public void sendKick(String string) {
        AgentAddress agentAddress = this.getChatterAddress(string);
        this.sendMessage(agentAddress, new ChatMessage(this.chatter, "#KICK"));
    }

    public void sendBan(String string) {
        AgentAddress agentAddress = this.getChatterAddress(string);
        this.sendMessage(agentAddress, new ChatMessage(this.chatter, "#BAN"));
    }

    public void sendTopic(String string, String string2) {
        this.broadcastMessage("Chat", "defaultChannel", "chatter", new ChatMessage(this.chatter, "#TOPIC " + string + " " + string2));
    }

    public void sendUnique() {
        AgentAddress agentAddress = this.getAgentWithRole("Chat", "defaultChannel", "Admin");
        this.sendMessage(agentAddress, new ChatMessage(this.chatter, "#UNIQUE"));
    }

    public void sendAddChannel(String string) {
        AgentAddress agentAddress = this.getAgentWithRole("Chat", "defaultChannel", "Admin");
        this.sendMessage(agentAddress, new ChatMessage(this.chatter, "#ADDNEWCHANNEL " + string));
    }

    public void sendMAJNbrUsrersOfChannel(String string) {
        AgentAddress agentAddress = this.getAgentWithRole("Chat", "defaultChannel", "Admin");
        this.sendMessage(agentAddress, new ChatMessage(this.chatter, "#MAJNBRUSRCHANNEL " + string));
    }

    public void sendRemoveChannel(String string) {
        AgentAddress agentAddress = this.getAgentWithRole("Chat", "defaultChannel", "Admin");
        this.sendMessage(agentAddress, new ChatMessage(this.chatter, "#REMOVECHANNEL " + string));
    }
}

