/*
 * Decompiled with CFR 0.152.
 */
package madkit.pluginmanager;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import madkit.pluginmanager.ManagerAgent;
import madkit.pluginmanager.Merged;
import madkit.pluginmanager.PluginInformation;
import madkit.pluginmanager.Utils;
import madkit.pluginmanager.Version;
import madkit.pluginmanager.XMLWriter;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class PluginList {
    private File _dir;
    private File _installedFile;
    private ZipFile _pluginZip;
    private Hashtable _installed;
    private Hashtable _installedFiles;
    private Hashtable _available;
    private Hashtable _categories;
    private Hashtable _hosts;

    public PluginList(File file, File file2, File file3) throws ZipException, IOException {
        this._dir = file;
        if (this._dir.exists()) {
            this._dir.delete();
        }
        this._dir.mkdirs();
        this._dir.deleteOnExit();
        this._pluginZip = new ZipFile(file2);
        this._installed = new Hashtable();
        this._installedFiles = new Hashtable();
        this._available = new Hashtable();
        this._categories = new Hashtable();
        this._hosts = new Hashtable();
        this._installedFile = file3;
    }

    public void init() throws SAXException, IOException, ParserConfigurationException, FactoryConfigurationError {
        this.createInstalledInfo(this._installedFile, null, null, null, null);
        this.createAvailablePluginInfo();
    }

    private void createAvailablePluginInfo() throws SAXException, IOException, ParserConfigurationException, FactoryConfigurationError {
        File file = PluginList.extractFile(this._pluginZip, this._pluginZip.getEntry("plugins.xml"), this._dir);
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(file);
        NodeList nodeList = document.getElementsByTagName("plugin");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            String string = element.getAttribute("name");
            String string2 = element.getAttribute("category");
            this._hosts.put(string, element.getAttribute("server"));
            Vector<String> vector = (Vector<String>)this._categories.remove(string2);
            if (vector == null) {
                vector = new Vector<String>();
            }
            vector.add(string);
            this._categories.put(string2, vector);
        }
    }

    private void createInstalledInfo(File file, String string, String string2, Version version, Vector vector) throws SAXException, IOException, ParserConfigurationException, FactoryConfigurationError {
        Object object;
        Object object2;
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(file);
        if (string2 != null) {
            object2 = document.createElement("plugin");
            object2.setAttribute("name", string2);
            object2.setAttribute("version", version.toString());
            for (Object object3 : vector) {
                object = document.createElement("file");
                object.setAttribute("location", (String)object3);
                object2.appendChild((Node)object);
            }
            document.getDocumentElement().appendChild((Node)object2);
        }
        object2 = document.getElementsByTagName("plugin");
        for (int i = 0; i < object2.getLength(); ++i) {
            Object object3;
            object3 = (Element)object2.item(i);
            object = object3.getAttribute("name");
            if (string != null && ((String)object).equals(string)) {
                document.getDocumentElement().removeChild((Node)object3);
                object2 = document.getElementsByTagName("plugin");
                i = 0;
                this._installedFiles = new Hashtable();
                this._installed = new Hashtable();
                continue;
            }
            Version version2 = Version.valueOf(object3.getAttribute("version"));
            NodeList nodeList = object3.getElementsByTagName("file");
            Vector<String> vector2 = new Vector<String>();
            for (int j = 0; j < nodeList.getLength(); ++j) {
                Element element = (Element)nodeList.item(i);
                if (element == null) continue;
                vector2.add(element.getAttribute("location"));
            }
            this._installedFiles.put(object, vector2);
            this._installed.put(object, version2);
        }
        if (string2 != null || string != null) {
            XMLWriter.saveDocument(this._installedFile, document);
        }
    }

    private static void debug(String string) {
        System.out.println("Debug *** " + string);
    }

    public String toString() {
        String string = "Installed: " + this._installed;
        String string2 = "installedFiles: " + this._installedFiles;
        String string3 = "availables: " + this._available;
        return "<PluginList=" + this._installed.size() + "; " + this._available.size() + ">";
    }

    public PluginInformation getPlugin(String string) {
        PluginInformation pluginInformation = (PluginInformation)this._available.get(string);
        if (pluginInformation != null) {
            return pluginInformation;
        }
        File file = this.getPluginFile(string);
        File file2 = this._installedFile.getParentFile().getParentFile();
        pluginInformation = PluginInformation.getPluginInformation(file, (String)this._hosts.get(string), file2);
        if (pluginInformation != null) {
            this._available.put(string, pluginInformation);
        }
        return pluginInformation;
    }

    private File getPluginFile(String string) {
        File file = new File(this._dir.getAbsolutePath() + File.separatorChar + string + ".xml");
        if (file.exists()) {
            return file;
        }
        ZipEntry zipEntry = this._pluginZip.getEntry(string + ".xml");
        if (zipEntry == null) {
            return null;
        }
        return PluginList.extractFile(this._pluginZip, zipEntry, this._dir);
    }

    public static File extractFile(ZipFile zipFile, ZipEntry zipEntry, File file) {
        try {
            File file2;
            ZipInputStream zipInputStream = new ZipInputStream(zipFile.getInputStream(zipEntry));
            if (!file.exists()) {
                file.mkdirs();
            }
            if ((file2 = new File(file.getAbsolutePath() + File.separatorChar + zipEntry.getName())).exists()) {
                file2.delete();
            }
            file2.getParentFile().mkdirs();
            PluginList.copyInputStream(zipFile.getInputStream(zipEntry), new BufferedOutputStream(new FileOutputStream(file2)));
            return file2;
        }
        catch (IOException iOException) {
            System.out.println("IOException caught " + iOException.getMessage());
            return null;
        }
    }

    private static final void copyInputStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        PluginList.copyInputStream(inputStream, outputStream, true);
    }

    private static final void copyInputStream(InputStream inputStream, OutputStream outputStream, boolean bl) throws IOException {
        int n;
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray)) >= 0) {
            outputStream.write(byArray, 0, n);
        }
        if (bl) {
            inputStream.close();
            outputStream.close();
        }
    }

    public void clean() {
        this._dir.delete();
    }

    public Collection getPluginsByCategory(String string) {
        return (Collection)this._categories.get(string);
    }

    public int status(String string) {
        Version version = (Version)this._installed.get(string);
        if (version == null) {
            return 2;
        }
        PluginInformation pluginInformation = this.getPlugin(string);
        if (pluginInformation == null) {
            return 2;
        }
        Version version2 = pluginInformation.getVersion();
        if (version2 == null) {
            this._available.put(string, this.getPlugin(string));
        }
        if (version.isHigher(version2)) {
            return 1;
        }
        return 0;
    }

    public Enumeration getPluginNames() {
        return this._available.keys();
    }

    public Enumeration getCategories() {
        return this._categories.keys();
    }

    public boolean isInstalled(String string, Version version) {
        return this._installed.keySet().contains(string) && this._installed.get(string).equals(version);
    }

    public static File mergePlugins(String string, File file, File file2) throws SAXException, ParserConfigurationException, FactoryConfigurationError {
        File file3 = file2.getParentFile();
        file3.mkdirs();
        String string2 = "plugins.xml";
        String string3 = ManagerAgent.getTempDir().getAbsolutePath();
        File file4 = new File(string3 + File.separatorChar + "new");
        file4.delete();
        file4.mkdirs();
        File file5 = new File(string3 + File.separatorChar + "old");
        file5.delete();
        file5.mkdirs();
        File file6 = new File(file5.getAbsolutePath() + File.separatorChar + "plugin.zip");
        file6.delete();
        ZipFile zipFile = null;
        if (file2.exists()) {
            if (!Utils.copyFile(file2, file6, true)) {
                System.out.println("error in copy!!!!");
            }
            file2.delete();
        }
        ZipFile zipFile2 = null;
        try {
            zipFile2 = new ZipFile(file);
        }
        catch (ZipException zipException) {
            zipException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        boolean bl = true;
        if (!file6.exists()) {
            bl = true;
        }
        ZipOutputStream zipOutputStream = null;
        try {
            zipOutputStream = new ZipOutputStream(new FileOutputStream(file2));
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        Vector<Merged> vector = new Vector<Merged>();
        if (bl) {
            File file7 = PluginList.extractFile(zipFile2, zipFile2.getEntry("plugins.xml"), file4);
            Document document = null;
            try {
                document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(file7);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            Document document2 = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element element = null;
            Element element2 = document2.createElement("plugins");
            NodeList nodeList = document.getElementsByTagName("plugin");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element3 = (Element)nodeList.item(i);
                Merged merged = PluginList.getMergedElement(zipFile, element, zipFile2, element3, document2, string);
                element2.appendChild(merged.mergedElement);
                vector.add(merged);
            }
            document2.appendChild(element2);
            try {
                PluginList.createFinalZip(zipOutputStream, vector, document2);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else {
            File file8 = PluginList.extractFile(zipFile, zipFile.getEntry("plugins.xml"), file5);
            File file9 = PluginList.extractFile(zipFile2, zipFile2.getEntry("plugins.xml"), file4);
            Document document = null;
            try {
                document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(file9);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            documentBuilder.setEntityResolver(new EntityResolver(){

                public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
                    return new InputSource(ClassLoader.getSystemResourceAsStream("/madkit/pluginmanager/plugins.dtd"));
                }
            });
            Document document3 = null;
            try {
                document3 = documentBuilder.parse(file8);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            Document document4 = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element element = document4.createElement("plugins");
            NodeList nodeList = document.getElementsByTagName("plugin");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element4 = (Element)nodeList.item(i);
                Element element5 = document3.getElementById(element4.getAttribute("name"));
                Merged merged = PluginList.getMergedElement(zipFile, element5, zipFile2, element4, document4, string);
                element.appendChild(merged.mergedElement);
                vector.add(merged);
            }
            nodeList = document3.getElementsByTagName("plugin");
            System.out.println("@@ list =" + nodeList.getLength());
            document4.appendChild(element);
            try {
                PluginList.createFinalZip(zipOutputStream, vector, document4);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            System.out.println("In the right track .. ");
            file6.delete();
            System.exit(0);
        }
        file4.delete();
        file5.delete();
        return file2;
    }

    private static void createFinalZip(ZipOutputStream zipOutputStream, Vector vector, Document document) throws IOException {
        ZipEntry zipEntry = new ZipEntry("plugins.xml");
        zipOutputStream.putNextEntry(zipEntry);
        OutputFormat outputFormat = new OutputFormat(document);
        outputFormat.setEncoding("ISO-8859-1");
        outputFormat.setIndenting(true);
        XMLSerializer xMLSerializer = new XMLSerializer((OutputStream)zipOutputStream, outputFormat);
        xMLSerializer.asDOMSerializer();
        xMLSerializer.serialize(document);
        zipOutputStream.closeEntry();
        for (int i = 0; i < vector.size(); ++i) {
            Merged merged = (Merged)vector.elementAt(i);
            zipEntry = new ZipEntry(merged.entryName);
            zipOutputStream.putNextEntry(zipEntry);
            PluginList.copyInputStream(merged.origin.getInputStream(zipEntry), zipOutputStream, false);
        }
        zipOutputStream.flush();
        zipOutputStream.finish();
        zipOutputStream.close();
    }

    private static Merged getMergedElement(ZipFile zipFile, Element element, ZipFile zipFile2, Element element2, Document document, String string) {
        Version version = element == null ? new Version(0, 0, 0) : Version.valueOf(element.getAttribute("version"));
        Version version2 = Version.valueOf(element2.getAttribute("version"));
        Element element3 = document.createElement("plugin");
        if (version.isHigher(version2)) {
            NamedNodeMap namedNodeMap = element2.getAttributes();
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Node node = namedNodeMap.item(i);
                element3.setAttribute(node.getNodeName(), node.getNodeValue());
            }
            element3.setAttribute("server", string);
            return new Merged(zipFile2, element3, element3.getAttribute("desc"));
        }
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node = namedNodeMap.item(i);
            element3.setAttribute(node.getNodeName(), node.getNodeValue());
        }
        element3.setAttribute("server", string);
        return new Merged(zipFile, element3, element3.getAttribute("desc"));
    }

    public boolean isAvailable(String string, Version version) {
        PluginInformation pluginInformation = this.getPlugin(string);
        if (pluginInformation == null) {
            return false;
        }
        return pluginInformation.getVersion().equals(version) || version.isHigher(pluginInformation.getVersion());
    }

    public boolean installedConstains(String string) {
        return this._installed.containsKey(string);
    }

    public Collection getFilesInstalledPlugin(String string) {
        Collection collection = (Collection)this._installedFiles.get(string);
        if (collection == null) {
            return new Vector();
        }
        return collection;
    }

    public void removePlugin(String string) {
        if (this._installed.containsKey(string)) {
            try {
                this.createInstalledInfo(this._installedFile, string, null, null, null);
            }
            catch (SAXException sAXException) {
                PluginList.debug("SAXException caught " + sAXException.getMessage());
            }
            catch (IOException iOException) {
                PluginList.debug("IOException caught " + iOException.getMessage());
            }
            catch (ParserConfigurationException parserConfigurationException) {
                PluginList.debug("ParserConfigurationException caught " + parserConfigurationException.getMessage());
            }
            catch (FactoryConfigurationError factoryConfigurationError) {
                PluginList.debug("FactoryConfigurationError caught " + factoryConfigurationError.getMessage());
            }
            this._installedFiles.remove(string);
        }
    }

    public Vector packagesOfFile(String string) {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = this._installedFiles.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!((Vector)this._installedFiles.get(string2)).contains(string)) continue;
            vector.add(string2);
        }
        return vector;
    }

    public void installPlugin(String string, Version version, Vector vector) {
        try {
            this.createInstalledInfo(this._installedFile, null, string, version, vector);
        }
        catch (SAXException sAXException) {
            PluginList.debug("SAXException caught " + sAXException.getMessage());
        }
        catch (IOException iOException) {
            PluginList.debug("IOException caught " + iOException.getMessage());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            PluginList.debug("ParserConfigurationException caught " + parserConfigurationException.getMessage());
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            PluginList.debug("FactoryConfigurationError caught " + factoryConfigurationError.getMessage());
        }
    }
}

