/*
 * Decompiled with CFR 0.152.
 */
package madkit.pluginmanager;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import madkit.pluginmanager.Action;
import madkit.pluginmanager.Actions;
import madkit.pluginmanager.Dependency;
import madkit.pluginmanager.Version;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

class PluginInformation {
    public static final int UP_TO_DATE = 0;
    public static final int NEEDS_UPDATE = 1;
    public static final int NEW = 2;
    private String _name;
    private Version _version;
    private int _size;
    private String _fileName;
    private String _description;
    private Hashtable _dependencies = new Hashtable();
    private Collection _actions = new Vector();
    private String _serverUrl;
    private String _authoName;
    private String _authorEmail;
    private String _authorWeb;
    private String _md5;

    private PluginInformation(String string, Version version) {
        this._name = string.toString();
        this._version = version;
    }

    public String toString() {
        return "<PluginInformation=" + this._name + "; " + this._size + "; " + this._fileName + ">";
    }

    public final String getAuthorName() {
        return this._authoName;
    }

    public final String getAuthorEmail() {
        return this._authorEmail;
    }

    public final String getAuthorWeb() {
        return this._authorWeb;
    }

    public final String getDescription() {
        return this._description;
    }

    public final String getFileName() {
        return this._fileName;
    }

    public final String getFileMD5Sum() {
        return this._md5;
    }

    public final String getName() {
        return this._name;
    }

    public final String getServerURL() {
        return this._serverUrl;
    }

    public final int getSize() {
        return this._size;
    }

    public final Version getVersion() {
        return this._version;
    }

    public final Collection getDependencies() {
        return this._dependencies.values();
    }

    public static PluginInformation getPluginInformation(File file, String string, File file2) {
        if (file == null || !file.exists()) {
            System.err.println("Cannot construct PluginInformation: file does not exist");
            return null;
        }
        if (string == null) {
            System.err.println("Cannot construct a PluginInformation with out a server url\n Under Windows systems this error might be linked to a mistyping in the plugin name");
            return null;
        }
        try {
            Text text;
            Object object;
            int n;
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(file);
            Element element = document.getDocumentElement();
            PluginInformation pluginInformation = new PluginInformation(element.getAttribute("name"), Version.valueOf(element.getAttribute("version")));
            pluginInformation._serverUrl = string;
            NodeList nodeList = document.getElementsByTagName("author");
            Element element2 = (Element)nodeList.item(0);
            nodeList = element2.getChildNodes();
            for (n = 0; n < nodeList.getLength(); ++n) {
                object = nodeList.item(n).getNodeName();
                text = (Text)nodeList.item(n).getFirstChild();
                if (((String)object).equals("name")) {
                    pluginInformation._authoName = text.getData();
                    continue;
                }
                if (((String)object).equals("email")) {
                    pluginInformation._authorEmail = text.getData();
                    continue;
                }
                if (!((String)object).equals("web")) continue;
                pluginInformation._authorWeb = text.getData();
            }
            nodeList = document.getElementsByTagName("file");
            element2 = (Element)nodeList.item(0);
            if (element2 != null) {
                pluginInformation._fileName = element2.getAttribute("dir") + "/" + element2.getAttribute("name");
                pluginInformation._size = Integer.valueOf(element2.getAttribute("size"));
                pluginInformation._md5 = element2.getAttribute("checksum");
            }
            nodeList = document.getElementsByTagName("depends");
            element2 = (Element)nodeList.item(0);
            nodeList = element2.getElementsByTagName("plugin");
            for (n = 0; n < nodeList.getLength(); ++n) {
                element2 = (Element)nodeList.item(n);
                object = new Dependency(element2.getAttribute("name"), Version.valueOf(element2.getAttribute("version")));
                pluginInformation._dependencies.put(((Dependency)object).name, object);
            }
            nodeList = document.getElementsByTagName("description");
            element2 = (Element)nodeList.item(0);
            text = (Text)element2.getFirstChild();
            pluginInformation._description = text.getData();
            nodeList = document.getElementsByTagName("action");
            pluginInformation._actions = new Vector();
            for (n = 0; n < nodeList.getLength(); ++n) {
                object = (Element)nodeList.item(n);
                Action action = Actions.getActionByName(object.getAttribute("id"), file2, pluginInformation.getName(), pluginInformation.getVersion());
                Collection collection = action.getMandatoryParameters();
                collection.addAll(action.getOptionalParameters());
                Properties properties = new Properties();
                for (String string2 : collection) {
                    if (object.getAttribute(string2) == null) continue;
                    properties.setProperty(string2, object.getAttribute(string2));
                }
                if (action == null) continue;
                action.setParamenters(properties);
                pluginInformation._actions.add(action);
            }
            return pluginInformation;
        }
        catch (SAXException sAXException) {
            PluginInformation.debug("SAXException caught " + sAXException.getMessage());
        }
        catch (IOException iOException) {
            PluginInformation.debug("IOException caught " + iOException.getMessage());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            PluginInformation.debug("ParserConfigurationException caught " + parserConfigurationException.getMessage());
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            PluginInformation.debug("FactoryConfigurationError caught " + factoryConfigurationError.getMessage());
        }
        return null;
    }

    public final String getDownloadURL() {
        return this._serverUrl + "/download.php?file=" + this._fileName;
    }

    private static void debug(String string) {
        System.err.println(string);
    }

    public Collection getActions() {
        return this._actions;
    }
}

