/*
 * Decompiled with CFR 0.152.
 */
package madkit.pluginmanager;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipException;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.table.TableColumn;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import madkit.kernel.AbstractAgent;
import madkit.kernel.AgentAddress;
import madkit.kernel.Message;
import madkit.kernel.StringMessage;
import madkit.pluginmanager.CustomTableCellRenderer;
import madkit.pluginmanager.ManagerAgent;
import madkit.pluginmanager.PluginsTableModel;
import madkit.pluginmanager.ProgressAgent;
import madkit.pluginmanager.SettingsFrame;
import madkit.pluginmanager.Version;
import org.xml.sax.SAXException;

class ManagerGUI
extends JPanel {
    public static final String NEEDS_UPDATE = "Needs Update";
    public static final String UP_TO_DATE = "Up to date";
    public static final String NEW = "New";
    private ManagerAgent _agent;
    private JTabbedPane _tabpane;
    private Hashtable _categoriesTables = new Hashtable();
    private Collection _buttons = new Vector();

    public ManagerGUI(ManagerAgent managerAgent) {
        this._agent = managerAgent;
        this.setLayout(new BorderLayout());
        JToolBar jToolBar = new JToolBar();
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("Settings");
        JMenuItem jMenuItem = new JMenuItem("Update Plugin List");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ManagerGUI.this._agent.refreshPluginsFromSources();
            }
        });
        JMenu jMenu2 = new JMenu("Options");
        JMenuItem jMenuItem2 = new JMenuItem("Change Download Source");
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ManagerGUI.this._agent.askDownloadSource();
            }
        });
        jMenu2.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem("Settings");
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ManagerGUI.this.changeSettings();
            }
        });
        jMenu2.add(jMenuItem3);
        jMenu.add(jMenuItem);
        jMenu.add(jMenu2);
        jMenuBar.add(jMenu);
        JMenu jMenu3 = new JMenu("Tools");
        final JCheckBox jCheckBox = new JCheckBox("Show Download Progress", true);
        jCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = !jCheckBox.isSelected();
                AgentAddress agentAddress = ManagerGUI.this._agent.getAgentWithRole("MadkitUpdate", "updater", "progress");
                if (agentAddress != null) {
                    ManagerGUI.this._agent.sendMessage(ManagerGUI.this._agent.getAgentWithRole("MadkitUpdate", "updater", "progress"), (Message)new StringMessage(Boolean.toString(bl)));
                } else if (!bl) {
                    ManagerGUI.this._agent.launchAgent((AbstractAgent)new ProgressAgent(), "progressAgent", true);
                }
            }
        });
        JMenu jMenu4 = new JMenu("Install From Local System");
        JMenuItem jMenuItem4 = new JMenuItem("Single Plugin");
        jMenuItem4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ManagerGUI.this.loadLocalPluginFile(false);
            }
        });
        jMenu4.add(jMenuItem4);
        jMenuItem4 = new JMenuItem("Full Madkit Bundle");
        jMenuItem4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ManagerGUI.this.loadLocalPluginFile(true);
            }
        });
        jMenu4.add(jMenuItem4);
        jMenu3.add(jCheckBox);
        jMenu3.add(jMenu4);
        jMenuBar.add(jMenu3);
        jToolBar.add(jMenuBar);
        this.add((Component)jToolBar, "North");
        this._tabpane = new JTabbedPane();
        this.add((Component)this._tabpane, "Center");
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton("Update list");
        this._buttons.add(jButton);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ManagerGUI.this._agent.refreshPluginsFromSources();
            }
        });
        JButton jButton2 = new JButton("Install");
        this._buttons.add(jButton2);
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ManagerGUI.this._agent.startInstall();
            }
        });
        JButton jButton3 = new JButton("Details");
        this._buttons.add(jButton3);
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = ManagerGUI.this._tabpane.getTitleAt(ManagerGUI.this._tabpane.getSelectedIndex());
                JTable jTable = (JTable)ManagerGUI.this._categoriesTables.get(string);
                int n = jTable.getSelectedRow();
                if (n < 0) {
                    return;
                }
                PluginsTableModel pluginsTableModel = (PluginsTableModel)jTable.getModel();
                String string2 = (String)pluginsTableModel.getValueAt(n, 0);
                ManagerGUI.this._agent.showDetails(string2);
            }
        });
        JButton jButton4 = new JButton("Upgrade");
        this._buttons.add(jButton4);
        jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ManagerGUI.this._agent.upgrade();
            }
        });
        JButton jButton5 = new JButton("Quit");
        jButton5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((ManagerGUI)ManagerGUI.this)._agent._alive = false;
            }
        });
        jPanel.add(jButton);
        jPanel.add(jButton2);
        jPanel.add(jButton3);
        jPanel.add(jButton4);
        jPanel.add(jButton5);
        this.add((Component)jPanel, "South");
        this.setPreferredSize(new Dimension(400, 400));
    }

    void loadLocalPluginFile(boolean bl) {
        JFileChooser jFileChooser = new JFileChooser();
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            try {
                if (bl) {
                    this._agent.installFromBigLocalDistribution(jFileChooser.getSelectedFile());
                } else {
                    this._agent.installLocalFilePlugin(jFileChooser.getSelectedFile());
                }
            }
            catch (ZipException zipException) {
                zipException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            catch (SAXException sAXException) {
                sAXException.printStackTrace();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                parserConfigurationException.printStackTrace();
            }
            catch (FactoryConfigurationError factoryConfigurationError) {
                factoryConfigurationError.printStackTrace();
            }
        }
    }

    void changeSettings() {
        SettingsFrame settingsFrame = new SettingsFrame();
        int n = settingsFrame.showSettings(this._agent._configuration);
        if (n == 0) {
            this._agent._configuration = settingsFrame.getSelectedConfig();
            this._agent.saveConfig();
            this._agent.loadConfig();
        }
    }

    public void setEnabled(boolean bl) {
        this._tabpane.setEnabled(bl);
        Collection collection = this._categoriesTables.values();
        for (JComponent jComponent : collection) {
            jComponent.setEnabled(bl);
        }
        for (JComponent jComponent : this._buttons) {
            ((AbstractButton)jComponent).setEnabled(bl);
        }
    }

    public void markUpgrade() {
        Enumeration enumeration = this._categoriesTables.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            JTable jTable = (JTable)this._categoriesTables.get(string);
            ((PluginsTableModel)jTable.getModel()).upgrade();
        }
    }

    public void refresh() {
        Enumeration enumeration = this._categoriesTables.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            JTable jTable = (JTable)this._categoriesTables.get(string);
            ((PluginsTableModel)jTable.getModel()).fireTableDataChanged();
        }
    }

    public void informUnavailablePlugin(String string, Version version, String string2) {
        JOptionPane.showMessageDialog(this, "Plugin " + string + " version: " + version + "" + "can not be found. Need by " + string2, "Broken Dependency", 0);
    }

    public void setRefresingState(boolean bl) {
        if (bl) {
            this.setEnabled(!bl);
        } else {
            this._tabpane.removeAll();
            this.loadPlugins();
            this.setEnabled(!bl);
        }
    }

    public void loadPlugins() {
        if (this._agent._list == null) {
            System.out.println("null plugin list");
            return;
        }
        Enumeration enumeration = this._agent._list.getCategories();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            PluginsTableModel pluginsTableModel = new PluginsTableModel(this._agent, string);
            JTable jTable = this.setupTable(pluginsTableModel);
            JScrollPane jScrollPane = new JScrollPane();
            jScrollPane.setViewportView(jTable);
            this._categoriesTables.put(string, jTable);
            if (string.equals("bundle")) {
                this._tabpane.add(jScrollPane, string, 0);
                continue;
            }
            if (string.equals("docs") || string.equals("sources")) continue;
            this._tabpane.add(string, jScrollPane);
        }
    }

    private JTable setupTable(PluginsTableModel pluginsTableModel) {
        JTable jTable = new JTable();
        jTable.setSelectionMode(0);
        jTable.setModel(pluginsTableModel);
        CustomTableCellRenderer customTableCellRenderer = new CustomTableCellRenderer();
        for (int i = 1; i < pluginsTableModel.getColumnCount(); ++i) {
            TableColumn tableColumn = jTable.getColumnModel().getColumn(i);
            tableColumn.setCellRenderer(customTableCellRenderer);
        }
        return jTable;
    }
}

