/*
 * Decompiled with CFR 0.152.
 */
package madkit.pluginmanager;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import madkit.kernel.AbstractAgent;
import madkit.kernel.Agent;
import madkit.kernel.Message;
import madkit.kernel.StringMessage;
import madkit.pluginmanager.Action;
import madkit.pluginmanager.Actions;
import madkit.pluginmanager.Dependency;
import madkit.pluginmanager.DetailsAgent;
import madkit.pluginmanager.DownloadAgent;
import madkit.pluginmanager.DownloadFinished;
import madkit.pluginmanager.InstallPlugin;
import madkit.pluginmanager.ManagerGUI;
import madkit.pluginmanager.ObservableProcess;
import madkit.pluginmanager.PluginInformation;
import madkit.pluginmanager.PluginList;
import madkit.pluginmanager.ProcessMonitor;
import madkit.pluginmanager.ProgressAgent;
import madkit.pluginmanager.SelectedPluginMessage;
import madkit.pluginmanager.UpdateRoles;
import madkit.pluginmanager.Utils;
import madkit.pluginmanager.Version;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class ManagerAgent
extends Agent
implements UpdateRoles,
ObservableProcess {
    private ManagerGUI _gui;
    boolean _alive = true;
    PluginList _list = null;
    private int maxDownloads = 0;
    private boolean autoUpdateList = true;
    private boolean informNewVersion = true;
    private File configFile;
    private File installedFile;
    private File sourcesFile;
    private File pluginsFile;
    private File _madkitDir;
    private static File _tempDir;
    Properties _configuration;
    String _downloadServer = null;
    private boolean _refreshingPlugins = false;
    private int _sourcesCount = 0;
    private Hashtable _toDownload = new Hashtable();
    private Hashtable _toInstall = null;
    private int _maxGlobal;
    private int _maxCurrent;
    private String _noteCurr = null;
    private int _statusCurr;
    private int _statusGlob;
    private boolean _processFinished = false;
    boolean _fullInstallRequested = false;

    public ManagerAgent() {
        this(null, null);
    }

    public ManagerAgent(File file, Properties properties) {
        if (file == null) {
            this.askMadkitHomeDirectory();
        } else {
            this._madkitDir = file;
        }
        this._configuration = properties;
        this.initFiles();
    }

    private void askMadkitHomeDirectory() {
        String string = System.getProperty("madkit.dir") + File.separatorChar + "cache" + File.separatorChar + "pluginmanager.config";
        File file = new File(string);
        if (file.exists()) {
            File file2 = new File(System.getProperty("madkit.dir"));
            System.out.println("Setting installation dir to " + file2.getAbsolutePath());
            this._madkitDir = file2.getAbsoluteFile();
            return;
        }
        JFileChooser jFileChooser = new JFileChooser(new File(System.getProperty("madkit.dir")));
        jFileChooser.setFileSelectionMode(1);
        int n = jFileChooser.showOpenDialog(new JFrame());
        if (n == 0) {
            this._madkitDir = jFileChooser.getSelectedFile();
        }
    }

    public void live() {
        while (this._alive) {
            String string;
            try {
                Message message = this.waitNextMessage(50L);
                this.exitImmediatlyOnKill();
                if (message == null) continue;
                if (message instanceof SelectedPluginMessage) {
                    this.markForInstall(((SelectedPluginMessage)message).getPluginName());
                } else if (message instanceof DownloadFinished) {
                    this.handleFinishedDownload((DownloadFinished)message);
                } else if (message instanceof StringMessage && (string = ((StringMessage)message).getString()).equalsIgnoreCase("startInstall")) {
                    this.startInstall();
                }
                this.pause(100);
            }
            catch (Exception exception) {
                string = "Exception caught:\nClass: " + exception.getClass().getName() + "\n" + "Cause: " + exception.getCause() + "\n" + "Message: " + exception.getMessage() + "\n" + "\nPlease Report this bug.";
                this.println(string);
                exception.printStackTrace();
                if (this.hasGUI()) {
                    JOptionPane.showMessageDialog(this._gui, string, "Exception", 0);
                    continue;
                }
                System.err.println("PluginInstaller error: " + string + "Exception+");
            }
        }
    }

    public boolean isGoingToInstall(String string) {
        return this._toDownload.containsKey(string);
    }

    private void handleFinishedDownload(DownloadFinished downloadFinished) {
        String string = downloadFinished.getName();
        this.println("Plugin downloaded, installing : " + downloadFinished.getName());
        if (string.equals("plugins.zip")) {
            if (!this.checkDownloadStatus(downloadFinished)) {
                return;
            }
            this.println("Download from " + downloadFinished.getServer() + " terminated ");
            --this._sourcesCount;
            if (this._sourcesCount == 0) {
                this.println("All Sources Downloaded");
                this.println("Merging Sources");
                try {
                    PluginList.mergePlugins(downloadFinished.getServer(), downloadFinished.getFile(), this.pluginsFile);
                    this.updatePlugins();
                    this.checkForNewPluginManager();
                    if (this._fullInstallRequested) {
                        this.markForInstall("madkit-full");
                        this.startInstall();
                    }
                }
                catch (SAXException sAXException) {
                    this.debug("SAXException caught " + sAXException.getMessage());
                }
                catch (IOException iOException) {
                    this.debug("IOException caught " + iOException.getMessage());
                    iOException.printStackTrace();
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    this.debug("ParserConfigurationException caught " + parserConfigurationException.getMessage());
                }
                catch (FactoryConfigurationError factoryConfigurationError) {
                    this.debug("FactoryConfigurationError caught " + factoryConfigurationError.getMessage());
                }
            }
        } else {
            if (this._toInstall == null) {
                this._toInstall = new Hashtable();
            }
            InstallPlugin installPlugin = (InstallPlugin)this._toDownload.remove(string);
            if (this._toInstall.containsKey(downloadFinished.getName())) {
                return;
            }
            installPlugin.file = downloadFinished.getFile();
            this._toInstall.put(string, installPlugin);
            if (!this._toDownload.isEmpty()) {
                int n = this.getAgentsWithRole("MadkitUpdate", "updater", "downloader").length;
                if (this.maxDownloads == 0 || n < this.maxDownloads) {
                    InstallPlugin installPlugin2 = (InstallPlugin)this._toDownload.elements().nextElement();
                    if (!installPlugin2.downloading) {
                        PluginInformation pluginInformation = installPlugin2.pluginInformation;
                        installPlugin2.downloading = true;
                        this.startDownlad(pluginInformation);
                    }
                    ++n;
                }
                this.incrementCurrentProcessStatus();
            } else {
                boolean bl = this.doPluginsInstall();
                this.setProcessStatusFinished(true);
                this._toDownload = new Hashtable();
                this._toInstall = new Hashtable();
                if (this.hasGUI()) {
                    this._gui.refresh();
                    this.informInstallFinished(bl);
                    this._gui.setEnabled(true);
                } else {
                    this.informInstallFinished(bl);
                }
            }
        }
    }

    private Collection doPluginsCheckMD5Sum() {
        Vector vector = new Vector();
        return vector;
    }

    private boolean doPluginsInstall() {
        Collection collection = this.doPluginsCheckMD5Sum();
        boolean bl = true;
        int n = 2;
        if (!collection.isEmpty()) {
            Iterator iterator = "<html>MD5 check Failed<br> Some Plugins failed the MD5 check.<br><strong>Options:</strong>Try to install: The plugin mananger will try to install the plugins any way. This option could crash the manager.<br>Remove corrupt plugins: All corrupt files will not be installed. It may cause dependency problems.<br>Abort: Stops the installation. </html>";
            Object object = new Object[]{"Try to install", "Remove corrupt plugins", "Abort"};
            n = JOptionPane.showOptionDialog(this._gui, iterator, "MD5 check Failed", -1, 2, null, object, object[2]);
            bl = false;
            if (n == 1) {
                for (InstallPlugin installPlugin : collection) {
                    this._toInstall.remove(installPlugin.pluginInformation.getName());
                }
                n = 0;
            }
        } else {
            n = 0;
        }
        if (n == 0) {
            this.setCurrentProcessNote("Removing old packages...");
            this.resetCurrentProgressStatus();
            for (Object object : this._toInstall.values()) {
                this.doRemove(object.pluginInformation.getName(), object.pluginInformation.getVersion());
                this.incrementCurrentProcessStatus();
            }
            this.setCurrentProcessNote("Installing new packages...");
            this.resetCurrentProgressStatus();
            for (Object object : this._toInstall.values()) {
                try {
                    this.doInstall((InstallPlugin)object);
                    this.incrementCurrentProcessStatus();
                }
                catch (ZipException zipException) {
                    this.debug("ZipException caught " + zipException.getMessage());
                }
                catch (IOException iOException) {
                    this.debug("IOException caught " + iOException.getMessage());
                }
            }
            this.doActions();
        }
        return bl;
    }

    private void doActions() {
        this.setCurrentProcessNote("Configuring Plugins...");
        this.resetCurrentProgressStatus();
        for (InstallPlugin installPlugin : this._toInstall.values()) {
            Collection collection = installPlugin.pluginInformation.getActions();
            if (collection != null && !collection.isEmpty()) {
                for (Action action : collection) {
                    this.executeAction(action);
                }
            }
            this.incrementCurrentProcessStatus();
        }
        Actions.finished(this._madkitDir);
    }

    private void executeAction(Action action) {
        int n;
        this.println("Executing " + action.getName());
        if (action.shouldAskUser() && (n = JOptionPane.showConfirmDialog(this._gui, action.getQuestionToUser(), "Action Confirmation", 0)) == 1) {
            this.println("Aborting " + action.getName() + " by user request");
            return;
        }
        if (!action.requiredPlugins().isEmpty()) {
            for (String string : action.requiredPlugins()) {
                if (this._list.isInstalled(string, Version.valueOf("0.0.0"))) continue;
                this.println("Action " + action.getName() + " for " + action.getOwnerPlugin() + " requires " + string + " ... Aborting...");
                return;
            }
        }
        if (!action.execute()) {
            JOptionPane.showMessageDialog(this._gui, action.getFailureReason(), "Action Failed", 0);
        }
    }

    private boolean checkDownloadStatus(DownloadFinished downloadFinished) {
        if (downloadFinished.getStatus() == 1) {
            String string = "<html>Downloading : " + downloadFinished.getName() + " Failed.";
            if (downloadFinished.getName().equals("plugins.zip")) {
                string = string + "<br>The Server URL might be incorrect.";
                string = string + "<br>You can select a your server in Settings -> Options -> Change Download Source ";
                string = string + "<br>Remember you must provide a valid email.<br> You Can change it in Settings -> Options -> Settings ";
            }
            string = string + "</html>";
            JOptionPane.showMessageDialog(this._gui, string);
            return false;
        }
        return true;
    }

    private void informInstallFinished(boolean bl) {
        if (bl) {
            Object[] objectArray = new Object[]{"Quit", "Continue"};
            int n = JOptionPane.showOptionDialog(this._gui, "Plugin Installation finished Successfully\nYou will need to quit MadKit for these changes to take effect\nDo you want to quit now? ", "Installation", 0, 3, null, objectArray, objectArray[0]);
            if (n == 0) {
                System.exit(0);
            }
        } else {
            JOptionPane.showMessageDialog(this._gui, "Plugin Installation finished with errors", "Install", 2);
        }
    }

    private boolean checksum(InstallPlugin installPlugin) {
        String string = installPlugin.pluginInformation.getFileMD5Sum();
        if (string == null || installPlugin.file == null) {
            return true;
        }
        this.println(installPlugin.pluginInformation.getName() + ": Checking MD5Sum ... ");
        try {
            boolean bl = Utils.compareMD5(installPlugin.file, string);
            if (bl) {
                this.println("OK");
            } else {
                this.println("Failed");
            }
            return bl;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            this.debug("NoSuchAlgorithmException caught " + noSuchAlgorithmException.getMessage());
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.debug("FileNotFoundException caught " + fileNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            this.debug("IOException caught " + iOException.getMessage());
        }
        this.println("CheckSum for plugin " + installPlugin.pluginInformation.getName() + "did not match");
        return false;
    }

    private void doInstall(InstallPlugin installPlugin) throws ZipException, IOException {
        this.println("Installing " + installPlugin.pluginInformation.getName());
        Vector<String> vector = new Vector<String>();
        if (installPlugin.file != null && installPlugin.file.exists()) {
            File file = new File(this._madkitDir.getAbsolutePath() + installPlugin.pluginInformation.getFileName());
            Utils.copyFile(installPlugin.file, file, true);
            ZipFile zipFile = new ZipFile(file);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                Vector vector2 = this._list.packagesOfFile(zipEntry.getName());
                if (vector2.isEmpty()) {
                    if (zipEntry.isDirectory() || zipEntry.getName().equalsIgnoreCase("info/plugin.xml")) continue;
                    File file2 = new File(this._madkitDir.getAbsolutePath() + File.separatorChar + zipEntry.getName());
                    file2.getParentFile().mkdirs();
                    Utils.copyStream(zipFile.getInputStream(zipEntry), new FileOutputStream(file2));
                    vector.add(zipEntry.getName());
                    continue;
                }
                this.println(installPlugin.pluginInformation.getName() + " trying to overwrite " + zipEntry.getName() + " which belongs to " + vector2.toString());
            }
            zipFile.close();
            file.delete();
        }
        this._list.installPlugin(installPlugin.pluginInformation.getName(), installPlugin.pluginInformation.getVersion(), vector);
    }

    private void doRemove(String string, Version version) {
        this.println("Removing " + string + " ... ");
        if (this._list.installedConstains(string)) {
            Collection collection = this._list.getFilesInstalledPlugin(string);
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                File file = new File(this._madkitDir.getAbsolutePath() + File.separatorChar + (String)iterator.next());
                file.delete();
            }
        }
        Actions.removePlugin(this._madkitDir, string, version);
        this._list.removePlugin(string);
    }

    void installFromBigLocalDistribution(File file) throws SAXException, IOException, ParserConfigurationException, FactoryConfigurationError {
        ZipFile zipFile = new ZipFile(file);
        ZipEntry zipEntry = zipFile.getEntry("plugins.zip");
        PluginList.mergePlugins("localsystem", PluginList.extractFile(zipFile, zipEntry, ManagerAgent.getTempDir()), this.pluginsFile);
        File file2 = new File(this._madkitDir.getAbsolutePath() + File.separatorChar + "cache" + File.separatorChar + "localsystem");
        file2.mkdirs();
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry2 = enumeration.nextElement();
            if (zipEntry2.getName().equals("plugins.zip")) continue;
            file2 = PluginList.extractFile(zipFile, zipEntry2, ManagerAgent.getTempDir());
            Utils.copyFile(file2, new File(this._madkitDir.getAbsolutePath() + File.separatorChar + "cache" + File.separatorChar + "localsystem" + File.separatorChar + zipEntry2.getName()), true);
            file2.delete();
        }
        this.updatePlugins();
    }

    void installLocalFilePlugin(File file) throws ZipException, IOException {
        ZipFile zipFile = new ZipFile(file);
        ZipEntry zipEntry = zipFile.getEntry("info/plugin.xml");
        if (zipEntry == null) {
            JOptionPane.showMessageDialog(this._gui, "Zip File is not a Madkit Plugin", "Install", 0);
            return;
        }
        PluginInformation pluginInformation = PluginInformation.getPluginInformation(PluginList.extractFile(zipFile, zipEntry, ManagerAgent.getTempDir()), null, this._madkitDir);
        InstallPlugin installPlugin = new InstallPlugin(pluginInformation);
        this.doInstall(installPlugin);
    }

    private void startDownlad(PluginInformation pluginInformation) {
        if (pluginInformation.getServerURL().equals("localsystem")) {
            File file = new File(this._madkitDir.getAbsolutePath() + File.separatorChar + "cache" + File.separatorChar + "localsystem" + File.separatorChar + pluginInformation.getFileName());
            this.sendMessage(this.getAddress(), new DownloadFinished(pluginInformation.getName(), file, "localsystem"));
        } else {
            DownloadAgent downloadAgent = new DownloadAgent(pluginInformation, ManagerAgent.getTempDir());
            this.launchAgent((AbstractAgent)downloadAgent, "downloading-" + pluginInformation.getName(), false);
        }
    }

    public void startInstall() {
        System.out.println("hasGUI " + this.hasGUI());
        if (this.hasGUI()) {
            this._gui.setEnabled(false);
        }
        if (this.hasGUI() && this.getAgentWithRole("MadkitUpdate", "updater", "progress") == null) {
            this.launchAgent((AbstractAgent)new ProgressAgent(), "progressAgent", true);
        }
        this.setGlobalProcessMax(this._toDownload.size() * 4);
        this.setCurrentlProcessMax(this._toDownload.size());
        this.setCurrentProcessNote("Downloading Plugins...");
        this.setProcessStatusFinished(false);
        ProcessMonitor processMonitor = new ProcessMonitor(this._gui, this);
        processMonitor.showProgressDialog();
        Enumeration enumeration = this._toDownload.keys();
        for (int i = this.maxDownloads == 0 ? Integer.MAX_VALUE : this.maxDownloads; enumeration.hasMoreElements() && i > 0; --i) {
            String string = (String)enumeration.nextElement();
            InstallPlugin installPlugin = (InstallPlugin)this._toDownload.get(string);
            installPlugin.downloading = true;
            PluginInformation pluginInformation = installPlugin.pluginInformation;
            this.startDownlad(pluginInformation);
        }
    }

    public void markForInstall(String string) {
        InstallPlugin installPlugin = new InstallPlugin(this._list.getPlugin(string));
        installPlugin.dependsOn = -99;
        this._toDownload.put(string, installPlugin);
        this.addDependencies(installPlugin);
        if (this.hasGUI()) {
            this._gui.refresh();
        }
    }

    private boolean addDependencies(InstallPlugin installPlugin) {
        Vector<String> vector = new Vector<String>();
        for (Dependency dependency : installPlugin.pluginInformation.getDependencies()) {
            if (this._list.isInstalled(dependency.name, dependency.version)) continue;
            if (this._list.isAvailable(dependency.name, dependency.version)) {
                vector.add(dependency.name);
                if (this._toDownload.containsKey(dependency.name)) continue;
                this.markForInstall(dependency.name);
                continue;
            }
            if (this.hasGUI()) {
                this._gui.informUnavailablePlugin(dependency.name, dependency.version, installPlugin.pluginInformation.getName());
                continue;
            }
            this.println("PluginInstaller error: Broken Dependency : Plugin " + dependency.name + " version: " + dependency.version + "" + "cannot be found. Need by " + installPlugin.pluginInformation.getName());
        }
        return true;
    }

    private void init() {
        try {
            this.loadConfig();
            this.updatePlugins();
        }
        catch (ZipException zipException) {
            this.debug("ZipException caught " + zipException.getMessage());
            zipException.printStackTrace();
        }
        catch (IOException iOException) {
            this.debug("IOException caught " + iOException.getMessage());
            iOException.printStackTrace();
        }
    }

    private void initFiles() {
        if (ManagerAgent.getTempDir().exists()) {
            ManagerAgent.getTempDir().delete();
        }
        ManagerAgent.getTempDir().mkdirs();
        ManagerAgent.getTempDir().deleteOnExit();
        if (!this._madkitDir.exists() && this.askDirectoryCreation(this._madkitDir)) {
            this._madkitDir.mkdirs();
        }
        File file = new File(this._madkitDir.getAbsolutePath() + File.separatorChar + "cache");
        file.mkdirs();
        this.configFile = new File(file.getAbsolutePath() + File.separatorChar + "pluginmanager.config");
        this.installedFile = new File(file.getAbsolutePath() + File.separatorChar + "installed.xml");
        this.pluginsFile = new File(file.getAbsolutePath() + File.separatorChar + "plugins.zip");
        this.sourcesFile = new File(file.getAbsolutePath() + File.separatorChar + "sources.xml");
    }

    private void updatePlugins() throws ZipException {
        if (this.hasGUI()) {
            this._gui.setRefresingState(true);
        }
        if (!this.pluginsFile.exists()) {
            this.debug("no plugins File found");
            return;
        }
        if (!this.installedFile.exists()) {
            try {
                Utils.writeToFile("<?xml version=\"1.0\"?><plugins></plugins>", new FileOutputStream(this.installedFile));
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
        }
        this.debug("reading plugin list");
        try {
            this._list = new PluginList(ManagerAgent.getTempDir(), this.pluginsFile, this.installedFile);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.debug("plugin list created");
        try {
            this._list.init();
            if (this.hasGUI()) {
                this._gui.setRefresingState(false);
            }
        }
        catch (SAXException sAXException) {
            this.debug("SAXException caught " + sAXException.getMessage());
        }
        catch (IOException iOException) {
            this.debug("IOException caught " + iOException.getMessage());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            this.debug("ParserConfigurationException caught " + parserConfigurationException.getMessage());
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            this.debug("FactoryConfigurationError caught " + factoryConfigurationError.getMessage());
        }
    }

    public static final File getTempDir() {
        if (_tempDir != null) {
            return _tempDir;
        }
        _tempDir = new File(System.getProperty("java.io.tmpdir") + File.separatorChar + "madkitTmp" + new Date().getTime());
        if (!_tempDir.exists()) {
            _tempDir.mkdirs();
        }
        return _tempDir;
    }

    void refreshPluginsFromSources() {
        this._refreshingPlugins = true;
        if (this.hasGUI()) {
            this._gui.setRefresingState(true);
        }
        Vector vector = this.getDownloadSources();
        this._sourcesCount = vector.size();
        for (int i = 0; i < vector.size(); ++i) {
            System.out.println("source : " + vector.elementAt(i));
            DownloadAgent downloadAgent = new DownloadAgent((String)vector.elementAt(i), "plugins.zip", ManagerAgent.getTempDir());
            this.launchAgent((AbstractAgent)downloadAgent, "downloading-plugin-list", false);
        }
    }

    private Vector getDownloadSources() {
        Vector<String> vector = new Vector<String>();
        if (!this.sourcesFile.exists()) {
            this.askDownloadSource();
        }
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(this.sourcesFile);
            NodeList nodeList = document.getElementsByTagName("source");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element = (Element)nodeList.item(i);
                vector.add(element.getAttribute("server"));
            }
        }
        catch (SAXException sAXException) {
            this.debug("SAXException caught " + sAXException.getMessage());
        }
        catch (IOException iOException) {
            this.debug("IOException caught " + iOException.getMessage());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            this.debug("ParserConfigurationException caught " + parserConfigurationException.getMessage());
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            this.debug("FactoryConfigurationError caught " + factoryConfigurationError.getMessage());
        }
        return vector;
    }

    void askDownloadSource() {
        Object object;
        String string = null;
        if (this._downloadServer != null) {
            string = this._downloadServer;
        } else if (this.sourcesFile.exists()) {
            object = this.getDownloadSources();
            string = (String)((Vector)object).firstElement();
        } else {
            string = "http://www.madkit.net/plugins/";
        }
        object = JOptionPane.showInputDialog(new JFrame(), "Enter the Download Site.\r (e.g. \"http://www.madkit.net/plugins/\")", string);
        if (object == null) {
            return;
        }
        this.setDownloadSource((String)object);
    }

    void setDownloadSource(String string) {
        this._downloadServer = string;
        try {
            Utils.writeToFile("<?xml version=\"1.0\"?><sources><source server=\"" + string + "\"/></sources>", new FileOutputStream(this.sourcesFile));
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.debug("FileNotFoundException caught " + fileNotFoundException.getMessage());
        }
    }

    private void loadConfig(File file) throws FileNotFoundException, IOException {
        boolean bl = false;
        if (this._configuration == null) {
            this._configuration = new Properties();
            bl = true;
        }
        if (file.exists()) {
            this._configuration.load(new FileInputStream(file));
        } else {
            this._configuration.setProperty("http.proxyHost", this._configuration.getProperty("http.proxyHost", ""));
            this._configuration.setProperty("http.proxyPort", this._configuration.getProperty("http.proxyPort", "8080"));
            this._configuration.setProperty("madkit.user.name", this._configuration.getProperty("madkit.user.name", ""));
            this._configuration.setProperty("madkit.user.email", this._configuration.getProperty("madkit.user.email", ""));
            this.saveConfig(file);
            if (bl && this.hasGUI()) {
                this._gui.changeSettings();
            }
        }
        System.setProperty("http.proxyHost", this._configuration.getProperty("http.proxyHost"));
        System.setProperty("http.proxyPort", this._configuration.getProperty("http.proxyPort"));
        System.setProperty("madkit.user.name", this._configuration.getProperty("madkit.user.name"));
        System.setProperty("madkit.user.email", this._configuration.getProperty("madkit.user.email"));
    }

    private void saveConfig(File file) throws FileNotFoundException, IOException {
        this._configuration.store(new FileOutputStream(file), "Plugin Manager Config File, please do not edit");
    }

    void saveConfig() {
        try {
            this.saveConfig(this.configFile);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.debug("FileNotFoundException caught " + fileNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            this.debug("IOException caught " + iOException.getMessage());
        }
    }

    void loadConfig() {
        try {
            this.loadConfig(this.configFile);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.debug("FileNotFoundException caught " + fileNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            this.debug("IOException caught " + iOException.getMessage());
        }
    }

    private boolean askDirectoryCreation(File file) {
        int n = JOptionPane.showConfirmDialog(new JFrame(), "The directory does not exist. Do you want to create it?", "Create directory", 2);
        return n == 0;
    }

    private void checkForLoginInfo() {
        if (System.getProperty("madkit.user.name") == null) {
            this.changeLoginInformation();
        } else if (System.getProperty("madkit.user.email") == null) {
            this.changeLoginInformation();
        }
    }

    private void checkForNewPluginManager() {
        if (this._list.status("pluginmanager") == 1) {
            String string = "New Plugin Manager Version Available\n";
            string = string + "It is recommended to update to the new version before installing or upgrading other plugins\n";
            string = string + "Do you want to update the Plugin Manager?\n";
            int n = JOptionPane.showConfirmDialog(this._gui, string = string + "Note that you will have to quit and restart MadKit to use the new manager", "New Plugin Manager Version", 0);
            if (n == 0) {
                this.markForInstall("pluginmanager");
                this.startInstall();
            }
        } else {
            this.println("no new version");
        }
    }

    private void changeLoginInformation() {
        if (this.hasGUI()) {
            this._gui.changeSettings();
        }
    }

    public void activate() {
        this.createGroup(false, "MadkitUpdate", "updater", null, null);
        this.requestRole("MadkitUpdate", "updater", "pluginManagerAgent", null);
        this.init();
        System.out.println(">>>> manager init done");
    }

    public void end() {
        try {
            this.sendMessage(this.getAgentWithRole("MadkitUpdate", "updater", "progress"), (Message)new StringMessage(String.valueOf(true)));
            this.saveConfig(this.configFile);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.debug("FileNotFoundException caught " + fileNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            this.debug("IOException caught " + iOException.getMessage());
        }
        this.println("Stopping plugin manager agent");
    }

    public void initGUI() {
        this._gui = new ManagerGUI(this);
        this.setGUIObject(this._gui);
    }

    void showDetails(String string) {
        DetailsAgent detailsAgent = new DetailsAgent(this._list.getPlugin(string));
        this.launchAgent((AbstractAgent)detailsAgent, "Details-" + string, true);
    }

    public void removeFromInstall(String string) {
        this._toDownload.remove(string);
    }

    public void upgrade() {
        Enumeration enumeration = this._list.getPluginNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (this._list.status(string) != 1) continue;
            this.markForInstall(string);
        }
        if (this.hasGUI()) {
            this._gui.refresh();
        }
    }

    public String getGlobalProcessNote() {
        return "Global Install Status";
    }

    public String getCurrentProcessNote() {
        if (this._noteCurr == null) {
            this._noteCurr = "";
        }
        return this._noteCurr;
    }

    public int getGlobalProcessStatus() {
        return this._statusGlob;
    }

    public int getCurrentProcessStatus() {
        return this._statusCurr;
    }

    public int getGlobalProcessMax() {
        return this._maxGlobal;
    }

    public int getCurrentProcessMax() {
        return this._maxCurrent;
    }

    public boolean isGlobalProcessFinished() {
        return this._processFinished;
    }

    private void setCurrentProcessNote(String string) {
        this._noteCurr = string;
    }

    private void setGlobalProcessMax(int n) {
        this._maxGlobal = n;
    }

    private void setCurrentlProcessMax(int n) {
        this._maxCurrent = n;
    }

    private void incrementCurrentProcessStatus() {
        ++this._statusCurr;
        ++this._statusGlob;
    }

    private void resetCurrentProgressStatus() {
        this._statusCurr = 0;
    }

    private void setProcessStatusFinished(boolean bl) {
        this._processFinished = bl;
    }

    public void setFullInstallRequest() {
        this._fullInstallRequested = true;
    }
}

