/*
 * Decompiled with CFR 0.152.
 */
package warbot.demo;

import warbot.kernel.Brain;
import warbot.kernel.Food;
import warbot.kernel.Percept;

public class RastaRocket
extends Brain {
    public void activate() {
        this.randomHeading();
        this.println("I am a rasta rocket robot");
        this.println("I am heading ".concat(String.valueOf(String.valueOf(this.getHeading()))));
    }

    public void doIt() {
        Percept[] detectedEntities;
        if (!this.isMoving()) {
            this.randomHeading();
        }
        if ((detectedEntities = this.getPercepts()).length > 0) {
            for (int i = 0; i < detectedEntities.length; ++i) {
                Percept e = detectedEntities[i];
                if (e.getPerceptType().equals("Home") && !e.getTeam().equals(this.getTeam())) {
                    this.launchRocket(this.towards(e.getX(), e.getY()));
                    return;
                }
                if (!e.getPerceptType().equals("RocketLauncher") && !e.getPerceptType().equals("Explorer") || e.getTeam().equals(this.getTeam())) continue;
                this.launchRocket(this.towards(e.getX(), e.getY()));
                return;
            }
        }
        int min = 0;
        for (int i = 0; i < detectedEntities.length; ++i) {
            Percept e = detectedEntities[i];
            if (!(this.distanceTo(e) < this.distanceTo(detectedEntities[min])) || !e.getPerceptType().equals("Food")) continue;
            min = i;
        }
        if (detectedEntities.length > 0 && detectedEntities[min].getPerceptType().equals("Food")) {
            if (this.distanceTo(detectedEntities[min]) < (double)2) {
                this.eat((Food)detectedEntities[min]);
                return;
            }
            this.setHeading(this.towards(detectedEntities[min].getX(), detectedEntities[min].getY()));
            this.move();
            return;
        }
        this.move();
    }
}

