/*
 * Decompiled with CFR 0.152.
 */
package madkit.desktop2;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import madkit.desktop2.PropertyEdit;
import madkit.desktop2.PropertyScreen;
import madkit.desktop2.PropertyView;

public class PropertyPane
extends JPanel
implements ActionListener {
    JButton apply;
    JButton ok;
    JButton cancel;
    PropertyView propertyView;
    PropertyEdit propertyEdit;
    PropertyScreen propertyScreen;

    public PropertyPane(PropertyView propertyView, int n, int n2) {
        super(new BorderLayout());
        this.propertyView = propertyView;
        JPanel jPanel = new JPanel();
        this.ok = new JButton("Ok");
        this.ok.addActionListener(this);
        jPanel.add(this.ok);
        this.cancel = new JButton("Cancel");
        this.cancel.addActionListener(this);
        jPanel.add(this.cancel);
        this.apply = new JButton("Apply");
        this.apply.addActionListener(this);
        this.apply.setEnabled(false);
        jPanel.add(this.apply);
        this.add((Component)jPanel, "South");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        this.propertyEdit = new PropertyEdit(this);
        jPanel2.setBorder(BorderFactory.createLineBorder(Color.black, 2));
        this.propertyScreen = propertyView.getWallpaperPath() == null || propertyView.getWallpaperPath().equals("") ? new PropertyScreen(this, n, n2, false) : new PropertyScreen(this, n, n2, true);
        jPanel2.add((Component)this.propertyScreen, "Center");
        jPanel2.add((Component)this.propertyEdit, "South");
        this.add((Component)jPanel2, "Center");
        this.add((Component)new JPanel(), "North");
        this.add((Component)new JPanel(), "East");
        this.add((Component)new JPanel(), "West");
    }

    public Dimension getPreferredSize() {
        return new Dimension(350, 350);
    }

    public void setScreenSize(int n, int n2) {
        this.propertyScreen.setScreenSize(n, n2);
    }

    public Color getBackgroundColor() {
        return this.propertyView.getBackgroundColor();
    }

    public String getWallpaperPath() {
        return this.propertyView.getWallpaperPath();
    }

    public String getWallpaperPos() {
        return this.propertyView.getWallpaperPos();
    }

    public boolean getSkinUse() {
        return this.propertyView.getSkinUse();
    }

    public void setSkinUse(boolean bl) {
        this.propertyView.setSkinUse(bl);
    }

    public String getSkinTheme() {
        return this.propertyView.getSkinTheme();
    }

    public void setSkinTheme(String string) {
        this.propertyView.setSkinTheme(string);
    }

    public void apply() {
        this.propertyView.setBackgroundColor(this.propertyEdit.getColor());
        this.propertyView.setWallpaperPath(this.propertyEdit.getPath());
        this.propertyView.setWallpaperPos(this.propertyEdit.getPos());
    }

    public void enableApply() {
        if (this.propertyView.getBackgroundColor().equals(this.propertyEdit.getColor()) && this.propertyView.getWallpaperPath().equals(this.propertyEdit.getPath()) && this.propertyView.getWallpaperPos().equals(this.propertyEdit.getPos())) {
            this.apply.setEnabled(false);
        } else {
            this.apply.setEnabled(true);
        }
    }

    public void setColor(Color color) {
        this.propertyEdit.setColor(color);
        this.propertyScreen.setColor(color);
        this.enableApply();
    }

    public void setWallpaper(File file) {
        this.propertyEdit.setWallpaper(file.getPath());
        this.propertyScreen.setWallpaper(file.getPath());
        this.enableApply();
    }

    public void setWallpaperPos(String string) {
        this.propertyScreen.setWallpaperPos(string);
        this.enableApply();
    }

    public void setUseWallpaper(boolean bl) {
        this.propertyScreen.setUseWallpaper(bl);
        this.enableApply();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.ok) {
            this.apply();
            this.propertyView.closeProperty();
        } else if (object == this.apply) {
            this.apply();
            this.enableApply();
        } else if (object == this.cancel) {
            this.propertyView.closeProperty();
        }
    }
}

