/*
 * Decompiled with CFR 0.152.
 */
package madkit.desktop2;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import madkit.desktop2.AgentInfo;
import madkit.desktop2.AgentJFrame;
import madkit.desktop2.CascadeWindow;
import madkit.desktop2.Desktop;
import madkit.desktop2.DesktopAgentGUI;
import madkit.desktop2.IconInfo;
import madkit.desktop2.MenuInfo;
import madkit.desktop2.MenuItemInfo;
import madkit.desktop2.PropertyDesktop;
import madkit.desktop2.StartMenu;
import madkit.desktop2.WindowManager;

public class DesktopWithoutContainer
implements Desktop,
WindowListener {
    protected HashMap frames = new HashMap();
    protected AgentInfo ai;
    protected StartMenu startMenu;
    protected JFrame frame;
    protected DesktopAgentGUI desktopAgentGUI;
    protected boolean bool = true;
    protected WindowManager wm = new CascadeWindow(this);

    public void init(AgentInfo agentInfo, LinkedList linkedList, DesktopAgentGUI desktopAgentGUI) {
        this.ai = agentInfo;
        this.desktopAgentGUI = desktopAgentGUI;
        this.startMenu = new StartMenu();
        this.createStartMenu(linkedList);
        this.frame = new JFrame("MadKit");
        this.frame.getContentPane().setLayout(new BorderLayout());
        this.frame.getContentPane().add((Component)this.startMenu, "Center");
        this.frame.pack();
        this.frame.addWindowListener(this);
        URL uRL = this.getClass().getResource("/images/madkit_logo32.gif");
        this.frame.setIconImage(new ImageIcon(uRL).getImage());
        if (agentInfo.getLocation().getX() == -1.0 && agentInfo.getLocation().getY() == -1.0) {
            this.frame.setLocation(0, 0);
            this.startMenu.setOrientation("South");
        } else if (this.startMenu.getOrientation().equals("North")) {
            this.frame.setLocation(agentInfo.getLocation());
        } else if (this.startMenu.getOrientation().equals("West")) {
            this.frame.setLocation(agentInfo.getLocation());
        } else if (this.startMenu.getOrientation().equals("East")) {
            this.frame.setLocation((int)(agentInfo.getLocation().getX() + agentInfo.getSize().getWidth() - this.frame.getSize().getWidth()), (int)agentInfo.getLocation().getY());
        } else if (this.startMenu.getOrientation().equals("South")) {
            this.frame.setLocation((int)agentInfo.getLocation().getX(), (int)(agentInfo.getLocation().getY() + agentInfo.getSize().getHeight() - this.frame.getSize().getHeight()));
        }
    }

    public int getHeight() {
        return (int)Toolkit.getDefaultToolkit().getScreenSize().getHeight();
    }

    public int getWidth() {
        return (int)Toolkit.getDefaultToolkit().getScreenSize().getWidth();
    }

    protected void createStartMenu(LinkedList linkedList) {
        for (MenuInfo menuInfo : linkedList) {
            JMenu jMenu = new JMenu(menuInfo.getName());
            String string = menuInfo.getIcon();
            if (string != null) {
                try {
                    jMenu.setIcon(new ImageIcon(this.getClass().getResource(string)));
                }
                catch (Exception exception) {
                    System.out.println("Icon: " + string + " not found");
                }
            }
            this.addToStartMenu(jMenu, menuInfo);
            this.startMenu.addMenuItem(jMenu);
        }
    }

    protected void addToStartMenu(JMenu jMenu, MenuInfo menuInfo) {
        String string;
        JMenuItem jMenuItem;
        for (Object object : menuInfo.getMenuInfo()) {
            jMenuItem = new JMenu(((MenuInfo)object).getName());
            string = ((MenuInfo)object).getIcon();
            if (string != null) {
                try {
                    jMenuItem.setIcon(new ImageIcon(this.getClass().getResource(string)));
                }
                catch (Exception exception) {
                    System.out.println("Icon: " + string + " not found");
                }
            }
            this.addToStartMenu((JMenu)jMenuItem, (MenuInfo)object);
            this.startMenu.addMenuItem(jMenu);
            jMenu.add(jMenuItem);
        }
        for (Object object : menuInfo.getMenuItemInfo()) {
            jMenuItem = new JMenuItem(((MenuItemInfo)object).getName());
            string = ((MenuItemInfo)object).getIcon();
            if (string != null) {
                try {
                    jMenuItem.setIcon(new ImageIcon(this.getClass().getResource(string)));
                }
                catch (Exception exception) {
                    System.out.println("Icon: " + string + " not found");
                }
            }
            if (!this.desktopAgentGUI.addListenerTo((MenuItemInfo)object, jMenuItem)) continue;
            jMenu.add(jMenuItem);
        }
    }

    public void addMenuSystem(JMenuItem jMenuItem) {
        if (this.bool) {
            this.startMenu.addSeparator();
            this.bool = false;
        }
        this.startMenu.addMenuItem(jMenuItem);
    }

    public void addIcon(IconInfo iconInfo) {
    }

    public void removeIcon(IconInfo iconInfo) {
    }

    public void setProperty(PropertyDesktop propertyDesktop) {
    }

    public void toFront(Component component) {
        if (component instanceof JFrame) {
            ((JFrame)component).toFront();
        }
    }

    public void toBack(Component component) {
        if (component instanceof JFrame) {
            ((JFrame)component).toBack();
        }
    }

    public void addComponent(AgentInfo agentInfo, Component component) {
        AgentJFrame agentJFrame = new AgentJFrame(agentInfo, agentInfo.getAgent().getName(), component);
        this.wm.addComponent(agentJFrame);
        if (agentInfo.getLocation().getX() == -1.0 && agentInfo.getLocation().getY() == -1.0) {
            this.wm.orderComponent(agentJFrame);
        }
        this.frames.put(component, agentJFrame);
        agentJFrame.show();
    }

    public void removeComponent(Component component) {
        Object v = this.frames.get(component);
        if (v != null) {
            this.wm.removeComponent((Component)v);
            this.frames.remove(component);
            ((JFrame)v).dispose();
        }
    }

    public void dispose() {
        Iterator iterator = this.frames.keySet().iterator();
        while (iterator.hasNext()) {
            Component component = (Component)iterator.next();
            Object v = this.frames.get(component);
            if (v != null) {
                ((AgentJFrame)v).updateAgentInfo();
                ((AgentJFrame)v).setAgentInfo(null);
                ((AgentJFrame)v).dispose();
            }
            iterator.remove();
        }
        this.frame.getContentPane().remove(this.startMenu);
        this.frame.dispose();
    }

    public Component getTopComponent() {
        return this.frame;
    }

    public void show() {
        this.frame.setVisible(true);
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.desktopAgentGUI.quitMadkit();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

