/*
 * Decompiled with CFR 0.152.
 */
package madkit.desktop2;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.ImageIcon;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import madkit.desktop2.AgentInfo;
import madkit.desktop2.BeanShellAgentButton;
import madkit.desktop2.CascadeWindow;
import madkit.desktop2.Desktop;
import madkit.desktop2.DesktopAgentGUI;
import madkit.desktop2.DesktopBar;
import madkit.desktop2.DesktopBooter;
import madkit.desktop2.DesktopIcon;
import madkit.desktop2.DesktopIconAdder;
import madkit.desktop2.DesktopProperty;
import madkit.desktop2.DesktopWithBar;
import madkit.desktop2.IconAdderFrame;
import madkit.desktop2.IconInfo;
import madkit.desktop2.InternalAgentFrame;
import madkit.desktop2.JavaAgentButton;
import madkit.desktop2.JessAgentButton;
import madkit.desktop2.MenuInfo;
import madkit.desktop2.MenuItemInfo;
import madkit.desktop2.MonJDesktopPane;
import madkit.desktop2.MonMenuItem;
import madkit.desktop2.PropertyDesktop;
import madkit.desktop2.PropertyFrame;
import madkit.desktop2.PythonAgentButton;
import madkit.desktop2.SEditFileButton;
import madkit.desktop2.SEditFormalismButton;
import madkit.desktop2.SchemeAgentButton;
import madkit.desktop2.StartMenu;
import madkit.desktop2.WindowManager;
import madkit.kernel.AbstractAgent;
import madkit.kernel.AbstractMadkitBooter;
import madkit.kernel.AgentLauncher;
import madkit.system.property.PropertyAgent;
import madkit.utils.graphics.GraphicUtils;

public abstract class DesktopMDI
implements Desktop,
DesktopProperty,
DesktopIconAdder,
WindowListener,
DesktopWithBar,
ActionListener,
ComponentListener,
MouseListener {
    protected HashMap internalFrames = new HashMap();
    protected HashMap icons = new HashMap();
    protected AgentInfo ai;
    protected MonJDesktopPane desktop = new MonJDesktopPane();
    protected StartMenu startMenu;
    protected DesktopBar dBar;
    protected JPanel bar;
    protected PropertyDesktop propertyDesktop;
    protected PropertyFrame propertyFrame;
    protected JPopupMenu popupMenu;
    protected JMenuItem property;
    protected JMenuItem output;
    protected JMenuItem addIcon;
    protected JMenuItem reorder;
    protected DesktopAgentGUI desktopAgentGUI;
    protected JInternalFrame madkitOutputFrame;
    protected boolean bool;
    protected WindowManager wm;

    public DesktopMDI() {
        this.desktop.addComponentListener(this);
        this.desktop.addMouseListener(this);
        this.wm = new CascadeWindow(this);
        this.bool = true;
        this.popupMenu = new JPopupMenu();
        this.property = this.popupMenu.add("Desktop property");
        this.property.addActionListener(this);
        this.output = this.popupMenu.add("Desktop output");
        this.output.addActionListener(this);
        this.addIcon = this.popupMenu.add("Add icon");
        this.addIcon.addActionListener(this);
        this.popupMenu.addSeparator();
        this.reorder = this.popupMenu.add("Re order windows");
        this.reorder.addActionListener(this);
    }

    public void init(AgentInfo agentInfo, LinkedList linkedList, DesktopAgentGUI desktopAgentGUI) {
        this.ai = agentInfo;
        this.desktopAgentGUI = desktopAgentGUI;
        this.startMenu = new StartMenu();
        this.createStartMenu(linkedList);
        this.bar = new JPanel(new BorderLayout());
        this.bar.add((Component)this.startMenu, "West");
        this.dBar = new DesktopBar(this, this.startMenu);
        this.bar.add((Component)this.dBar, "Center");
    }

    public int getHeight() {
        return this.desktop.getHeight();
    }

    public int getWidth() {
        return this.desktop.getWidth();
    }

    public void toFront(Component component) {
        if (component instanceof JInternalFrame) {
            ((JInternalFrame)component).toFront();
        }
    }

    public void toBack(Component component) {
        if (component instanceof JInternalFrame) {
            ((JInternalFrame)component).toBack();
        }
    }

    protected void createStartMenu(LinkedList linkedList) {
        for (MenuInfo menuInfo : linkedList) {
            JMenu jMenu = new JMenu(menuInfo.getName());
            String string = menuInfo.getIcon();
            if (string != null) {
                try {
                    jMenu.setIcon(new ImageIcon(this.getClass().getResource(string)));
                }
                catch (Exception exception) {
                    System.out.println("Icon: " + string + " not found");
                }
            }
            this.addToStartMenu(jMenu, menuInfo);
            this.startMenu.addMenuItem(jMenu);
        }
    }

    protected void addToStartMenu(JMenu jMenu, MenuInfo menuInfo) {
        String string;
        JMenuItem jMenuItem;
        for (Object object : menuInfo.getMenuInfo()) {
            jMenuItem = new JMenu(((MenuInfo)object).getName());
            string = ((MenuInfo)object).getIcon();
            if (string != null) {
                try {
                    jMenuItem.setIcon(new ImageIcon(this.getClass().getResource(string)));
                }
                catch (Exception exception) {
                    System.out.println("Icon: " + string + " not found");
                }
            }
            this.addToStartMenu((JMenu)jMenuItem, (MenuInfo)object);
            this.startMenu.addMenuItem(jMenu);
            jMenu.add(jMenuItem);
        }
        for (Object object : menuInfo.getMenuItemInfo()) {
            jMenuItem = new JMenuItem(((MenuItemInfo)object).getName());
            string = ((MenuItemInfo)object).getIcon();
            if (string != null) {
                try {
                    jMenuItem.setIcon(new ImageIcon(this.getClass().getResource(string)));
                }
                catch (Exception exception) {
                    System.out.println("Icon: " + string + " not found");
                }
            }
            if (!this.desktopAgentGUI.addListenerTo((MenuItemInfo)object, jMenuItem)) continue;
            jMenu.add(jMenuItem);
        }
    }

    public void addMenuSystem(JMenuItem jMenuItem) {
        if (this.bool) {
            this.startMenu.addSeparator();
            this.bool = false;
        }
        this.startMenu.addMenuItem(jMenuItem);
    }

    public Color getBackgroundColor() {
        if (this.propertyDesktop.getDesktopColor() == null) {
            return this.desktop.getBackground();
        }
        return this.propertyDesktop.getDesktopColor();
    }

    public String getWallpaperPath() {
        return this.propertyDesktop.getWallpaperPath();
    }

    public String getWallpaperPos() {
        return this.propertyDesktop.getWallpaperPos();
    }

    public boolean getSkinUse() {
        return this.propertyDesktop.getSkinUse();
    }

    public void setSkinUse(boolean bl) {
        this.propertyDesktop.setSkinUse(bl);
    }

    public String getSkinTheme() {
        return this.propertyDesktop.getSkinTheme();
    }

    public void setSkinTheme(String string) {
        this.propertyDesktop.setSkinTheme(string);
    }

    public void setBackgroundColor(Color color) {
        this.desktop.setBackground(color);
        this.propertyDesktop.setDesktopColor(color);
    }

    public void setWallpaperPath(String string) {
        this.propertyDesktop.setWallpaperPath(string);
        this.desktop.setWallpaper(this.propertyDesktop.getWallpaperPath());
    }

    public void setWallpaperPos(String string) {
        this.propertyDesktop.setWallpaperPos(string);
        this.desktop.setWallpaperPos(this.propertyDesktop.getWallpaperPos());
    }

    public int getScreenWidth() {
        return this.desktop.getWidth();
    }

    public int getScreenHeight() {
        return this.desktop.getHeight();
    }

    public void addIcon(IconInfo iconInfo) {
        DesktopIcon desktopIcon = new DesktopIcon();
        MonMenuItem monMenuItem = new MonMenuItem("Icon property", iconInfo);
        monMenuItem.setActionCommand("IconProperty");
        monMenuItem.addActionListener(this);
        desktopIcon.addMenuItem(monMenuItem);
        monMenuItem = new MonMenuItem("Delete icon", iconInfo);
        monMenuItem.setActionCommand("DelIcon");
        monMenuItem.addActionListener(this);
        desktopIcon.addMenuItem(monMenuItem);
        if (iconInfo.getIcon() != null) {
            try {
                desktopIcon.setIcon(new ImageIcon(this.getClass().getResource(iconInfo.getIcon())));
            }
            catch (Exception exception) {
                System.out.println("Icon: " + iconInfo.getIcon() + " not found");
            }
        }
        if (iconInfo.getLabel() != null) {
            desktopIcon.setLabel(iconInfo.getLabel());
        }
        if (iconInfo.getDescription() != null) {
            desktopIcon.setToolTipText(iconInfo.getDescription());
        }
        desktopIcon.setLocation(iconInfo.getX(), iconInfo.getY());
        if (iconInfo.getType() != null && iconInfo.getCode() != null) {
            if (iconInfo.getType().equalsIgnoreCase("Java")) {
                desktopIcon.addActionListener(new JavaAgentButton(this.ai.getAgent(), iconInfo.getCode(), iconInfo.getGUI()));
            } else if (iconInfo.getType().equalsIgnoreCase("Scheme")) {
                desktopIcon.addActionListener(new SchemeAgentButton(this.ai.getAgent(), iconInfo.getCode(), iconInfo.getGUI()));
            } else if (iconInfo.getType().equalsIgnoreCase("Jess")) {
                desktopIcon.addActionListener(new JessAgentButton(this.ai.getAgent(), iconInfo.getCode(), iconInfo.getGUI()));
            } else if (iconInfo.getType().equalsIgnoreCase("Python")) {
                desktopIcon.addActionListener(new PythonAgentButton(this.ai.getAgent(), iconInfo.getCode(), iconInfo.getGUI()));
            } else if (iconInfo.getType().equalsIgnoreCase("BeanShell")) {
                desktopIcon.addActionListener(new BeanShellAgentButton(this.ai.getAgent(), iconInfo.getCode(), iconInfo.getGUI()));
            } else if (iconInfo.getType().equalsIgnoreCase("SEditFormalism")) {
                desktopIcon.addActionListener(new SEditFormalismButton(this.ai.getAgent(), iconInfo.getCode(), iconInfo.getGUI()));
            } else if (iconInfo.getType().equalsIgnoreCase("SEditFile")) {
                desktopIcon.addActionListener(new SEditFileButton(this.ai.getAgent(), iconInfo.getCode(), iconInfo.getGUI()));
            }
        }
        this.icons.put(iconInfo, desktopIcon);
        this.desktop.add(desktopIcon);
        desktopIcon.show();
    }

    public void removeIcon(IconInfo iconInfo) {
        DesktopIcon desktopIcon = (DesktopIcon)this.icons.get(iconInfo);
        if (iconInfo != null) {
            this.desktop.remove(desktopIcon);
            this.icons.remove(desktopIcon);
            this.desktop.repaint();
        }
    }

    public void setProperty(PropertyDesktop propertyDesktop) {
        this.propertyDesktop = propertyDesktop;
        if (propertyDesktop.getDesktopColor() != null) {
            this.desktop.setBackground(propertyDesktop.getDesktopColor());
        }
        if (propertyDesktop.getWallpaperPath() != null && !propertyDesktop.getWallpaperPath().equals("")) {
            this.desktop.setWallpaper(propertyDesktop.getWallpaperPath());
        }
        if (propertyDesktop.getWallpaperPos() != null) {
            this.desktop.setWallpaperPos(propertyDesktop.getWallpaperPos());
        }
    }

    public void addComponent(AgentInfo agentInfo, Component component) {
        InternalAgentFrame internalAgentFrame = new InternalAgentFrame(agentInfo, agentInfo.getAgent().getName(), component);
        this.wm.addComponent(internalAgentFrame);
        if (agentInfo.getLocation().getX() == -1.0 && agentInfo.getLocation().getY() == -1.0) {
            this.wm.orderComponent(internalAgentFrame);
        }
        this.internalFrames.put(component, internalAgentFrame);
        this.desktop.add(internalAgentFrame);
        MonMenuItem monMenuItem = new MonMenuItem("Agent Property", agentInfo.getAgent());
        monMenuItem.setActionCommand("property");
        monMenuItem.addActionListener(this);
        this.dBar.addButtonBar(internalAgentFrame).addMenuItem(monMenuItem);
        internalAgentFrame.show();
    }

    public void removeComponent(Component component) {
        Object v = this.internalFrames.get(component);
        if (v != null) {
            this.wm.removeComponent((Component)v);
            this.internalFrames.remove(component);
            ((JInternalFrame)v).dispose();
        }
    }

    public void dispose() {
        Object object;
        Iterator iterator = this.internalFrames.keySet().iterator();
        while (iterator.hasNext()) {
            Object object2 = (Component)iterator.next();
            object = this.internalFrames.get(object2);
            if (object != null) {
                ((InternalAgentFrame)object).updateAgentInfo();
                ((InternalAgentFrame)object).setAgentInfo(null);
                ((InternalAgentFrame)object).dispose();
            }
            iterator.remove();
        }
        for (Object object2 : this.icons.keySet()) {
            object = (DesktopIcon)this.icons.get(object2);
            this.saveIconState((IconInfo)object2, (DesktopIcon)object);
        }
    }

    protected void saveIconState(IconInfo iconInfo, DesktopIcon desktopIcon) {
        iconInfo.setX((int)desktopIcon.getLocation().getX());
        iconInfo.setY((int)desktopIcon.getLocation().getY());
    }

    public void removePropertyFrame() {
        this.propertyFrame = null;
    }

    public void removeIconAdderFrame(JInternalFrame jInternalFrame) {
        this.desktop.remove(jInternalFrame);
        this.desktop.repaint();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        if (object == this.property) {
            if (this.propertyFrame == null) {
                this.propertyFrame = new PropertyFrame(this);
                this.desktop.add(this.propertyFrame);
                this.wm.addComponent(this.propertyFrame);
                this.wm.orderComponent(this.propertyFrame);
                this.propertyFrame.show();
            } else {
                try {
                    this.propertyFrame.setSelected(true);
                }
                catch (Exception exception) {
                    exception.printStackTrace(System.err);
                }
            }
        } else if (object == this.output) {
            AgentLauncher agentLauncher = AgentLauncher.makeAgentLauncher((String)"madkit.kernel.JavaAgentLauncher", (AbstractMadkitBooter)AbstractMadkitBooter.getBooter(), null, (String)"madkit.system.MadkitOutput", (String)"MadkitOutput", null, null, (boolean)true, (Point)new Point(300, 400), (Dimension)new Dimension(600, 200));
            agentLauncher.launch();
        } else if (object == this.addIcon) {
            IconAdderFrame iconAdderFrame = new IconAdderFrame(this, null);
            iconAdderFrame.pack();
            iconAdderFrame.setMinimumSize(iconAdderFrame.getSize());
            iconAdderFrame.show();
            this.desktop.add(iconAdderFrame);
        } else if (object == this.reorder) {
            this.wm.reOrderAllComponent();
        } else if (object instanceof MonMenuItem) {
            Object object2 = ((MonMenuItem)object).getObject();
            if (object2 instanceof IconInfo) {
                if (((MonMenuItem)object).getActionCommand().equals("IconProperty")) {
                    IconAdderFrame iconAdderFrame = new IconAdderFrame(this, (IconInfo)object2);
                    iconAdderFrame.pack();
                    iconAdderFrame.setMinimumSize(iconAdderFrame.getSize());
                    iconAdderFrame.show();
                    this.desktop.add(iconAdderFrame);
                } else if (((MonMenuItem)object).getActionCommand().equals("DelIcon")) {
                    this.desktopAgentGUI.removeIcon((IconInfo)object2);
                }
            } else if (string.equals("property") && object2 instanceof AbstractAgent) {
                PropertyAgent propertyAgent = new PropertyAgent((AbstractAgent)object2);
                String string2 = DesktopBooter.getAgentLabelFromClassName((String)propertyAgent.getClass().getName());
                this.ai.getAgent().launchAgent((AbstractAgent)propertyAgent, string2, true);
            }
        }
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        Object object = componentEvent.getSource();
        if (object == this.desktop && this.propertyFrame != null) {
            this.propertyFrame.setScreenSize(this.desktop.getWidth(), this.desktop.getHeight());
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (GraphicUtils.isPopupTrigger((MouseEvent)mouseEvent)) {
            this.popupMenu.show(this.desktop, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.desktopAgentGUI.quitMadkit();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void addNewIcon(IconInfo iconInfo) {
        this.desktopAgentGUI.addIcon(iconInfo);
    }

    public void IconChanged(IconInfo iconInfo) {
        DesktopIcon desktopIcon = (DesktopIcon)this.icons.get(iconInfo);
        if (desktopIcon != null) {
            this.saveIconState(iconInfo, desktopIcon);
            this.desktop.remove(desktopIcon);
            this.addIcon(iconInfo);
            this.desktop.repaint();
        }
    }

    public abstract Component getTopComponent();

    public abstract boolean setBarOrientation(String var1);

    public abstract void show();
}

