/*
 * Decompiled with CFR 0.152.
 */
package madkit.desktop2;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import madkit.desktop2.IconAdder;
import madkit.desktop2.IconInfo;
import madkit.desktop2.ImageViewer;
import madkit.desktop2.RessourceInfo;

public class AddDesktopIcon
extends JPanel
implements ChangeListener,
ActionListener {
    protected String[] iconTypes = new String[]{"java", "Scheme", "Python", "Jess", "BeanShell", "SEditFormalism", "SEditFile"};
    protected ImageViewer images = new ImageViewer();
    protected JTextField imagePath;
    protected JTextField imageJar;
    protected JTextField imageDim;
    protected JTextField iconLabel;
    protected JTextField iconDesc;
    protected JTextField iconCode;
    protected JComboBox iconType;
    protected JComboBox iconGUI;
    protected JButton ok;
    protected JButton cancel;
    protected JButton scroll;
    protected IconAdder iconAdder;
    protected IconInfo iconInfo;

    public AddDesktopIcon(IconAdder iconAdder) {
        super(new BorderLayout());
        this.images.addChangeListener(this);
        this.add((Component)this.images, "Center");
        this.iconAdder = iconAdder;
        this.imagePath = new JTextField("", 25);
        this.imagePath.setEditable(false);
        this.imageJar = new JTextField("", 18);
        this.imageJar.setEditable(false);
        this.imageDim = new JTextField("", 8);
        this.imageDim.setEditable(false);
        this.iconLabel = new JTextField("", 15);
        this.iconDesc = new JTextField("", 25);
        this.iconCode = new JTextField("", 20);
        this.iconType = new JComboBox<String>(this.iconTypes);
        this.iconType.setSelectedIndex(0);
        this.iconGUI = new JComboBox();
        this.iconGUI.addItem("true");
        this.iconGUI.addItem("false");
        JPanel jPanel = new JPanel(new GridLayout(0, 1));
        this.add((Component)jPanel, "South");
        JPanel jPanel2 = new JPanel();
        jPanel2.add(this.imagePath);
        jPanel2.add(this.imageJar);
        jPanel2.add(this.imageDim);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel();
        JLabel jLabel = new JLabel("Icon label: ");
        jPanel2.add(jLabel);
        jPanel2.add(this.iconLabel);
        jLabel = new JLabel("Icon description: ");
        jPanel2.add(jLabel);
        jPanel2.add(this.iconDesc);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel();
        jLabel = new JLabel("Icon code: ");
        jPanel2.add(jLabel);
        jPanel2.add(this.iconCode);
        jLabel = new JLabel("Icon type: ");
        jPanel2.add(jLabel);
        jPanel2.add(this.iconType);
        jLabel = new JLabel("Icon GUI: ");
        jPanel2.add(jLabel);
        jPanel2.add(this.iconGUI);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel();
        this.ok = new JButton("Ok");
        this.ok.setEnabled(false);
        this.ok.addActionListener(this);
        jPanel2.add(this.ok);
        this.cancel = new JButton("Cancel");
        this.cancel.addActionListener(this);
        jPanel2.add(this.cancel);
        this.scroll = new JButton("Scroll to selection");
        this.scroll.setEnabled(false);
        this.scroll.addActionListener(this);
        jPanel2.add(this.scroll);
        jPanel.add(jPanel2);
    }

    public void setIconInfo(IconInfo iconInfo) {
        this.iconInfo = iconInfo;
        if (iconInfo != null) {
            this.images.setSelectedIcon(iconInfo.getIcon());
            this.iconLabel.setText(iconInfo.getLabel());
            this.iconDesc.setText(iconInfo.getDescription());
            this.iconCode.setText(iconInfo.getCode());
            this.iconType.setSelectedItem(iconInfo.getType());
            if (iconInfo.getGUI().equalsIgnoreCase("false")) {
                this.iconGUI.setSelectedItem("false");
            }
        }
    }

    public void scrollToCurrentMiniature() {
        this.images.scrollToCurrentMiniature();
    }

    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (object == this.images) {
            RessourceInfo ressourceInfo = this.images.getSelectedRessource();
            if (ressourceInfo != null) {
                this.ok.setEnabled(true);
                this.scroll.setEnabled(true);
                this.imagePath.setText(ressourceInfo.getResourceName());
                this.imageJar.setText(ressourceInfo.getJarName());
                Dimension dimension = this.images.getIconDimension();
                if (dimension != null) {
                    this.imageDim.setText((int)dimension.getWidth() + " x " + (int)dimension.getHeight());
                } else {
                    this.imageDim.setText("");
                }
            } else {
                this.ok.setEnabled(false);
                this.scroll.setEnabled(false);
                this.imagePath.setText("");
                this.imageJar.setText("");
                this.imageDim.setText("");
            }
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(500, 400);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.ok) {
            if (this.iconInfo == null) {
                if (this.images.getSelectedRessource() != null) {
                    this.iconInfo = new IconInfo();
                    String string = this.imagePath.getText();
                    if (!string.startsWith("/")) {
                        string = "/" + string;
                    }
                    this.iconInfo.setIcon(string);
                    string = (String)this.iconType.getSelectedItem();
                    if (string.equals("")) {
                        string = "Java";
                    }
                    this.iconInfo.setType(string);
                    this.iconInfo.setLabel(this.iconLabel.getText());
                    this.iconInfo.setDescription(this.iconDesc.getText());
                    this.iconInfo.setCode(this.iconCode.getText());
                    this.iconInfo.setGUI(this.iconGUI.getSelectedItem().toString());
                    this.iconAdder.addNewIcon(this.iconInfo);
                }
            } else if (this.images.getSelectedRessource() != null) {
                String string = this.imagePath.getText();
                if (!string.startsWith("/")) {
                    string = "/" + string;
                }
                this.iconInfo.setIcon(string);
                string = (String)this.iconType.getSelectedItem();
                if (string.equals("")) {
                    string = "Java";
                }
                this.iconInfo.setType(string);
                this.iconInfo.setLabel(this.iconLabel.getText());
                this.iconInfo.setDescription(this.iconDesc.getText());
                this.iconInfo.setCode(this.iconCode.getText());
                this.iconInfo.setGUI(this.iconGUI.getSelectedItem().toString());
                this.iconAdder.IconChanged(this.iconInfo);
            }
            this.iconAdder.closeWindow();
        } else if (object == this.cancel) {
            this.iconAdder.closeWindow();
        } else if (object == this.scroll) {
            this.images.scrollToCurrentMiniature();
        }
    }
}

