/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaf.ui;

import com.sun.jaf.ui.DelegateAction;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

class StateChangeAction
extends DelegateAction
implements ItemListener {
    protected boolean selected = false;
    private ItemListener listener;

    StateChangeAction() {
    }

    public boolean isSelected() {
        return this.selected;
    }

    public synchronized void setSelected(boolean newValue) {
        boolean oldValue = this.selected;
        if (oldValue != newValue) {
            this.selected = newValue;
            this.firePropertyChange("selected", oldValue, newValue);
        }
    }

    public void addItemListener(ItemListener listener) {
        this.listener = listener;
    }

    public ItemListener[] getItemListeners() {
        return new ItemListener[]{this.listener};
    }

    public void removeItemListener(ItemListener listener) {
        this.listener = null;
    }

    public void itemStateChanged(ItemEvent evt) {
        boolean oldValue = this.selected;
        boolean newValue = evt.getStateChange() == 1;
        if (oldValue != newValue) {
            this.setSelected(newValue);
            if (this.listener != null) {
                this.listener.itemStateChanged(evt);
            }
        }
    }
}

