/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaf.ui;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;

public abstract class SortableTableModel
extends AbstractTableModel {
    private TableModelComparator comparator = new TableModelComparator();
    private List elements;

    void sortByColumn(int column, boolean ascending) {
        this.comparator.addColumn(column);
        this.comparator.setAscending(ascending);
        if (this.elements != null) {
            Collections.sort(this.elements, this.comparator);
            this.fireTableChanged(new TableModelEvent(this));
        }
    }

    protected void setRowElements(List elements) {
        this.elements = elements;
    }

    boolean isAscending() {
        return this.comparator.isAscending();
    }

    int getColumn() {
        return this.comparator.getColumn();
    }

    public Object getValueForColumn(Object obj, int column) {
        if (obj instanceof List) {
            return ((List)obj).get(column);
        }
        if (obj.getClass().isArray()) {
            return ((Object[])obj)[column];
        }
        return null;
    }

    private class TableModelComparator
    implements Comparator {
        private boolean ascending;
        private int[] columns;

        private TableModelComparator() {
        }

        public void addColumn(int column) {
            if (this.columns == null) {
                this.columns = new int[SortableTableModel.this.getColumnCount()];
                Arrays.fill(this.columns, -1);
            }
            int[] tempArray = new int[SortableTableModel.this.getColumnCount()];
            System.arraycopy(this.columns, 0, tempArray, 1, this.columns.length - 1);
            tempArray[0] = column;
            this.columns = tempArray;
        }

        public int getColumn() {
            if (this.columns == null) {
                return -1;
            }
            return this.columns[0];
        }

        public void setAscending(boolean ascending) {
            this.ascending = ascending;
        }

        public boolean isAscending() {
            return this.ascending;
        }

        public int compare(Object row1, Object row2) {
            if (this.columns == null) {
                return 0;
            }
            for (int i = 0; i < this.columns.length && this.columns[i] != -1; ++i) {
                Object o1 = SortableTableModel.this.getValueForColumn(row1, this.columns[i]);
                Object o2 = SortableTableModel.this.getValueForColumn(row2, this.columns[i]);
                if (o1 == null && o2 == null) {
                    return 0;
                }
                if (o1 == null) {
                    return -1;
                }
                if (o2 == null) {
                    return 1;
                }
                int result = 0;
                if (o1 instanceof Comparable) {
                    Comparable c1 = (Comparable)o1;
                    Comparable c2 = (Comparable)o2;
                    result = c1.compareTo(c2);
                }
                if (result == 0) continue;
                return this.ascending ? result : -result;
            }
            return 0;
        }
    }
}

